/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view.wizard;

import com.jidesoft.wizard.DefaultWizardPage;
import com.mathworks.toolbox.distcomp.admincenter.services.model.StartMDCEWizardModel;
import com.mathworks.toolbox.distcomp.admincenter.services.view.wizard.HelpSupport;
import com.mathworks.toolbox.distcomp.remote.Credential;
import com.mathworks.toolbox.distcomp.remote.CredentialParameter;
import com.mathworks.toolbox.distcomp.remote.IdentityFileCredential;
import com.mathworks.toolbox.distcomp.remote.IdentityFileCredentialDescription;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.Password;
import com.mathworks.toolbox.distcomp.remote.PasswordCredential;
import com.mathworks.toolbox.distcomp.remote.PasswordCredentialDescription;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.LocalShellSender;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.SshParameter;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ConfirmPage
extends DefaultWizardPage
implements HelpSupport {
    private static final String HELP_PAGE_ANCHOR = "AC_START_WIZ_CONFIRM";
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.admincenter.services.view.resources.RES_view");
    private static ResourceBundle sParameterPanelRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");

    public ConfirmPage(StartMDCEWizardModel startMDCEWizardModel) {
        super(sRes.getString("services.dialog.startmdce.confirm.step"));
        this.addComponent((JComponent)((Object)new ConfirmUI(startMDCEWizardModel)), true);
    }

    public void setupWizardButtons() {
        this.fireButtonEvent(3301, "BACK");
        this.fireButtonEvent(3299, "BACK");
        this.fireButtonEvent(3300, "NEXT");
        this.fireButtonEvent(3300, "FINISH");
        this.fireButtonEvent(3299, "start");
        this.fireButtonEvent(3301, "start");
        this.fireButtonEvent(3307, "start");
        this.fireButtonEvent(3299, "CANCEL");
        this.fireButtonEvent(3301, "CANCEL");
    }

    @Override
    public String getHelpPageShortCut() {
        return HELP_PAGE_ANCHOR;
    }

    private static class ConfirmUI
    extends StyleGuidePanel
    implements PropertyChangeListener {
        private StartMDCEWizardModel iStartMDCEWizardModel;
        private JLabel iConfirmLabel;
        private static final String PASSWORD_DOT_STR = "&#9679;";
        private static final CredentialParameter SC_CREDENTIAL = LocalShellSender.LOCAL_PARAMETER_SET.getCredentialParameter();
        private static final int MAX_STRING_LENGTH = 60;

        private ConfirmUI(StartMDCEWizardModel startMDCEWizardModel) {
            this.iStartMDCEWizardModel = startMDCEWizardModel;
            this.iStartMDCEWizardModel.addPropertyChangeListener(this);
            this.iConfirmLabel = new JLabel();
            this.updateText();
            this.addLine(this.iConfirmLabel);
            this.addLine((JComponent)((Object)new StyleGuideEmptyPanel()), 8);
            this.iConfirmLabel.setName("StartMDCEWizard.ConfirmPage.ConfirmLabel");
        }

        private void updateText() {
            String string = this.getProtocol();
            String string2 = this.getRemoteCommunicationText();
            String string3 = MessageFormat.format(sRes.getString("services.dialog.startmdce.confirm.label"), this.iStartMDCEWizardModel.getHostNames().size(), this.iStartMDCEWizardModel.getPlatformType().toString().toLowerCase(), ConfirmUI.abbreviate(this.iStartMDCEWizardModel.getMatlabRoot(), 60), ConfirmUI.abbreviate(this.iStartMDCEWizardModel.getMdceDefFile(), 60), string, string2);
            this.iConfirmLabel.setText(string3);
        }

        private static String abbreviate(String string, int n) {
            String string2 = string;
            if (string.length() > n) {
                int n2 = n / 2 - 1;
                int n3 = 0;
                int n4 = n2;
                int n5 = string.length() - n2 - 1;
                int n6 = string.length();
                string2 = string.substring(n3, n4) + "..." + string.substring(n5, n6);
            }
            return string2;
        }

        private String getProtocol() {
            ParameterSet parameterSet = StartMDCEWizardModel.getParameterSet(this.iStartMDCEWizardModel.getPlatformType());
            if (!parameterSet.hasCredentialParameter() || parameterSet.getCredentialParameter().equals(SC_CREDENTIAL)) {
                return sParameterPanelRes.getString("remote.credentialparameter.sc");
            }
            if (parameterSet.getCredentialParameter().equals(SshParameter.SSH_CREDENTIAL)) {
                return sParameterPanelRes.getString("remote.credentialparameter.ssh");
            }
            assert (false) : "Unknown protocol " + parameterSet.getCredentialParameter();
            return "";
        }

        private String getRemoteCommunicationText() {
            ParameterSet parameterSet = StartMDCEWizardModel.getParameterSet(this.iStartMDCEWizardModel.getPlatformType());
            if (!parameterSet.hasCredentialParameter()) {
                return "";
            }
            ParameterMap parameterMap = this.iStartMDCEWizardModel.getParameterMap();
            Credential credential = parameterMap.get(parameterSet.getCredentialParameter());
            if (credential == null) {
                return "";
            }
            if (credential instanceof PasswordCredential) {
                String string = credential.getParameterMap().get(PasswordCredentialDescription.USERNAME);
                Password password = credential.getParameterMap().get(PasswordCredentialDescription.PASSWORD);
                String string2 = ConfirmUI.createEncrytedTextForHtml(password);
                return MessageFormat.format(sRes.getString("services.dialog.startmdce.confirm.passwordcredentiallabel"), string, string2);
            }
            if (credential instanceof IdentityFileCredential) {
                String string = credential.getParameterMap().get(IdentityFileCredentialDescription.USERNAME);
                File file = credential.getParameterMap().get(IdentityFileCredentialDescription.IDENTITY_FILE);
                String string3 = "";
                try {
                    string3 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Password password = credential.getParameterMap().get(IdentityFileCredentialDescription.PASSPHRASE);
                String string4 = ConfirmUI.createEncrytedTextForHtml(password);
                return MessageFormat.format(sRes.getString("services.dialog.startmdce.confirm.identityfilecredentiallabel"), string, string3, string4);
            }
            assert (false) : "Unsupported credential " + credential;
            return "";
        }

        private static String createEncrytedTextForHtml(Password password) {
            String string = "";
            if (password != null) {
                for (int i = 0; i <= password.getPassword().length; ++i) {
                    string = string + PASSWORD_DOT_STR;
                }
            }
            return string;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateText();
        }

        @Override
        protected int getLeftInset() {
            return 0;
        }

        @Override
        protected int getRightInset() {
            return 0;
        }
    }
}

