/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.dependency;

import com.mathworks.toolbox.distcomp.admincenter.testing.infra.dependency.Dependency;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.Test;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.NotResolvedException;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import java.util.Vector;

public class DependencyList {
    private Vector<Dependency> fDependencies = new Vector();

    public void addDependency(Dependency dependency) {
        assert (dependency != null) : "attempt to add null dependency";
        this.fDependencies.addElement(dependency);
    }

    public boolean allDependenciesResolved() {
        for (Dependency dependency : this.fDependencies) {
            if (dependency.canResolve()) continue;
            String string = dependency.getClass().getName();
            int n = string.lastIndexOf(46) + 1;
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Dependency: " + string.substring(n) + " (" + dependency.getSource() + ") " + "cannot be resolved yet.");
            return false;
        }
        return true;
    }

    public void updateTestWithDependencies(Test test) throws NotResolvedException {
        for (Dependency dependency : this.fDependencies) {
            dependency.updateTest(test);
        }
    }
}

