/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal;

import com.mathworks.toolbox.distcomp.admincenter.testing.infra.TestCleanupManager;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal.CommandSet;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.CleanableTest;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunIdentifier;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.CleanupFailureException;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.LockingException;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestCategory;
import com.mathworks.toolbox.distcomp.control.RunCommandSender;
import com.mathworks.toolbox.distcomp.control.StatusResults;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class SystemCommandSet
implements CommandSet,
Serializable {
    @Override
    public String getHostName(String string) throws UnknownHostException {
        return InetAddress.getByName(string).getHostName();
    }

    @Override
    public String getCanonicalHostName(String string) throws UnknownHostException {
        return InetAddress.getByName(string).getCanonicalHostName();
    }

    @Override
    public String getHostAddress(String string) throws UnknownHostException {
        return InetAddress.getByName(string).getHostAddress();
    }

    @Override
    public Boolean isReachable(String string, int n) throws IOException {
        return InetAddress.getByName(string).isReachable(n);
    }

    @Override
    public String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    @Override
    public Set<InetAddress> getAddressList() throws SocketException {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                hashSet.add(enumeration2.nextElement());
            }
        }
        return hashSet;
    }

    @Override
    public Set<InetAddress> getAddressList(String string) throws UnknownHostException {
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        for (InetAddress inetAddress : inetAddressArray) {
            hashSet.add(inetAddress);
        }
        return hashSet;
    }

    @Override
    public Boolean isLoopbackAddress(String string) throws UnknownHostException {
        return InetAddress.getByName(string).isLoopbackAddress();
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException {
        return new Socket(string, n);
    }

    @Override
    public ServerSocket createServerSocket(int n) throws IOException {
        return new ServerSocket(n);
    }

    @Override
    public String readLine(BufferedReader bufferedReader) throws IOException {
        return bufferedReader.readLine();
    }

    @Override
    public void lockDownForTesting(RunIdentifier runIdentifier) throws LockingException {
        TestCleanupManager.instance().lockDownForTesting(runIdentifier);
    }

    @Override
    public void releaseLockDownForTesting(RunIdentifier runIdentifier) throws LockingException {
        TestCleanupManager.instance().releaseLockDownForTesting(runIdentifier);
    }

    @Override
    public void addTestToCleanupManager(CleanableTest cleanableTest, RunIdentifier runIdentifier) throws LockingException {
        TestCleanupManager.instance().addTestToCleanupManager(cleanableTest, runIdentifier);
    }

    @Override
    public void cleanupTests(TestCategory testCategory, RunIdentifier runIdentifier) throws CleanupFailureException, LockingException {
        TestCleanupManager.instance().cleanupTests(testCategory, runIdentifier);
    }

    @Override
    public StatusResults getStatusResults(String string, int n) {
        return RunCommandSender.getStatusResults(string, n);
    }

    @Override
    public String getServerHostname() {
        return System.getProperty("com.mathworks.toolbox.distcomp.hostname", null);
    }
}

