/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.model;

import com.mathworks.toolbox.distcomp.admincenter.testing.model.JobManagerData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.MutableDataObject;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.NodeData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.SchedulerData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultsContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public class ClusterData
extends MutableDataObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 6076351089385413357L;
    private final LinkedHashSet<NodeData> fNodes = new LinkedHashSet();
    private NodeData fSchedulerNode;
    private TestResultsContainer fTestResultsContainer;
    private SchedulerData fSchedulerData = new JobManagerData();

    public ClusterData() {
    }

    public ClusterData(Collection<String> collection, int n) {
        ArrayList<NodeData> arrayList = new ArrayList<NodeData>();
        for (String string : collection) {
            arrayList.add(new NodeData(string));
        }
        this.setNodes(arrayList);
        this.setSchedulerData(new JobManagerData(n));
    }

    public synchronized NodeData[] getAllNodes() {
        return this.fNodes.toArray(new NodeData[0]);
    }

    public synchronized NodeData getSchedulerNode() {
        return this.fSchedulerNode;
    }

    public synchronized int getNodeCount() {
        return this.fNodes.size();
    }

    public synchronized void setSchedulerNode(NodeData nodeData) {
        if (this.fSchedulerNode != null && this.fSchedulerNode.equals(nodeData)) {
            return;
        }
        this.fSchedulerNode = nodeData;
        if (nodeData != null && !this.containsNode(nodeData)) {
            this.addNode(nodeData);
        }
        this.fireStateChange();
    }

    public synchronized boolean containsNode(NodeData nodeData) {
        return this.fNodes.contains(nodeData);
    }

    public synchronized boolean containsAnyNodes(NodeData[] nodeDataArray) {
        for (NodeData nodeData : nodeDataArray) {
            if (!this.containsNode(nodeData)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addNode(NodeData nodeData) {
        if (nodeData == null) {
            throw new IllegalArgumentException("Node must be non-null.");
        }
        if (nodeData.getHostname().length() == 0) {
            throw new IllegalArgumentException("Node hostname cannot be blank.");
        }
        if (this.containsNode(nodeData)) {
            throw new IllegalArgumentException("Cannot add the same node/hostname. Should call containsNode() first.");
        }
        this.fNodes.add(nodeData);
        this.fireStateChange();
    }

    public synchronized void removeNode(NodeData nodeData) {
        this.removeNodes(Arrays.asList(nodeData));
    }

    public synchronized void removeNodes(Collection<NodeData> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Node must be non-null.");
        }
        if (!this.fNodes.containsAll(collection)) {
            throw new IllegalArgumentException("There are nodes not in the cluster.");
        }
        if (collection.contains(this.getSchedulerNode())) {
            this.setSchedulerNode(null);
        }
        this.fNodes.removeAll(collection);
        this.fireStateChange();
    }

    public synchronized void addNodes(List<NodeData> list) {
        this.doAddNodes(list, true);
    }

    public synchronized void setNodes(List<NodeData> list) {
        this.doAddNodes(list, false);
    }

    public synchronized NodeData[] getWorkerNodes() {
        if (this.fSchedulerNode == null) {
            return new ArrayList<NodeData>(this.fNodes).toArray(new NodeData[0]);
        }
        ArrayList<NodeData> arrayList = new ArrayList<NodeData>();
        for (NodeData nodeData : this.fNodes) {
            if (nodeData.equals(this.fSchedulerNode)) continue;
            arrayList.add(nodeData);
        }
        return arrayList.toArray(new NodeData[0]);
    }

    public synchronized boolean isSchedulerNode(NodeData nodeData) {
        return this.fSchedulerNode != null && this.fSchedulerNode.equals(nodeData);
    }

    public synchronized TestResultsContainer getTestResultsContainer() {
        return this.fTestResultsContainer;
    }

    public synchronized void setTestResultsContainer(TestResultsContainer testResultsContainer) {
        this.fTestResultsContainer = testResultsContainer;
        this.fireStateChange();
    }

    public synchronized void replaceNode(NodeData nodeData, NodeData nodeData2) {
        if (!this.containsNode(nodeData)) {
            throw new IllegalArgumentException("Replaced node must already belong to this ClusterData.");
        }
        if (nodeData.equals(nodeData2)) {
            return;
        }
        if (nodeData2 == null) {
            throw new IllegalArgumentException("Node must be non-null.");
        }
        if (nodeData2.getHostname().length() == 0) {
            throw new IllegalArgumentException("Node hostname cannot be blank.");
        }
        if (this.containsNode(nodeData2)) {
            throw new IllegalArgumentException("New node must not belong to this ClusterData.");
        }
        ArrayList<NodeData> arrayList = new ArrayList<NodeData>(this.fNodes);
        arrayList.set(arrayList.indexOf(nodeData), nodeData2);
        this.fNodes.clear();
        this.fNodes.addAll(arrayList);
        if (nodeData.equals(this.getSchedulerNode())) {
            this.fSchedulerNode = nodeData2;
        }
        this.fireStateChange();
    }

    public synchronized SchedulerData getSchedulerData() {
        return this.fSchedulerData;
    }

    public synchronized void setSchedulerData(SchedulerData schedulerData) {
        if (schedulerData == null) {
            throw new IllegalArgumentException("SchedulerData must be non-null.");
        }
        if (schedulerData.equals(this.fSchedulerData)) {
            return;
        }
        this.fSchedulerData = schedulerData;
        this.fireStateChange();
    }

    public synchronized ClusterData clone() {
        ClusterData clusterData = new ClusterData();
        clusterData.addNodes(new ArrayList<NodeData>(this.fNodes));
        clusterData.setSchedulerData(this.fSchedulerData);
        clusterData.setSchedulerNode(this.fSchedulerNode);
        clusterData.setTestResultsContainer(this.fTestResultsContainer);
        return clusterData;
    }

    private synchronized void doAddNodes(List<NodeData> list, boolean bl) {
        LinkedHashSet<NodeData> linkedHashSet = bl ? new LinkedHashSet<NodeData>(this.fNodes) : new LinkedHashSet();
        int n = linkedHashSet.size();
        linkedHashSet.addAll(list);
        if (linkedHashSet.contains(null)) {
            throw new IllegalArgumentException("Nodes must be non-null.");
        }
        if (linkedHashSet.contains(new NodeData(""))) {
            throw new IllegalArgumentException("Nodes hostname cannot be blank.");
        }
        if (linkedHashSet.size() < list.size() + n) {
            throw new IllegalArgumentException("No duplicate nodes are allowed.");
        }
        this.fNodes.clear();
        this.fNodes.addAll(linkedHashSet);
        if (!bl && this.fSchedulerNode != null && !this.containsNode(this.fSchedulerNode)) {
            this.fSchedulerNode = null;
        }
        this.fireStateChange();
    }
}

