/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.model;

import com.mathworks.toolbox.distcomp.admincenter.testing.model.ClusterData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.ProgressData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.ProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultsContainer;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestCategory;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestResult;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestingCallback;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestingToken;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TestingMonitor
implements TestingCallback {
    private final ArrayList<TestResultData> fResults = new ArrayList();
    private Date fStartTime;
    private Date fStopTime;
    private int fExpectedResultCount;
    private final int[] fExpectedCategoryCounts = new int[TestCategory.values().length];
    private final int[] fCountsByCategory = new int[TestCategory.values().length];
    private final ArrayList<ProgressListener> fProgressListeners = new ArrayList();
    private final ClusterData fCluster;
    private TestingToken fToken;

    public TestingMonitor(ClusterData clusterData) {
        this.fCluster = clusterData;
    }

    public synchronized void startMonitoring(TestingToken testingToken, Date date) {
        if (this.hasMonitoringingStarted()) {
            throw new IllegalStateException("Cannot start testing. Already started.");
        }
        if (testingToken == null || date == null) {
            throw new IllegalArgumentException("testingToken and startTime must be non-null");
        }
        if (date.after(new Date())) {
            throw new IllegalArgumentException("startTime must occur in the past");
        }
        this.fStartTime = date;
        this.fToken = testingToken;
        this.fExpectedResultCount = 0;
        Map<TestCategory, Integer> map = testingToken.getExpectedResultCounts();
        for (TestCategory testCategory : TestCategory.values()) {
            int n;
            Integer n2 = map.get((Object)testCategory);
            this.fExpectedCategoryCounts[testCategory.ordinal()] = n = n2 == null ? 0 : n2;
            this.fExpectedResultCount += n;
        }
        this.updateProgress();
    }

    @Override
    public synchronized void consumeTestResult(TestResult testResult) {
        if (this.isTestingCancelled()) {
            return;
        }
        this.fResults.add(new TestResultData(testResult));
        int n = testResult.getTestCategory().ordinal();
        this.fCountsByCategory[n] = this.fCountsByCategory[n] + 1;
        if (this.isTestingRunning()) {
            this.updateProgress();
        }
    }

    public synchronized boolean isTestingDone() {
        return this.fStopTime != null;
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        this.fProgressListeners.add(progressListener);
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        this.fProgressListeners.remove(progressListener);
    }

    public synchronized TestResultData[] getTestResults() {
        return this.fResults.toArray(new TestResultData[0]);
    }

    public synchronized Date getStartTime() {
        return this.fStartTime;
    }

    public synchronized Date getStopTime() {
        return this.fStopTime;
    }

    public synchronized long getRunTime() {
        if (this.fStartTime == null) {
            return 0L;
        }
        long l = this.fStopTime == null ? System.currentTimeMillis() : this.fStopTime.getTime();
        return l - this.fStartTime.getTime();
    }

    public synchronized int getExpectedResultCount() {
        return this.fExpectedResultCount;
    }

    private void updateProgress() {
        if (this.fResults.size() == this.fExpectedResultCount) {
            this.fStopTime = new Date();
            this.fCluster.setTestResultsContainer(new TestResultsContainer(this.fStartTime, this.fStopTime, this.fResults));
        }
        if (this.fProgressListeners == null) {
            return;
        }
        Map<TestCategory, ProgressData.RunStatus> map = this.generateStatuses();
        for (ProgressListener progressListener : this.fProgressListeners) {
            progressListener.progressUpdate(new ProgressData(this.fResults.size(), this.fExpectedResultCount, map));
            if (!this.isTestingDone()) continue;
            progressListener.testingDone();
        }
    }

    private Map<TestCategory, ProgressData.RunStatus> generateStatuses() {
        HashMap<TestCategory, ProgressData.RunStatus> hashMap = new HashMap<TestCategory, ProgressData.RunStatus>();
        for (TestCategory testCategory : TestCategory.values()) {
            ProgressData.RunStatus runStatus = ProgressData.RunStatus.UNKNOWN;
            if (this.fCountsByCategory[testCategory.ordinal()] >= this.fExpectedCategoryCounts[testCategory.ordinal()]) {
                runStatus = ProgressData.RunStatus.COMPLETED;
            } else if (this.fCountsByCategory[testCategory.ordinal()] > 0) {
                runStatus = ProgressData.RunStatus.IN_PROGRESS;
            }
            hashMap.put(testCategory, runStatus);
        }
        return hashMap;
    }

    private boolean hasMonitoringingStarted() {
        return this.fStartTime != null && this.fToken != null;
    }

    private boolean isTestingRunning() {
        return this.hasMonitoringingStarted() && !this.isTestingDone();
    }

    private boolean isTestingCancelled() {
        return this.hasMonitoringingStarted() && this.fToken.isCancelled();
    }
}

