/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth;

import com.mathworks.toolbox.distcomp.auth.AbstractInvocationWithAuth;
import com.mathworks.toolbox.distcomp.auth.InvalidAdminPasswordException;
import com.mathworks.toolbox.distcomp.auth.NotAdminUserException;
import com.mathworks.toolbox.distcomp.auth.RemoteAuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CurrentTokenReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderImpl;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import java.rmi.RemoteException;

public abstract class InvocationAdminOnly<T>
extends AbstractInvocationWithAuth<T> {
    public static final int MAX_ATTEMPTS = 3;

    protected InvocationAdminOnly(UserIdentity userIdentity) {
        super(userIdentity);
    }

    @Override
    public synchronized T makeInvocation(CredentialStore<AuthenticationToken> credentialStore, RemoteAuthorisationModule remoteAuthorisationModule) throws RemoteException, MJSException {
        int n = this.isInteractive() ? 3 : 0;
        CredentialProviderImpl credentialProviderImpl = this.makeCredentialProvider();
        this.setCredentialProvider(credentialProviderImpl.getProxy());
        CurrentTokenReturn currentTokenReturn = null;
        UserIdentity userIdentity = this.getUserIdentity();
        while (true) {
            try {
                Object t = this.invoke();
                return t;
            }
            catch (NotAdminUserException notAdminUserException) {
                currentTokenReturn = remoteAuthorisationModule.promptForCurrentPassword(userIdentity, notAdminUserException);
            }
            catch (InvalidAdminPasswordException invalidAdminPasswordException) {
                if (n < 1) {
                    throw invalidAdminPasswordException;
                }
                --n;
                currentTokenReturn = remoteAuthorisationModule.promptForCurrentPassword(userIdentity, invalidAdminPasswordException);
            }
            {
                credentialProviderImpl.getCredentialStore().putCredentials(currentTokenReturn.getCurrentToken());
                continue;
            }
            break;
        }
        finally {
            if (currentTokenReturn != null) {
                currentTokenReturn.getCurrentToken().erase();
            }
            credentialProviderImpl.unexport();
        }
    }
}

