/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.store;

import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.MultiUserCredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.MultiUserPersistentCredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.PackageInfo;
import com.mathworks.toolbox.distcomp.auth.credentials.store.SingleUserCredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.SingleUserPersistentCredentialStore;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class CredentialStoreFactory
implements Serializable {
    private static Map<String, CredentialStore<AuthenticationToken>> sCredentialStores = new HashMap<String, CredentialStore<AuthenticationToken>>();
    private boolean fAllowClientPasswordCache;
    private final boolean fAllowMultipleUsers;

    public CredentialStoreFactory(boolean bl) {
        this.fAllowClientPasswordCache = bl;
        this.fAllowMultipleUsers = true;
    }

    public CredentialStore<AuthenticationToken> createCredentialStore(String string) {
        if (sCredentialStores.containsKey(string)) {
            return sCredentialStores.get(string);
        }
        try {
            if (this.fAllowClientPasswordCache) {
                CredentialStore<AuthenticationToken> credentialStore = this.createPersistentCredentialStore(string);
                sCredentialStores.put(string, credentialStore);
                return credentialStore;
            }
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to create persistent credential store (reason: " + iOException.getMessage() + "). Credentials will not be stored on disk.");
        }
        CredentialStore<AuthenticationToken> credentialStore = this.createCredentialStore();
        sCredentialStores.put(string, credentialStore);
        return credentialStore;
    }

    private CredentialStore<AuthenticationToken> createCredentialStore() {
        MultiUserCredentialStore<AuthenticationToken> multiUserCredentialStore = this.fAllowMultipleUsers ? new MultiUserCredentialStore<AuthenticationToken>() : new SingleUserCredentialStore();
        return multiUserCredentialStore;
    }

    private CredentialStore<AuthenticationToken> createPersistentCredentialStore(String string) throws IOException {
        MultiUserPersistentCredentialStore multiUserPersistentCredentialStore = this.fAllowMultipleUsers ? new MultiUserPersistentCredentialStore(string) : new SingleUserPersistentCredentialStore(string);
        return multiUserPersistentCredentialStore;
    }
}

