/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.store;

import com.mathworks.toolbox.distcomp.auth.credentials.Credentials;
import com.mathworks.toolbox.distcomp.auth.credentials.NontransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderImpl;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialTransferException;
import com.mathworks.toolbox.distcomp.auth.credentials.store.MultiUserCredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.NoCredentialsException;
import com.mathworks.toolbox.distcomp.auth.modules.CryptoModuleTrivialImpl;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import java.rmi.RemoteException;

public class RemoteCredentialStorer {
    private CredentialProviderImpl<Credentials> fRemoteCredentialProvider = null;
    private CredentialStore<Credentials> fCredentialStore = new MultiUserCredentialStore<Credentials>();

    public RemoteCredentialStorer(ExporterFactory exporterFactory) {
        this.fRemoteCredentialProvider = new CredentialProviderImpl<Credentials>(this.fCredentialStore, exporterFactory.createExporter());
    }

    public CredentialProviderLocal putCredentialsInCredentialStore(CredentialProviderLocal credentialProviderLocal, UserIdentity userIdentity) throws CredentialTransferException, RemoteException {
        assert (credentialProviderLocal != null) : "The credential provider must not be null";
        try {
            NontransferableCredentials nontransferableCredentials = credentialProviderLocal.getCredentials(userIdentity, new CryptoModuleTrivialImpl());
            this.fCredentialStore.putCredentials(nontransferableCredentials);
            return this.fRemoteCredentialProvider.getProxy();
        }
        catch (CredentialTransferException credentialTransferException) {
            if (credentialTransferException.getCause() instanceof NoCredentialsException) {
                return credentialProviderLocal;
            }
            throw credentialTransferException;
        }
    }

    public void dispose() {
        if (this.fRemoteCredentialProvider != null) {
            this.fRemoteCredentialProvider.unexport();
            this.fRemoteCredentialProvider = null;
        }
    }
}

