/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.toolbox.distcomp.auth.AuthorisationModuleConfig;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.RemoteAuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.PlainCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.ChangePasswordReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerConfig;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CurrentTokenReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NewPasswordReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NoCredentialsEnteredException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.RememberChoice;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.SingleUserCredentialStore;
import com.mathworks.toolbox.distcomp.auth.modules.AuthorisationModuleImpl;
import com.mathworks.toolbox.distcomp.auth.modules.DialogUnavailableException;
import com.mathworks.toolbox.distcomp.auth.modules.RemoteAuthorisationModuleImpl;

public final class AuthorisationModuleWithWarningImpl
extends AuthorisationModuleImpl {
    private final CredentialConsumerConfig fConsumerConfig;

    public AuthorisationModuleWithWarningImpl(AuthorisationModuleConfig authorisationModuleConfig) {
        super(authorisationModuleConfig);
        this.fConsumerConfig = authorisationModuleConfig.createCredentialConsumerConfig();
    }

    @Override
    public RemoteAuthorisationModule getRemoteAuthorisationModule() {
        return new RemoteAMWithWarningImpl(this.fConsumerConfig);
    }

    private static class RemoteAMWithWarningImpl
    extends RemoteAuthorisationModuleImpl {
        private static final long serialVersionUID = 1295540230222976480L;

        public RemoteAMWithWarningImpl(CredentialConsumerConfig credentialConsumerConfig) {
            super(credentialConsumerConfig);
        }

        @Override
        public RemoteAMWithWarningImpl copy() {
            return new RemoteAMWithWarningImpl(this.getConsumerConfig());
        }

        @Override
        public CurrentTokenReturn promptForCurrentPassword(UserIdentity userIdentity, Throwable throwable) {
            PlainCredentials plainCredentials = new PlainCredentials(userIdentity, new Erasable());
            AuthenticationToken authenticationToken = plainCredentials.createAuthenticationToken(new CryptoModule.Hasher(){

                @Override
                public Erasable createHash(Erasable erasable) {
                    return erasable;
                }
            });
            return new CurrentTokenReturn(authenticationToken, RememberChoice.SESSION);
        }

        @Override
        public NewPasswordReturn promptForNewPassword(UserIdentity userIdentity) {
            PlainCredentials plainCredentials = new PlainCredentials(userIdentity, new Erasable());
            AuthenticationToken authenticationToken = plainCredentials.createAuthenticationToken(new CryptoModule.Hasher(){

                @Override
                public Erasable createHash(Erasable erasable) {
                    return erasable;
                }
            });
            return new NewPasswordReturn(plainCredentials, authenticationToken, RememberChoice.SESSION);
        }

        @Override
        public ChangePasswordReturn promptForChangePassword(UserIdentity userIdentity, UserIdentity userIdentity2) {
            return null;
        }

        @Override
        public CurrentTokenReturn promptForTemporaryUserSwitch(UserIdentity userIdentity) throws DialogUnavailableException, NoCredentialsEnteredException {
            return this.getConsumer(userIdentity).promptForTemporaryUserSwitch(userIdentity);
        }

        @Override
        public UserIdentity promptForIdentity(UserIdentity userIdentity) throws DialogUnavailableException, NoCredentialsEnteredException {
            return this.getConsumer(userIdentity).promptForIdentity(userIdentity);
        }

        @Override
        public final CredentialStore<AuthenticationToken> createCredentialStore(String string) {
            return new SingleUserCredentialStore<AuthenticationToken>();
        }
    }
}

