/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.toolbox.distcomp.remote.ListFileAttributesFuture;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class SharedPath {
    private final String fRelativePath;

    SharedPath(String string) {
        this.fRelativePath = string;
    }

    SharedPath(File file, File file2) {
        this.fRelativePath = SharedPath.localFileToRelativePath(file, file2);
    }

    String getRelativePath() {
        return this.fRelativePath;
    }

    String getRemotePath(String string) {
        return string + "/" + this.fRelativePath;
    }

    File getLocalPath(File file) {
        String string = SharedPath.convertToLocalSeparators(this.fRelativePath);
        return new File(file, string);
    }

    private static String convertToLocalSeparators(String string) {
        char c;
        char c2 = File.separatorChar;
        switch (c2) {
            case '\\': {
                c = '/';
                break;
            }
            case '/': {
                c = '\\';
                break;
            }
            default: {
                throw new IllegalStateException("Unknown path separator char");
            }
        }
        return string.replace(c, c2);
    }

    boolean containsPath(Set<SharedPath> set) {
        String string = this.getRelativePath();
        int n = string.length();
        for (SharedPath sharedPath : set) {
            String string2 = sharedPath.getRelativePath();
            int n2 = string2.length();
            if (n < n2 || string.indexOf(string2) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof SharedPath) {
            SharedPath sharedPath = (SharedPath)object;
            return this.fRelativePath.equals(sharedPath.getRelativePath());
        }
        return false;
    }

    public int hashCode() {
        return this.fRelativePath.hashCode();
    }

    public String toString() {
        return this.fRelativePath;
    }

    static Map<SharedPath, ListFileAttributesFuture.FileAttributes> remotePathKeysToSharedPathKeys(Map<String, ListFileAttributesFuture.FileAttributes> map, String string) {
        LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes> linkedHashMap = new LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes>(map.size());
        for (String string2 : map.keySet()) {
            String string3 = SharedPath.remotePathToRelativePath(string2, string);
            SharedPath sharedPath = new SharedPath(string3);
            linkedHashMap.put(sharedPath, map.get(string2));
        }
        return linkedHashMap;
    }

    static Set<SharedPath> remotePathsToSharedPaths(Set<String> set, String string) {
        LinkedHashSet<SharedPath> linkedHashSet = new LinkedHashSet<SharedPath>(set.size());
        for (String string2 : set) {
            String string3 = SharedPath.remotePathToRelativePath(string2, string);
            linkedHashSet.add(new SharedPath(string3));
        }
        return linkedHashSet;
    }

    static Set<SharedPath> relativePathsToSharedPaths(Set<String> set) {
        LinkedHashSet<SharedPath> linkedHashSet = new LinkedHashSet<SharedPath>(set.size());
        for (String string : set) {
            linkedHashSet.add(new SharedPath(string));
        }
        return linkedHashSet;
    }

    static Set<String> sharedPathsToRemotePaths(Set<SharedPath> set, String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(set.size());
        for (SharedPath sharedPath : set) {
            String string2 = sharedPath.getRemotePath(string);
            linkedHashSet.add(string2);
        }
        return linkedHashSet;
    }

    static Set<File> sharedPathsToLocalFiles(Set<SharedPath> set, File file) {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>(set.size());
        for (SharedPath sharedPath : set) {
            File file2 = sharedPath.getLocalPath(file);
            linkedHashSet.add(file2);
        }
        return linkedHashSet;
    }

    private static String remotePathToRelativePath(String string, String string2) {
        if (string.equals(string2)) {
            return "";
        }
        return string.substring(string2.length() + 1);
    }

    private static String localFileToRelativePath(File file, File file2) {
        String string = "";
        while (!file2.equals(file) && file != null) {
            string = "/" + file.getName() + string;
            file = file.getParentFile();
        }
        assert (file != null) : file2.toString() + " does not contain " + file;
        return string;
    }
}

