/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.util.FormattableException;
import java.io.Serializable;

public class ControlExceptionFactory<K>
implements Serializable {
    public DistcompDiagnosticException diagnoseWithServiceType(Throwable throwable, K k, String string) {
        return new ServiceTypeException(throwable, k, string);
    }

    public DistcompDiagnosticException diagnoseWithHostAndPort(Throwable throwable, K k, String string, Object object) {
        return new HostPortException(throwable, k, string, object);
    }

    public DistcompDiagnosticException diagnoseWithHostAndError(Throwable throwable, K k, String string, Throwable throwable2) {
        return new HostRemoteException(throwable, k, string, throwable2);
    }

    public DistcompDiagnosticException diagnoseWithServiceName(Throwable throwable, K k, String string) {
        return new ServiceNameException(throwable, k, string);
    }

    public DistcompDiagnosticException diagnoseWithDirPath(Throwable throwable, K k, String string) {
        return new DirPathException(throwable, k, string);
    }

    public DistcompDiagnosticException diagnose(Throwable throwable, K k, Object ... objectArray) {
        return new ControlDiagnosticException(throwable, k, objectArray);
    }

    public FormattableException createFormattableException(Throwable throwable, K k, Object ... objectArray) {
        return new ControlFormattableException(throwable, k, objectArray);
    }

    private static class HostRemoteException
    extends HostException
    implements ErrorGetter {
        private final Throwable fError;

        public HostRemoteException(Throwable throwable, Object object, String string, Throwable throwable2) {
            super(throwable, object, string, HostRemoteException.getErrorParam(throwable2));
            this.fError = throwable2;
        }

        @Override
        public Throwable getError() {
            return this.fError;
        }

        private static Object getErrorParam(Throwable throwable) {
            assert (throwable != null) : "remoteError must not be null.";
            return throwable instanceof FormattableException ? throwable : throwable.getMessage();
        }
    }

    private static class HostPortException
    extends HostException
    implements PortGetter {
        public HostPortException(Throwable throwable, Object object, String string, Object object2) {
            super(throwable, object, string, object2);
        }

        @Override
        public String getPort() {
            return this.getParams()[1].toString();
        }

        @Override
        public String getMessage() {
            if (this.getCause() != null) {
                return super.getMessage() + ": " + this.getCause().getMessage();
            }
            return super.getMessage();
        }
    }

    private static abstract class HostException
    extends ControlDiagnosticException
    implements HostGetter {
        public HostException(Throwable throwable, Object object, String string, Object object2) {
            super(throwable, object, string, object2);
        }

        @Override
        public String getHost() {
            return (String)this.getParams()[0];
        }
    }

    private static class ServiceTypeException
    extends ControlDiagnosticException
    implements ServiceTypeGetter {
        public ServiceTypeException(Throwable throwable, Object object, String string) {
            super(throwable, object, string);
        }

        @Override
        public String getServiceType() {
            return (String)this.getParams()[0];
        }
    }

    private static class ServiceNameException
    extends ControlDiagnosticException
    implements ServiceNameGetter {
        public ServiceNameException(Throwable throwable, Object object, String string) {
            super(throwable, object, string);
        }

        @Override
        public String getServiceName() {
            return (String)this.getParams()[0];
        }
    }

    private static class DirPathException
    extends ControlDiagnosticException
    implements DirPathGetter {
        public DirPathException(Throwable throwable, Object object, String string) {
            super(throwable, object, string);
        }

        @Override
        public String getDirPath() {
            return (String)this.getParams()[0];
        }
    }

    private static class ControlDiagnosticException
    extends DistcompDiagnosticException {
        public ControlDiagnosticException(Throwable throwable, Object object, Object ... objectArray) {
            super(throwable, object, objectArray);
            assert (object != null) : "resourceKey must not be null";
            if (objectArray != null && objectArray.length > 0) {
                for (Object object2 : objectArray) {
                    assert (object2 != null) : "param values must not be null";
                }
            }
        }
    }

    static class ControlFormattableException
    extends FormattableException {
        public ControlFormattableException(Throwable throwable, Object object, Object ... objectArray) {
            super(throwable, object, objectArray);
        }
    }

    public static interface ErrorGetter {
        public Throwable getError();
    }

    public static interface PortGetter {
        public String getPort();
    }

    public static interface HostGetter {
        public String getHost();
    }

    public static interface ServiceNameGetter {
        public String getServiceName();
    }

    public static interface ServiceTypeGetter {
        public String getServiceType();
    }

    public static interface DirPathGetter {
        public String getDirPath();
    }
}

