/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.control.CommandConfigParser;
import com.mathworks.toolbox.distcomp.control.ConfigRunner;
import com.mathworks.toolbox.distcomp.control.ControlJobmanager;
import com.mathworks.toolbox.distcomp.control.ControlLookup;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcess;
import com.mathworks.toolbox.distcomp.control.ControlWorker;
import com.mathworks.toolbox.distcomp.control.PortConfig;
import com.mathworks.toolbox.distcomp.control.Starter;
import com.mathworks.toolbox.distcomp.control.Stopper;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.util.ConfigFileWrapper;
import net.jini.config.ConfigurationException;

public class ControlStartStopConfigParser {
    private static final String ACTION = "remoteAction";
    private static final String SERVICE_CONFIG_FILE = "serviceConfigFile";
    private static final String CLEAN = "cleanCheckpointInfo";
    private static final String SERVICE_NAME = "serviceName";
    private static final String JOBMANAGER_NAME = "jobmanagerName";
    private static final String LOOKUP_HOSTS = "lookupHosts";
    private static final String START_ACTION = "start";
    private static final String STOP_ACTION = "stop";

    public static ControlStartStopProcess createStartStopCommand(ConfigFileWrapper configFileWrapper) throws ConfigurationException {
        ControlStartStopProcess controlStartStopProcess;
        Object object;
        String string = configFileWrapper.getNonEmptyStringEntry("remoteCommandType");
        String string2 = configFileWrapper.getNonEmptyStringEntry(ACTION);
        String string3 = configFileWrapper.getStringEntry(SERVICE_NAME);
        String string4 = CommandConfigParser.getRemoteHostname(configFileWrapper);
        int n = PortConfig.getBasePortFromRemoteCommandPort(CommandConfigParser.getRemotePort(configFileWrapper));
        String string5 = configFileWrapper.getNonEmptyStringEntry(SERVICE_CONFIG_FILE);
        boolean bl = ControlStartStopConfigParser.actionToStartOrStop(string2);
        ConfigRunner configRunner = ControlStartStopConfigParser.getConfigRunner(bl);
        ControlStartStopProcess controlStartStopProcess2 = null;
        if (string.equals("jobmanager")) {
            object = new Host(string4);
            controlStartStopProcess = new ControlJobmanager(configRunner, bl, string5, string3, (Host)object, n);
            if (bl) {
                ((ControlJobmanager)controlStartStopProcess).setLookupHosts(configFileWrapper.getStringEntry(LOOKUP_HOSTS));
            }
            controlStartStopProcess2 = controlStartStopProcess;
        } else if (string.equals("lookup")) {
            controlStartStopProcess2 = new ControlLookup(configRunner, bl, string5, string3);
        } else if (string.equals("worker")) {
            object = configFileWrapper.getStringEntry(JOBMANAGER_NAME);
            controlStartStopProcess = new ControlWorker(configRunner, bl, string5, string3, (String)object);
            if (bl) {
                ((ControlWorker)controlStartStopProcess).setLookupHosts(configFileWrapper.getStringEntry(LOOKUP_HOSTS));
            }
            controlStartStopProcess2 = controlStartStopProcess;
        } else {
            throw new ConfigurationException("Cannot create the command for " + string + ".");
        }
        boolean bl2 = false;
        boolean bl3 = configFileWrapper.getBooleanEntry(CLEAN, bl2);
        controlStartStopProcess2.setClean(bl3);
        controlStartStopProcess2.getInfo().setIsStarting(bl);
        controlStartStopProcess2.getInfo().setRemoteHostname(CommandConfigParser.getRemoteHostname(configFileWrapper));
        return controlStartStopProcess2;
    }

    private static boolean actionToStartOrStop(String string) throws ConfigurationException {
        if (string.equals(START_ACTION) || string.equals(STOP_ACTION)) {
            return string.equals(START_ACTION);
        }
        throw new ConfigurationException("Invalid action specified in configuration file.  The action should either be start or stop.");
    }

    private static ConfigRunner getConfigRunner(boolean bl) {
        if (bl) {
            return new Starter();
        }
        return new Stopper();
    }
}

