/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.io;

import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.io.StreamSegment;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class StreamSegmentInputStream
extends InputStream {
    private final MatchingQueue fQueue;
    private final EoFListener fEoFListener;
    private final String fLogId;
    private final Lock fLock = new ReentrantLock();
    private StreamSegment fCurrentStreamSegment = null;
    private ByteArrayInputStream fByteArrayInputStream = null;
    private boolean fIsAtEoF = false;

    public StreamSegmentInputStream(String string) {
        this.fLogId = string + ": ";
        this.fEoFListener = null;
        this.fQueue = new MatchingQueue(new StreamSegment.StreamSegmentComparator(), this.fLogId);
    }

    public StreamSegmentInputStream(String string, EoFListener eoFListener) {
        this.fLogId = string + ": ";
        this.fEoFListener = eoFListener;
        this.fQueue = new MatchingQueue(new StreamSegment.StreamSegmentComparator(), this.fLogId);
    }

    public void putStreamSegment(StreamSegment streamSegment) {
        Log.LOGGER.finest(this.fLogId + "put " + streamSegment);
        this.fQueue.put(streamSegment);
        Log.LOGGER.finest(this.fLogId + "put " + streamSegment + " finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAtEoF() {
        try {
            this.fLock.lock();
            boolean bl = this.fIsAtEoF;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextSequenceNumber() {
        try {
            this.fLock.lock();
            if (this.fCurrentStreamSegment == null) {
                long l = 0L;
                return l;
            }
            long l = this.fCurrentStreamSegment.getSegmentNumber() + 1L;
            return l;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextStreamSegment() throws InterruptedException {
        try {
            this.fLock.lock();
            this.fCurrentStreamSegment = this.fQueue.takeExpected(this.getNextSequenceNumber());
            this.fByteArrayInputStream = new ByteArrayInputStream(this.fCurrentStreamSegment.getStreamContents());
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public int read() throws IOException {
        try {
            int n = this.lockedRead();
            return n;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("Interrupted " + interruptedException.getMessage());
        }
        finally {
            if (this.isAtEoF() && this.fEoFListener != null) {
                this.fEoFListener.reachedEoF();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lockedRead() throws IOException, InterruptedException {
        try {
            int n;
            this.fLock.lock();
            if (this.fByteArrayInputStream == null) {
                this.nextStreamSegment();
            }
            if ((n = this.fByteArrayInputStream.read()) != -1) {
                int n2 = n;
                return n2;
            }
            if (this.fCurrentStreamSegment.isLastSegment()) {
                Log.LOGGER.finest(this.fLogId + "reached end of last segment, returning " + n);
                this.fIsAtEoF = true;
                int n3 = n;
                return n3;
            }
            Log.LOGGER.finest(this.fLogId + "reached end of a segment");
            this.nextStreamSegment();
            int n4 = this.lockedRead();
            return n4;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() {
        int n = 0;
        try {
            this.fLock.lock();
            if (this.fByteArrayInputStream == null || this.fByteArrayInputStream.available() == 0 && this.fCurrentStreamSegment != null && !this.fCurrentStreamSegment.isLastSegment()) {
                this.fCurrentStreamSegment = this.fQueue.pollExpected(this.getNextSequenceNumber());
                if (this.fCurrentStreamSegment != null) {
                    this.fByteArrayInputStream = new ByteArrayInputStream(this.fCurrentStreamSegment.getStreamContents());
                }
            }
            if (this.fByteArrayInputStream != null) {
                n = this.fByteArrayInputStream.available();
            }
            if (n > 0) {
                Log.LOGGER.finest(this.fLogId + "available() reported " + n);
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public static interface EoFListener {
        public void reachedEoF();
    }

    private static final class MatchingQueue {
        private final PriorityBlockingQueue<StreamSegment> fQueue;
        private final String fLogId;
        private final Lock fLock = new ReentrantLock();
        private final Condition fEnqueued = this.fLock.newCondition();

        MatchingQueue(Comparator<StreamSegment> comparator, String string) {
            this.fLogId = string;
            this.fQueue = new PriorityBlockingQueue<StreamSegment>(1, comparator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(StreamSegment streamSegment) {
            Log.LOGGER.finest(this.fLogId + "start of put " + streamSegment);
            try {
                this.fLock.lock();
                Log.LOGGER.finest(this.fLogId + "put " + streamSegment + " got lock");
                this.fQueue.put(streamSegment);
                this.fEnqueued.signalAll();
                Log.LOGGER.finest(this.fLogId + "put " + streamSegment + ". peek shows " + this.fQueue.peek());
            }
            finally {
                this.fLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StreamSegment takeExpected(long l) throws InterruptedException {
            try {
                StreamSegment streamSegment;
                this.fLock.lock();
                do {
                    if ((streamSegment = this.takeMatch(l)) != null) continue;
                    this.awaitEnqueue();
                } while (streamSegment == null);
                StreamSegment streamSegment2 = streamSegment;
                return streamSegment2;
            }
            finally {
                this.fLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StreamSegment pollExpected(long l) {
            try {
                StreamSegment streamSegment;
                this.fLock.lock();
                while ((streamSegment = this.pollMatch(l)) == null) {
                }
                StreamSegment streamSegment2 = streamSegment;
                return streamSegment2;
            }
            finally {
                this.fLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StreamSegment takeMatch(long l) throws InterruptedException {
            try {
                this.fLock.lock();
                StreamSegment streamSegment = this.fQueue.peek();
                Log.LOGGER.finest(this.fLogId + "peeked " + streamSegment + ", expecting number " + l);
                if (streamSegment == null) {
                    StreamSegment streamSegment2 = null;
                    return streamSegment2;
                }
                if (streamSegment.getSegmentNumber() == l) {
                    StreamSegment streamSegment3 = this.fQueue.take();
                    Log.LOGGER.finest(this.fLogId + "took " + streamSegment3);
                    StreamSegment streamSegment4 = streamSegment3;
                    return streamSegment4;
                }
                Log.LOGGER.warning(this.fLogId + "Earlier stream segment arrived." + "Possible duplicate. Got stream segment " + streamSegment.getSegmentNumber() + " when expecting " + l + " " + streamSegment);
                assert (streamSegment.getSegmentNumber() > l) : this.fLogId + "Earlier stream segment arrived." + "Possible duplicate. Got stream segment " + streamSegment.getSegmentNumber() + " when expecting " + l + " " + streamSegment;
                StreamSegment streamSegment5 = null;
                return streamSegment5;
            }
            finally {
                this.fLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StreamSegment pollMatch(long l) {
            try {
                this.fLock.lock();
                StreamSegment streamSegment = this.fQueue.peek();
                if (streamSegment == null) {
                    StreamSegment streamSegment2 = null;
                    return streamSegment2;
                }
                if (streamSegment.getSegmentNumber() == l) {
                    StreamSegment streamSegment3 = this.fQueue.poll();
                    Log.LOGGER.finest(this.fLogId + "polled " + streamSegment3);
                    StreamSegment streamSegment4 = streamSegment3;
                    return streamSegment4;
                }
                Log.LOGGER.warning(this.fLogId + "Earlier stream segment arrived." + "Possible duplicate. Got stream segment " + streamSegment.getSegmentNumber() + " when expecting " + l + " " + streamSegment);
                assert (streamSegment.getSegmentNumber() > l) : this.fLogId + "Earlier stream segment arrived." + "Possible duplicate. Got stream segment " + streamSegment.getSegmentNumber() + " when expecting " + l + " " + streamSegment;
                StreamSegment streamSegment5 = null;
                return streamSegment5;
            }
            finally {
                this.fLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void awaitEnqueue() throws InterruptedException {
            try {
                this.fLock.lock();
                Log.LOGGER.finest(this.fLogId + "started await");
                this.fEnqueued.await();
                Log.LOGGER.finest(this.fLogId + "finished await");
            }
            finally {
                this.fLock.unlock();
            }
        }
    }
}

