/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.server;

import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.io.StreamSegment;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.io.StreamSegmentInputStream;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.io.StreamSegmentOutputStream;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.ExceptionReturnMessage;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.ExitStatusReturnMessage;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.StreamSegmentReturnMessage;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.shared.SuccessfulDispatchMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.RemoteStreamException;
import com.mathworks.toolbox.distcomp.remote.ShellCommand;
import com.mathworks.toolbox.distcomp.remote.ShellFuture;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.LocalShellSender;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.ProcessShellFuture;
import com.mathworks.toolbox.distcomp.remote.util.DaemonThreadFactory;
import com.mathworks.toolbox.distcomp.remote.util.OutputRedirector;
import com.mathworks.toolbox.distcomp.remote.util.SingleStreamRedirector;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;

final class LocalExecutionMonitor {
    private final Instance fClient;
    private final ReturnGroup fReturnGroup;
    private final ScheduledExecutorService fScheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory(this.getClass().getSimpleName() + " fScheduledExecutorService "));
    private final Lock fLock = new ReentrantLock();
    private final Map<Long, LocalShellFutureMonitor> fSequenceNumbersToMonitors = new HashMap<Long, LocalShellFutureMonitor>();
    private final Map<Long, ScheduledFuture<?>> fSequenceNumbersToScheduledFutures = new HashMap();

    LocalExecutionMonitor(Instance instance, ReturnGroup returnGroup) {
        this.fClient = instance;
        this.fReturnGroup = returnGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeShellCommand(ShellCommand shellCommand, ParameterMap parameterMap, long l) {
        if (!parameterMap.containsKey(LocalShellSender.LocalParameter.DIRECTORY)) {
            parameterMap.put(LocalShellSender.LocalParameter.DIRECTORY, new File(System.getenv("WINDIR")));
        }
        try {
            this.fLock.lock();
            Log.LOGGER.fine("Starting to execute " + l + " " + shellCommand);
            LocalShellSender localShellSender = new LocalShellSender();
            ProcessShellFuture processShellFuture = localShellSender.sendAndRun(shellCommand, "localhost", parameterMap);
            SuccessfulDispatchMessage successfulDispatchMessage = new SuccessfulDispatchMessage(l);
            this.fReturnGroup.returnTo(this.fClient, successfulDispatchMessage);
            Log.LOGGER.finest("Sent successful dispatch for " + l + " " + shellCommand);
            this.startMonitor(processShellFuture, l);
            Log.LOGGER.finest("Started monitor for " + l + " " + shellCommand);
        }
        catch (DispatchException dispatchException) {
            ExceptionReturnMessage exceptionReturnMessage = new ExceptionReturnMessage(l, dispatchException);
            this.fReturnGroup.returnTo(this.fClient, exceptionReturnMessage);
            Log.LOGGER.log(Level.WARNING, "Failed to dispatch " + l + " " + shellCommand, dispatchException);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMonitor(ShellFuture shellFuture, long l) {
        try {
            this.fLock.lock();
            LocalShellFutureMonitor localShellFutureMonitor = new LocalShellFutureMonitor(shellFuture, l, this.fReturnGroup, this.fClient, this);
            this.fSequenceNumbersToMonitors.put(l, localShellFutureMonitor);
            ScheduledFuture<?> scheduledFuture = this.fScheduledExecutorService.scheduleWithFixedDelay(localShellFutureMonitor, 100L, 100L, TimeUnit.MILLISECONDS);
            this.fSequenceNumbersToScheduledFutures.put(l, scheduledFuture);
        }
        catch (RemoteStreamException remoteStreamException) {
            ExceptionReturnMessage exceptionReturnMessage = new ExceptionReturnMessage(l, remoteStreamException);
            this.fReturnGroup.returnTo(this.fClient, exceptionReturnMessage);
            Log.LOGGER.log(Level.WARNING, "Failed to start monitor for " + l + " " + shellFuture, remoteStreamException);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelCommand(long l) {
        LocalShellFutureMonitor localShellFutureMonitor;
        Log.LOGGER.finest("Started cancel for " + l);
        try {
            this.fLock.lock();
            localShellFutureMonitor = this.fSequenceNumbersToMonitors.get(l);
        }
        finally {
            this.fLock.unlock();
        }
        if (localShellFutureMonitor != null) {
            localShellFutureMonitor.cancel();
            Log.LOGGER.fine("Canceled " + l);
        } else {
            Log.LOGGER.fine("No monitor available to cancel " + l + ". Command may have finished.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putStreamSegment(long l, StreamSegment streamSegment) {
        LocalShellFutureMonitor localShellFutureMonitor;
        Log.LOGGER.finest("Received " + streamSegment + " for " + l);
        try {
            this.fLock.lock();
            localShellFutureMonitor = this.fSequenceNumbersToMonitors.get(l);
        }
        finally {
            this.fLock.unlock();
        }
        if (localShellFutureMonitor != null) {
            localShellFutureMonitor.putStreamSegment(streamSegment);
            Log.LOGGER.fine("Put " + streamSegment + " for " + l);
        } else {
            Log.LOGGER.fine("Could not find monitor for " + l + " to put " + streamSegment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup(long l) {
        Log.LOGGER.finest("Start cleanup for " + l);
        try {
            this.fLock.lock();
            ScheduledFuture<?> scheduledFuture = this.fSequenceNumbersToScheduledFutures.remove(l);
            scheduledFuture.cancel(false);
            this.fSequenceNumbersToMonitors.remove(l);
        }
        finally {
            this.fLock.unlock();
        }
        Log.LOGGER.fine("Finished cleanup for " + l);
    }

    static final class ReturnMessageStreamSegmentSink
    implements StreamSegmentOutputStream.StreamSegmentSink {
        private final long fSequenceNumber;
        private final ReturnGroup fReturnGroup;
        private final Instance fClient;

        ReturnMessageStreamSegmentSink(long l, ReturnGroup returnGroup, Instance instance) {
            this.fSequenceNumber = l;
            this.fReturnGroup = returnGroup;
            this.fClient = instance;
        }

        @Override
        public void putStreamSegment(StreamSegment streamSegment) {
            StreamSegmentReturnMessage streamSegmentReturnMessage = new StreamSegmentReturnMessage(this.fSequenceNumber, streamSegment);
            Log.LOGGER.finest("Replying with " + streamSegmentReturnMessage);
            this.fReturnGroup.returnTo(this.fClient, streamSegmentReturnMessage);
        }
    }

    static final class LocalShellFutureMonitor
    implements Runnable {
        private final ShellFuture fShellFuture;
        private final ReturnGroup fReturnGroup;
        private final Instance fClient;
        private final long fSequenceNumber;
        private final LocalExecutionMonitor fLocalExecutionMonitor;
        private final OutputRedirector fOutputRedirector;
        private final StreamSegmentOutputStream fStdOutDestination;
        private final StreamSegmentOutputStream fStdErrDestination;
        private final StreamSegmentInputStream fStdInSource = new StreamSegmentInputStream("stdin");

        LocalShellFutureMonitor(ShellFuture shellFuture, long l, ReturnGroup returnGroup, Instance instance, LocalExecutionMonitor localExecutionMonitor) throws RemoteStreamException {
            this.fShellFuture = shellFuture;
            this.fSequenceNumber = l;
            this.fReturnGroup = returnGroup;
            this.fClient = instance;
            this.fLocalExecutionMonitor = localExecutionMonitor;
            ReturnMessageStreamSegmentSink returnMessageStreamSegmentSink = new ReturnMessageStreamSegmentSink(l, returnGroup, instance);
            this.fStdOutDestination = new StreamSegmentOutputStream("stdout", returnMessageStreamSegmentSink);
            this.fStdErrDestination = new StreamSegmentOutputStream("stderr", returnMessageStreamSegmentSink);
            this.fOutputRedirector = new OutputRedirector(shellFuture.getInputStream(), shellFuture.getErrorStream(), this.fStdOutDestination, this.fStdErrDestination);
            SingleStreamRedirector singleStreamRedirector = new SingleStreamRedirector(this.fStdInSource, shellFuture.getOutputStream());
            Thread thread = new Thread((Runnable)singleStreamRedirector, "stdin " + this.fSequenceNumber);
            thread.setDaemon(true);
            thread.start();
        }

        void putStreamSegment(StreamSegment streamSegment) {
            this.fStdInSource.putStreamSegment(streamSegment);
        }

        void cancel() {
            this.fShellFuture.cancel();
        }

        @Override
        public void run() {
            if (this.hasFinishedEverything()) {
                try {
                    this.fStdOutDestination.close();
                }
                catch (IOException iOException) {
                    Log.LOGGER.log(Level.WARNING, "While closing stdout", iOException);
                }
                try {
                    this.fStdErrDestination.close();
                }
                catch (IOException iOException) {
                    Log.LOGGER.log(Level.WARNING, "While closing stderr", iOException);
                }
                this.sendFinalMessage();
            }
        }

        private boolean hasFinishedEverything() {
            if (this.fShellFuture.isRunning()) {
                Log.LOGGER.finest("fShellFuture is still running.");
                return false;
            }
            if (this.fOutputRedirector.isRunning()) {
                Log.LOGGER.finest("fOutputRedirector is still running.");
                return false;
            }
            return true;
        }

        private void sendFinalMessage() {
            assert (this.hasFinishedEverything()) : "Should not enter this method if fShellFuture is still running. Use hasFinishedEverything() to protect.";
            if (!this.hasFinishedEverything()) {
                Log.LOGGER.warning("Should not enter this method if fShellFuture is still running. Use hasFinishedEverything() to protect.");
            }
            try {
                int n = this.fShellFuture.getExitStatus();
                ExitStatusReturnMessage exitStatusReturnMessage = new ExitStatusReturnMessage(this.fSequenceNumber, n);
                Log.LOGGER.finest("Replying with " + exitStatusReturnMessage);
                this.fReturnGroup.returnTo(this.fClient, exitStatusReturnMessage);
            }
            catch (FulfillmentException fulfillmentException) {
                ExceptionReturnMessage exceptionReturnMessage = new ExceptionReturnMessage(this.fSequenceNumber, fulfillmentException);
                Log.LOGGER.log(Level.WARNING, "Replying with ", exceptionReturnMessage);
                this.fReturnGroup.returnTo(this.fClient, exceptionReturnMessage);
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException("Interrupted while getting exit status on something that shouldn't need to wait", interruptedException);
            }
            finally {
                this.cleanup();
            }
        }

        private void cleanup() {
            this.fLocalExecutionMonitor.cleanup(this.fSequenceNumber);
            this.fOutputRedirector.close();
        }
    }
}

