/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.serviceinfo;

import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.NodeServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerServiceInfo;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.control.servicerequest.RequestResponse;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerNodeInfo;
import com.mathworks.toolbox.distcomp.service.NodeInfo;
import com.mathworks.toolbox.distcomp.worker.WorkerNodeInfo;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public class StatusRequestResponse
extends RequestResponse
implements MDCSCommandResults {
    private static final long serialVersionUID = 6252512918005879976L;
    private Collection<String> fNodes = new HashSet<String>();
    private TreeSet<ServiceInfo> fServiceInfos = new TreeSet();
    private Date fStartTime = new Date(System.currentTimeMillis());

    public StatusRequestResponse() {
        this(false);
    }

    public StatusRequestResponse(boolean bl) {
        super(bl, null);
    }

    public static MDCSCommandResults create(JobManagerNodeInfo[] jobManagerNodeInfoArray, WorkerNodeInfo[] workerNodeInfoArray, MDCSServiceInfo mDCSServiceInfo, List<ServiceInfo> list, int n) {
        NodeServiceInfo nodeServiceInfo;
        StatusRequestResponse statusRequestResponse = new StatusRequestResponse(true);
        statusRequestResponse.addServiceInfo(mDCSServiceInfo);
        Host host = new Host(mDCSServiceInfo.getUserSpecifiedHostName());
        if (jobManagerNodeInfoArray != null) {
            for (NodeInfo nodeInfo : jobManagerNodeInfoArray) {
                if (nodeInfo == null) continue;
                host = new Host(host.getHostname(), nodeInfo.getHostName());
                nodeServiceInfo = new JobManagerServiceInfo((JobManagerNodeInfo)nodeInfo, host);
                mDCSServiceInfo.addJobManagerName(nodeServiceInfo.getServiceName());
                statusRequestResponse.addServiceInfo(nodeServiceInfo);
                statusRequestResponse.addNodes(((JobManagerServiceInfo)nodeServiceInfo).getWorkerHostNames());
            }
        }
        if (workerNodeInfoArray != null) {
            for (NodeInfo nodeInfo : workerNodeInfoArray) {
                if (nodeInfo == null) continue;
                host = new Host(host.getHostname(), nodeInfo.getHostName());
                nodeServiceInfo = new WorkerServiceInfo((WorkerNodeInfo)nodeInfo, host);
                mDCSServiceInfo.addWorkerName(nodeServiceInfo.getServiceName());
                statusRequestResponse.addServiceInfo(nodeServiceInfo);
                statusRequestResponse.addNode(((WorkerServiceInfo)nodeServiceInfo).getJobManagerHostName());
            }
        }
        statusRequestResponse.addServiceInfos(list);
        return statusRequestResponse;
    }

    public Date getStartTime() {
        return (Date)this.fStartTime.clone();
    }

    public Collection<ServiceInfo> getServiceInfos() {
        return this.fServiceInfos;
    }

    void addNode(String string) {
        this.fNodes.add(string);
    }

    void addNodes(Collection<String> collection) {
        this.fNodes.addAll(collection);
    }

    public Collection<String> getNodes() {
        return this.fNodes;
    }

    void addServiceInfo(ServiceInfo serviceInfo) {
        this.fServiceInfos.add(serviceInfo);
    }

    void addServiceInfos(Collection<ServiceInfo> collection) {
        this.fServiceInfos.addAll(collection);
    }
}

