/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.auth.AbstractInvocationWithAuth;
import com.mathworks.toolbox.distcomp.auth.AuthorisationContext;
import com.mathworks.toolbox.distcomp.auth.RemoteAuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.FilteredCredentialStore;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import java.rmi.RemoteException;

public final class JobManagerAuthorisationContext
implements AuthorisationContext {
    private JobManagerLocal fJobManager;
    private UserIdentity fCurrentUser;
    private CredentialStore<AuthenticationToken> fCredentialStore;
    private RemoteAuthorisationModule fRemoteAuth;

    public JobManagerAuthorisationContext(JobManagerLocal jobManagerLocal, CredentialConsumerFactory credentialConsumerFactory) {
        this.fJobManager = jobManagerLocal;
        this.fRemoteAuth = this.fJobManager.getRemoteAuth();
        this.setCredentialConsumerFactory(credentialConsumerFactory);
        this.fCredentialStore = this.fRemoteAuth.createCredentialStore(this.fJobManager.getSessionID());
    }

    public JobManagerAuthorisationContext(JobManagerLocal jobManagerLocal, CredentialConsumerFactory credentialConsumerFactory, CredentialStore<AuthenticationToken> credentialStore) {
        this.fJobManager = jobManagerLocal;
        this.fRemoteAuth = this.fJobManager.getRemoteAuth();
        this.setCredentialConsumerFactory(credentialConsumerFactory);
        this.fCredentialStore = credentialStore;
    }

    private JobManagerAuthorisationContext(JobManagerLocal jobManagerLocal, CredentialConsumerFactory credentialConsumerFactory, CredentialStore<AuthenticationToken> credentialStore, UserIdentity userIdentity) {
        this.fJobManager = jobManagerLocal;
        this.fRemoteAuth = this.fJobManager.getRemoteAuth();
        this.setCredentialConsumerFactory(credentialConsumerFactory);
        this.fCredentialStore = credentialStore;
        this.fCurrentUser = userIdentity;
    }

    public JobManagerAuthorisationContext createNew(JobManagerLocal jobManagerLocal) {
        return new JobManagerAuthorisationContext(jobManagerLocal, this.getCredentialConsumerFactory(), this.fCredentialStore, this.fCurrentUser);
    }

    public UserIdentity promptForIdentity(String string) throws MJSException, RemoteException {
        UserIdentity userIdentity = string == null ? UserIdentity.createDefaultUserIdentity() : new UserIdentity(string);
        if (this.fJobManager.userExists(userIdentity)) {
            return userIdentity;
        }
        return this.fRemoteAuth.promptForIdentity(userIdentity);
    }

    public void setCurrentUser(UserIdentity userIdentity) throws MJSException, RemoteException {
        if (this.fJobManager.userExists(userIdentity)) {
            this.fJobManager.checkCredentialsUserOnly(this, userIdentity);
        } else {
            this.fJobManager.addNewUser(this, userIdentity);
        }
        this.fCurrentUser = userIdentity;
    }

    @Override
    public UserIdentity getCurrentUser() {
        return this.fCurrentUser;
    }

    public void revokeAuthentication(UserIdentity userIdentity) {
        if (userIdentity == null) {
            userIdentity = this.fCurrentUser;
        }
        this.fCredentialStore.removeUser(userIdentity);
    }

    public CredentialStore<AuthenticationToken> getCredentialStore() {
        return this.fCredentialStore;
    }

    public void setCredentialConsumerFactory(CredentialConsumerFactory credentialConsumerFactory) {
        this.fRemoteAuth.setConsumerFactory(credentialConsumerFactory);
    }

    public CredentialConsumerFactory getCredentialConsumerFactory() {
        return this.fRemoteAuth.getConsumerFactory();
    }

    @Override
    public <T> T invokeWithAuth(AbstractInvocationWithAuth<T> abstractInvocationWithAuth) throws RemoteException, MJSException {
        abstractInvocationWithAuth.setExporterFactory(this.fJobManager.getCredentialProviderExporterFactory());
        FilteredCredentialStore<AuthenticationToken> filteredCredentialStore = new FilteredCredentialStore<AuthenticationToken>(this.fCredentialStore, this.fCurrentUser);
        return this.fRemoteAuth.invokeWithAuth(abstractInvocationWithAuth, filteredCredentialStore);
    }

    public String toString() {
        return "JobManagerAuthorisationContext{fCurrentUser=" + this.fCurrentUser + '}';
    }

    public Object createMemento() {
        return new JobManagerAuthorisationContextMemento(this);
    }

    public void restoreFromMemento(Object object) {
        if (!(object instanceof JobManagerAuthorisationContextMemento)) {
            throw new IllegalArgumentException("Can not restore from Memento that was not created by createMemento.");
        }
        JobManagerAuthorisationContextMemento jobManagerAuthorisationContextMemento = (JobManagerAuthorisationContextMemento)object;
        jobManagerAuthorisationContextMemento.restore(this);
    }

    private static class JobManagerAuthorisationContextMemento {
        private final UserIdentity fUserIdentity;
        private final CredentialConsumerFactory fConsumerFactory;
        private final CredentialStore.Memento<AuthenticationToken> fCredentialStoreMemento;

        private JobManagerAuthorisationContextMemento(JobManagerAuthorisationContext jobManagerAuthorisationContext) {
            this.fCredentialStoreMemento = jobManagerAuthorisationContext.fCredentialStore.createMemento();
            this.fUserIdentity = jobManagerAuthorisationContext.getCurrentUser();
            this.fConsumerFactory = jobManagerAuthorisationContext.getCredentialConsumerFactory();
        }

        public void restore(JobManagerAuthorisationContext jobManagerAuthorisationContext) {
            jobManagerAuthorisationContext.fCurrentUser = this.fUserIdentity;
            jobManagerAuthorisationContext.setCredentialConsumerFactory(this.fConsumerFactory);
            jobManagerAuthorisationContext.fCredentialStore.restoreFromMemento(this.fCredentialStoreMemento);
        }
    }
}

