/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.auth.AllowedUserList;
import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.AuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.AuthorisationModuleConfig;
import com.mathworks.toolbox.distcomp.auth.SecurityModuleProvider;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompProxy;
import com.mathworks.toolbox.distcomp.jobmanager.JobCounter;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerImplPeerSession;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerNodeInfo;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerProxy;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerRemote;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.jobmanager.JobRunner;
import com.mathworks.toolbox.distcomp.jobmanager.PackageInfo;
import com.mathworks.toolbox.distcomp.jobmanager.PersistentJobManagerConfiguration;
import com.mathworks.toolbox.distcomp.jobmanager.RegistrationAuthority;
import com.mathworks.toolbox.distcomp.jobmanager.SavePausedStateException;
import com.mathworks.toolbox.distcomp.jobmanager.SaveRunningStateException;
import com.mathworks.toolbox.distcomp.jobmanager.TaskDispatcherForJobs;
import com.mathworks.toolbox.distcomp.jobmanager.TaskDispatcherForParallelJobs;
import com.mathworks.toolbox.distcomp.jobmanager.WorkUnitTimeoutChecker;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerPool;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerRegistration;
import com.mathworks.toolbox.distcomp.jobmanager.permissions.ClientPermission;
import com.mathworks.toolbox.distcomp.jobmanager.permissions.ClientPermissionStore;
import com.mathworks.toolbox.distcomp.jobmanager.permissions.PermissionChecker;
import com.mathworks.toolbox.distcomp.jobmanager.permissions.PermissionStore;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.cwo.CWOInputStreamHandler;
import com.mathworks.toolbox.distcomp.mjs.cwo.CWOWriteRequestor;
import com.mathworks.toolbox.distcomp.mjs.cwo.TaskInputStreamHandler;
import com.mathworks.toolbox.distcomp.pml.MatlabPoolJobImpl;
import com.mathworks.toolbox.distcomp.pml.ParallelJobAccessImpl;
import com.mathworks.toolbox.distcomp.pml.ParallelJobAccessLocal;
import com.mathworks.toolbox.distcomp.pml.ParallelJobImpl;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.AbstractPeerAcceptor;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.ProtocolId;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.distcomp.service.DistcompService;
import com.mathworks.toolbox.distcomp.service.DistcompServiceImpl;
import com.mathworks.toolbox.distcomp.service.DistcompServiceInfo;
import com.mathworks.toolbox.distcomp.service.NodeInfo;
import com.mathworks.toolbox.distcomp.service.PersistenceDirException;
import com.mathworks.toolbox.distcomp.service.PersistentServiceConfiguration;
import com.mathworks.toolbox.distcomp.storage.CredentialStorage;
import com.mathworks.toolbox.distcomp.storage.CredentialStorageException;
import com.mathworks.toolbox.distcomp.storage.DataStorage;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import com.mathworks.toolbox.distcomp.storage.H2StorageFactory;
import com.mathworks.toolbox.distcomp.storage.JobManagerStorage;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.test.CommTestException;
import com.mathworks.toolbox.distcomp.test.CommTestInfo;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import com.mathworks.toolbox.distcomp.util.NetworkConfigException;
import com.mathworks.toolbox.distcomp.util.ProxyCreationException;
import com.mathworks.toolbox.distcomp.util.ServiceExportException;
import com.mathworks.toolbox.distcomp.util.ServiceStarterException;
import com.mathworks.toolbox.distcomp.util.concurrent.DaemonThreadFactory;
import com.mathworks.toolbox.distcomp.util.zip.DirectoryZipEntryWriter;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerLocal;
import com.mathworks.toolbox.distcomp.worker.WorkerLogsZipEntryWriter;
import com.mathworks.toolbox.distcomp.worker.WorkerProperties;
import com.mathworks.toolbox.distcomp.worker.WorkerProxy;
import com.mathworks.toolbox.distcomp.workunit.JobAccessImpl;
import com.mathworks.toolbox.distcomp.workunit.JobAccessLocal;
import com.mathworks.toolbox.distcomp.workunit.JobIDAndMLType;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.JobInfo;
import com.mathworks.toolbox.distcomp.workunit.TaskAccessImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskAccessLocal;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitInitializer;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitStateException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.rmi.server.ExportException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.SSLContext;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.id.Uuid;

public class JobManagerImpl
extends DistcompServiceImpl
implements JobManagerRemote,
RegistrationAuthority {
    private static final String JMCONFIG = "com.mathworks.toolbox.distcomp.jobmanager";
    public static final int NUM_WORK_UNITS_PER_CALLER = 4;
    private static final int NUM_BLOB_FILE_STORAGE_ITEMS = 1;
    private static final int MAX_OPEN_FILE_HANDLES = 200;
    private static final String ZIPPED_LOGS_SUFFIX = "-logs.zip";
    private long fMinTransferUsingDataStore;
    private JobManagerProxy fJobManagerProxy;
    private JobAccessImpl fJobAccess;
    private ParallelJobAccessImpl fParallelJobAccess;
    private TaskAccessImpl fTaskAccess;
    private JobManagerStorage fStorage;
    private DataStorage fLargeDataStorage;
    private DataStorage fAppendableDataStorage;
    private CredentialStorage fCredentialStorage;
    private WorkUnitInitializer fWorkUnitInitializer;
    private TaskInputStreamHandler fCWOStreamHandler;
    private AtomicBoolean fIsShutdown = new AtomicBoolean(false);
    private static final long SHUTDOWN_TIMEOUT = 10L;
    private AuthorisationModule fAuthorisationModule;
    private PermissionChecker fPermissionChecker;
    private PermissionStore fPermissionStore;
    private final Object fPromoteDemoteLock = new Object();
    private PeerInstance fPeerInstance;
    private JobManagerImplPeerSession fJobManagerPeerSession = null;

    public JobManagerImpl(ActivationID activationID, MarshalledObject marshalledObject) throws DistcompException {
        super(activationID, marshalledObject, JMCONFIG);
        try {
            this.exportDistcompService();
        }
        catch (NetworkConfigException networkConfigException) {
            throw new DistcompException(networkConfigException);
        }
        catch (ServiceExportException serviceExportException) {
            throw new DistcompException(serviceExportException);
        }
        if (this.shouldStartPeerSession()) {
            try {
                this.initPeerSession();
            }
            catch (AbstractPeerAcceptor.InitializeServerSocketChannelException initializeServerSocketChannelException) {
                throw new DistcompException(initializeServerSocketChannelException);
            }
        }
        int n = this.getPersistentConfiguration().getMaxNumberOfCallers();
        long l = this.getPersistentConfiguration().getMaxJobManagerHeapMemory();
        this.fMinTransferUsingDataStore = l / 4L / (long)n;
        try {
            this.initStorage(n);
        }
        catch (StorageInitException storageInitException) {
            throw new DistcompException(storageInitException);
        }
        this.initSecurity(this.fCredentialStorage);
        try {
            this.createJobManagerProxy();
        }
        catch (ProxyCreationException proxyCreationException) {
            throw new DistcompException(proxyCreationException);
        }
        WorkUnitTimeoutChecker.init(this.fStorage);
        this.initJobCounter();
        try {
            this.initAccessObjects();
            this.initJobAndTaskRunner();
        }
        catch (ProxyCreationException proxyCreationException) {
            throw new DistcompException(proxyCreationException);
        }
        catch (ServiceExportException serviceExportException) {
            throw new DistcompException(serviceExportException);
        }
        this.initCWOHandler();
        try {
            this.registerWithLookupServices(this.fJobManagerProxy);
        }
        catch (ServiceStarterException serviceStarterException) {
            throw new DistcompException(serviceStarterException);
        }
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Started JM");
    }

    private void initPeerSession() throws AbstractPeerAcceptor.InitializeServerSocketChannelException {
        UUID uUID = UUID.randomUUID();
        UUID uUID2 = UUID.randomUUID();
        this.fPeerInstance = new PeerInstance(ProtocolId.MJS, uUID, uUID2);
        SSLContext sSLContext = this.createSharedSecretSSLContext();
        PackageInfo.LOGGER.info("Created shared secret SSLContext " + sSLContext);
        Certificate certificate = this.getPersistentConfiguration().isTrustingClients() ? this.getSharedSecretCertificate() : null;
        PackageInfo.LOGGER.info("Obtained shared secret certificate " + certificate);
        this.fJobManagerPeerSession = new JobManagerImplPeerSession(this.fPeerInstance, sSLContext, certificate);
        int n = 1024;
        this.fJobManagerPeerSession.start(this.getHostName(), this.getPeerSessionPort(), n);
    }

    private boolean shouldStartPeerSession() {
        return this.getPersistentConfiguration().allServerSocketsInCluster();
    }

    private int getPeerSessionPort() {
        return this.getPersistentConfiguration().getPeerSessionPort();
    }

    @Override
    public void prepareForShutdown() {
        try {
            this.fCWOStreamHandler.shutdown(10L);
        }
        catch (InterruptedException interruptedException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Interrupted while waiting for CWO streams to finish", interruptedException);
        }
        try {
            this.fStorage.close();
        }
        catch (Exception exception) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to shutdown database", exception);
        }
        try {
            this.fCredentialStorage.close();
        }
        catch (Exception exception) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to close credential storage", exception);
        }
        try {
            this.fLargeDataStorage.close();
        }
        catch (Exception exception) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to close large data storage", exception);
        }
        try {
            this.fAppendableDataStorage.close();
        }
        catch (Exception exception) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to close appendable data storage", exception);
        }
        this.fIsShutdown.set(true);
    }

    @Override
    public void setClusterLogLevel(int n, CredentialProviderLocal credentialProviderLocal) throws RemoteException, MJSException {
        WorkerLocal[] workerLocalArray;
        this.checkCredentialsAdminOnly(credentialProviderLocal);
        this.setLogLevel(n);
        for (WorkerLocal workerLocal : workerLocalArray = (WorkerLocal[])WorkerPool.instance().getAllWorkersOrderedByName()) {
            workerLocal.setLogLevel(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void getClusterLogs(OutputStream outputStream, CredentialProviderLocal credentialProviderLocal) throws IOException, MJSException {
        this.checkCredentialsAdminOnly(credentialProviderLocal);
        WorkerLocal[] workerLocalArray = (WorkerLocal[])WorkerPool.instance().getAllWorkersOrderedByName();
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));
        try {
            ArrayList<String> arrayList = new ArrayList<String>(workerLocalArray.length + 1);
            String string = this.getHostName() + ZIPPED_LOGS_SUFFIX;
            DirectoryZipEntryWriter directoryZipEntryWriter = new DirectoryZipEntryWriter(this.listLogs(), string);
            directoryZipEntryWriter.writeEntry(zipOutputStream);
            arrayList.add(this.getHostName());
            this.addWorkerLogs(workerLocalArray, zipOutputStream, arrayList);
        }
        finally {
            zipOutputStream.finish();
            zipOutputStream.flush();
        }
    }

    private void addWorkerLogs(WorkerLocal[] workerLocalArray, ZipOutputStream zipOutputStream, List<String> list) throws IOException {
        for (WorkerLocal workerLocal : workerLocalArray) {
            String string = workerLocal.getHostName();
            if (list.contains(string)) continue;
            String string2 = string + ZIPPED_LOGS_SUFFIX;
            WorkerLogsZipEntryWriter workerLogsZipEntryWriter = new WorkerLogsZipEntryWriter(workerLocal, this.getExporterFactory(), string2);
            workerLogsZipEntryWriter.writeEntry(zipOutputStream);
            list.add(string);
        }
    }

    @Override
    public void checkCredentials(String string, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        UserIdentity userIdentity = new UserIdentity(string);
        LinkedList<UserIdentity> linkedList = new LinkedList<UserIdentity>();
        this.getAuthorisationModule().checkCredentials(userIdentity, linkedList, credentialProviderLocal);
    }

    @Override
    public void checkCredentialsUserOnly(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        this.getAuthorisationModule().checkCredentialsUserOnly(userIdentity, credentialProviderLocal);
    }

    private void checkCredentialsAdminOnly(CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, RemoteException, CredentialStorageException {
        this.getAuthorisationModule().checkCredentialsAdminOnly(credentialProviderLocal);
    }

    @Override
    public boolean userExists(UserIdentity userIdentity) throws CredentialStorageException {
        return this.getAuthorisationModule().userExists(userIdentity);
    }

    @Override
    public void addNewUser(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        this.getAuthorisationModule().addNewUser(userIdentity, credentialProviderLocal);
    }

    @Override
    public void addAdminUser(CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, CredentialStorageException {
        this.getAuthorisationModule().addAdminUser(this.getAdminUserIdentity(), credentialProviderLocal);
    }

    @Override
    public void changeCredentialsOfExistingUser(UserIdentity userIdentity, CredentialProviderLocal credentialProviderLocal, CredentialProviderLocal credentialProviderLocal2) throws AuthorisationFailedException, CredentialStorageException {
        this.getAuthorisationModule().changeCredentialsOfExistingUser(userIdentity, credentialProviderLocal, credentialProviderLocal2);
    }

    @Override
    public void authoriseRegistration(Worker worker) throws RegistrationAuthority.RegistrationFailedException {
        WorkerProxy workerProxy = (WorkerProxy)worker;
        int n = workerProxy.getSecurityLevel();
        int n2 = this.getSecurityLevel();
        if (n2 != n) {
            throw new MisMatchedSecurityLevelException(workerProxy.getName(), n, n2);
        }
        boolean bl = SecurityModuleProvider.isRunAsUser(n2);
        boolean bl2 = this.getTrustModule().isTrusted(workerProxy);
        if (bl && !bl2) {
            throw new WorkerNotTrustedException(workerProxy.getName());
        }
        this.fPermissionStore.addPermission(workerProxy, ClientPermission.ALL_PERMISSIONS);
    }

    private ServerSocketAcceptInfo createWorkerAcceptInfo() {
        int n = this.getPersistentConfiguration().getWorkerMatlabPoolMinPort();
        int n2 = this.getPersistentConfiguration().getWorkerMatlabPoolMaxPort();
        return ServerSocketAcceptInfo.createTemplate(n, n2, 10);
    }

    private void createJobManagerProxy() throws ProxyCreationException {
        try {
            String string = this.getName() + "_" + this.getHostName() + "_" + this.getPersistentSessionID();
            ServerSocketConnectInfo serverSocketConnectInfo = null;
            ServerSocketAcceptInfo serverSocketAcceptInfo = null;
            if (this.fJobManagerPeerSession != null) {
                serverSocketConnectInfo = this.fJobManagerPeerSession.getConnectInfo();
                serverSocketAcceptInfo = this.createWorkerAcceptInfo();
            }
            this.fJobManagerProxy = new JobManagerProxy((JobManagerRemote)this.getStub(), this.getID(), this.fMinTransferUsingDataStore, this.getAllHostAddresses(), this.getHostName(), this.getName(), this.getMatlabRoot(), this.getLookupURL(), string, this.getAuthorisationModule().getRemoteAuthorisationModule(), this.getSecurityLevel(), serverSocketConnectInfo, serverSocketAcceptInfo, this.getPersistentConfiguration().requireWebLicensing());
        }
        catch (DistcompProxy.SerializeProxyException serializeProxyException) {
            throw new ProxyCreationException("Unable to serialize the job manager proxy", serializeProxyException);
        }
        catch (IOException iOException) {
            throw new ProxyCreationException("Unable to create a proxy to the job manager", iOException);
        }
    }

    private void initJobAndTaskRunner() throws ServiceExportException {
        long l = this.getPersistentConfiguration().getWorkerTimeoutIntervalMillis();
        long l2 = this.getPersistentConfiguration().getWorkerRenewalIntervalMillis();
        Uuid[] uuidArray = this.fStorage.readTasksByState(2);
        try {
            JobManagerImpl jobManagerImpl = this;
            WorkerPool.create(l, l2, this.fStorage, uuidArray, jobManagerImpl, this.getExporterFactory(), this.fUnitTesting);
        }
        catch (ExportException exportException) {
            throw new ServiceExportException("Unable to export a Worker Pool", exportException);
        }
        JobRunner.init(this, this.fStorage);
        TaskDispatcherForJobs.init(this.fStorage, this.getAuthorisationModule(), this.getNonTrustingExporterFactory(), this.fPermissionChecker);
        TaskDispatcherForParallelJobs.init(this.fStorage, this.getAuthorisationModule(), this.getNonTrustingExporterFactory(), this.fPermissionChecker);
    }

    private void initStorage(int n) throws StorageInitException {
        H2StorageFactory h2StorageFactory;
        int n2 = 4 * n;
        int n3 = 1 * n;
        String string = this.getPersistentConfiguration().getDatabaseToUse();
        String string2 = this.getPersistentConfiguration().getPersistenceDirectory();
        if ("H2".equalsIgnoreCase(string)) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Using H2 database.");
            h2StorageFactory = new H2StorageFactory(string2);
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unknown database name " + string + " found in config.");
            h2StorageFactory = new H2StorageFactory(string2);
        }
        DatabaseStorage databaseStorage = h2StorageFactory.createDatabaseStorage(n2);
        this.fCredentialStorage = h2StorageFactory.createCredentialStorage();
        this.fLargeDataStorage = databaseStorage;
        this.fAppendableDataStorage = h2StorageFactory.createBlobFileDataStorage(n3, 200);
        this.fStorage = databaseStorage;
        DatabaseStorage databaseStorage2 = databaseStorage;
        DatabaseStorage databaseStorage3 = databaseStorage;
        this.fWorkUnitInitializer = new WorkUnitInitializer(databaseStorage2, databaseStorage3, this.fLargeDataStorage, this.fAppendableDataStorage);
        databaseStorage.setWorkUnitInitializer(this.fWorkUnitInitializer);
    }

    private void initSecurity(CredentialStorage credentialStorage) {
        this.fWorkUnitInitializer.setCryptoModule(this.getCryptoModule());
        ClientPermissionStore clientPermissionStore = new ClientPermissionStore();
        this.fPermissionStore = clientPermissionStore;
        this.fPermissionChecker = clientPermissionStore;
        AuthorisationModuleConfig authorisationModuleConfig = new AuthorisationModuleConfig(this.getSecurityLevel(), this.allowGlobalPasswordlessLogon(), this.allowClientPasswordCache(), this.getName(), this.getHostName(), this.getCryptoModule(), credentialStorage, this.getAdminUserIdentity(), this.getAllowedUsers());
        this.fAuthorisationModule = SecurityModuleProvider.createAuthorisationModule(authorisationModuleConfig);
    }

    private AuthorisationModule getAuthorisationModule() {
        return this.fAuthorisationModule;
    }

    private void initJobCounter() {
        Uuid[] uuidArray = this.fStorage.readJobsByState(1);
        int n = uuidArray.length;
        JobCounter.instance().incQueuedJobs(n);
        Uuid[] uuidArray2 = this.fStorage.readJobsByState(2);
        int n2 = 0;
        for (Uuid uuid : uuidArray2) {
            int n3 = this.fStorage.countTasksByJobIDAndBeforeState(uuid, 3);
            if (n3 <= 0) continue;
            ++n2;
        }
        JobCounter.instance().incRunningJobs(n2);
    }

    private void initAccessObjects() throws ProxyCreationException, ServiceExportException {
        String string = this.getPersistentConfiguration().getPersistenceDirectory();
        int n = this.getPersistentConfiguration().getMaxConcurrentResultSubmissions();
        try {
            this.fJobAccess = new JobAccessImpl(this.fMinTransferUsingDataStore, this.fStorage, string, this.fJobManagerProxy, this.getAuthorisationModule(), this.getExporterFactory());
            this.fParallelJobAccess = new ParallelJobAccessImpl(this.fMinTransferUsingDataStore, this.fStorage, string, this.fJobManagerProxy, this.getAuthorisationModule(), this.getExporterFactory());
            this.fTaskAccess = new TaskAccessImpl(this.fMinTransferUsingDataStore, this.fStorage, string, this.fJobManagerProxy, this.getAuthorisationModule(), n, this.getExporterFactory());
        }
        catch (ExportException exportException) {
            throw new ServiceExportException("Unable to export proxies to the access objects on the job manager", exportException);
        }
        catch (DistcompProxy.SerializeProxyException serializeProxyException) {
            throw new ProxyCreationException("Unable to serialize the job manager proxy", serializeProxyException);
        }
    }

    private void initCWOHandler() {
        ExecutorService executorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory("Command window output input stream handler-", PackageInfo.LOGGER));
        CWOWriteRequestor cWOWriteRequestor = new CWOWriteRequestor(this.fTaskAccess);
        this.fCWOStreamHandler = new CWOInputStreamHandler(cWOWriteRequestor, (int)this.fMinTransferUsingDataStore);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    do {
                        JobManagerImpl.this.fCWOStreamHandler.waitForBytes();
                        JobManagerImpl.this.fCWOStreamHandler.readAvailableBytesFromStreams();
                    } while (!JobManagerImpl.this.fIsShutdown.get());
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Shutting down command window output stream handler");
                }
                catch (IOException iOException) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Command window output handler thread terminated due to an IOException", iOException);
                }
                catch (InterruptedException interruptedException) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Command window output handler thread terminated due to an interruption", interruptedException);
                    Thread.currentThread().interrupt();
                }
            }
        };
        this.fTaskAccess.setCWOInputStreamHandler(this.fCWOStreamHandler);
        executorService.execute(runnable);
        executorService.shutdown();
    }

    private String[][] getAllWorkerHostsAndNames() throws RemoteException {
        Worker[] workerArray = WorkerPool.instance().getAllWorkersOrderedByName();
        String[][] stringArray = new String[2][workerArray.length];
        int n = 0;
        for (Worker worker : workerArray) {
            stringArray[0][n] = worker.getHostName();
            stringArray[1][n++] = worker.getName();
        }
        return stringArray;
    }

    private long getFileOrDirectorySize(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                long l = 0L;
                for (File file2 : fileArray) {
                    long l2 = this.getFileOrDirectorySize(file2);
                    if (l2 == -1L) continue;
                    l += l2;
                }
                return l;
            }
            return -1L;
        }
        return file.length();
    }

    @Override
    protected PersistentServiceConfiguration createServiceConfiguration(Configuration configuration, String string) throws ConfigurationException, PersistenceDirException {
        return new PersistentJobManagerConfiguration(configuration, string);
    }

    @Override
    protected String serviceTypeForPrinting() {
        return "jobmanager";
    }

    @Override
    public DistcompService getDistcompProxy() {
        return this.fJobManagerProxy;
    }

    @Override
    public void pauseQueue() throws RemoteException, MJSException {
        block2: {
            int n = this.getPersistentConfiguration().getJobManagerState();
            try {
                this.getPersistentConfiguration().setJobManagerState(1);
            }
            catch (PersistenceDirException persistenceDirException) {
                if (n != 0) break block2;
                String string = "The job manager's queue has been paused.\nHowever, the state of the queue could not be saved in the directory:\n\t" + persistenceDirException.getPersistenceDir() + "\non the job manager computer. Restarting the job manager may cause jobs" + "\nin the queue to begin running.";
                new ErrorPrinterImpl().printError(string, persistenceDirException);
                throw new SavePausedStateException(string, persistenceDirException);
            }
        }
    }

    @Override
    public void resumeQueue() throws RemoteException, MJSException {
        block2: {
            int n = this.getPersistentConfiguration().getJobManagerState();
            try {
                this.getPersistentConfiguration().setJobManagerState(0);
            }
            catch (PersistenceDirException persistenceDirException) {
                if (n != 1) break block2;
                String string = "Jobs in the job manager's queue can begin running.\nHowever, the state of the queue could not be saved in the directory:\n\t" + persistenceDirException.getPersistenceDir() + "\non the job manager computer. Restarting the job manager may cause the" + "\nqueue to be paused again.";
                new ErrorPrinterImpl().printError(string, persistenceDirException);
                throw new SaveRunningStateException(string, persistenceDirException);
            }
        }
        JobRunner.instance().runAvailableTasks();
    }

    @Override
    public Uuid createJob(JobInfo jobInfo, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, MJSException {
        this.checkCredentials(jobInfo.getUserName(), credentialProviderLocal);
        int n = jobInfo.getJobMLType();
        long l = this.fStorage.nextJobNum();
        Uuid uuid = this.createJobInStorage(l, n, jobInfo.getUserName());
        try {
            this.fJobAccess.setWorkUnitInfo(new Uuid[]{uuid}, new JobInfo[]{jobInfo}, credentialProviderLocal);
        }
        catch (MJSException mJSException) {
            this.fStorage.removeJob(uuid);
            throw mJSException;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "job " + l + " has been created");
        return uuid;
    }

    @Override
    public Uuid createParallelJob(JobInfo jobInfo, CredentialProviderLocal credentialProviderLocal) throws AuthorisationFailedException, MJSException {
        this.checkCredentials(jobInfo.getUserName(), credentialProviderLocal);
        int n = jobInfo.getJobMLType();
        long l = this.fStorage.nextJobNum();
        Uuid uuid = this.createParallelJobInStorage(l, n, jobInfo.getUserName());
        try {
            this.fParallelJobAccess.setWorkUnitInfo(new Uuid[]{uuid}, new JobInfo[]{jobInfo}, credentialProviderLocal);
        }
        catch (MJSException mJSException) {
            this.fStorage.removeJob(uuid);
            throw mJSException;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "parallel job " + l + " has been created");
        return uuid;
    }

    @Override
    public Uuid createMatlabPoolJob(JobInfo jobInfo, CredentialProviderLocal credentialProviderLocal, byte[] byArray, byte[] byArray2) throws AuthorisationFailedException, MJSException {
        this.checkCredentials(jobInfo.getUserName(), credentialProviderLocal);
        int n = jobInfo.getJobMLType();
        long l = this.fStorage.nextJobNum();
        Uuid uuid = this.createMatlabPoolJobInStorage(l, n, jobInfo.getUserName(), byArray, byArray2);
        try {
            this.fParallelJobAccess.setWorkUnitInfo(new Uuid[]{uuid}, new JobInfo[]{jobInfo}, credentialProviderLocal);
        }
        catch (MJSException mJSException) {
            this.fStorage.removeJob(uuid);
            throw mJSException;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "MatlabPool job " + l + " has been created");
        return uuid;
    }

    @Override
    public JobIDAndMLType[] getJobs() {
        return this.fStorage.readJobsAndTypes();
    }

    @Override
    public JobIDAndMLType[][] getJobs(int[] nArray) {
        return this.getJobsFromStorage(nArray);
    }

    @Override
    public JobAccessLocal getJobAccess() {
        return (JobAccessLocal)this.fJobAccess.getProxy();
    }

    @Override
    public ParallelJobAccessLocal getParallelJobAccess() {
        return (ParallelJobAccessLocal)this.fParallelJobAccess.getProxy();
    }

    @Override
    public TaskAccessLocal getTaskAccess() {
        return (TaskAccessLocal)this.fTaskAccess.getProxy();
    }

    @Override
    public WorkerRegistration getWorkerRegistration() {
        return WorkerPool.instance().getStub();
    }

    @Override
    public int getState() {
        return this.getPersistentConfiguration().getJobManagerState();
    }

    @Override
    public boolean allowClientPasswordCache() {
        return this.getPersistentConfiguration().allowClientPasswordCache();
    }

    @Override
    public UserIdentity getAdminUserIdentity() {
        return new UserIdentity(this.getPersistentConfiguration().getAdminUser());
    }

    private AllowedUserList getAllowedUsers() {
        return AllowedUserList.create(this.getPersistentConfiguration().getAllowedUsers());
    }

    private boolean allowGlobalPasswordlessLogon() {
        return this.getPersistentConfiguration().allowGlobalPasswordlessLogon();
    }

    @Override
    public boolean requireWebLicensing() {
        return this.getPersistentConfiguration().requireWebLicensing();
    }

    @Override
    public DistcompServiceInfo getServiceInfo() {
        int n = this.getPersistentConfiguration().getJobManagerState();
        WorkerProperties[] workerPropertiesArray = this.getIdleWorkerProperties();
        WorkerProperties[] workerPropertiesArray2 = this.getBusyWorkerProperties();
        return new JobManagerServiceInfo(workerPropertiesArray, workerPropertiesArray2, workerPropertiesArray.length, workerPropertiesArray2.length, this.getJobs(), n);
    }

    @Override
    public NodeInfo getNodeInfo() throws RemoteException {
        long l = Runtime.getRuntime().totalMemory();
        String string = this.getPersistentConfiguration().getPersistenceDirectory();
        long l2 = this.getFileOrDirectorySize(new File(string));
        long l3 = this.getPersistentConfiguration().getWorkerRenewalIntervalMillis();
        String[][] stringArray = this.getAllWorkerHostsAndNames();
        long l4 = this.fStorage.getCacheSize();
        JobManagerNodeInfo jobManagerNodeInfo = new JobManagerNodeInfo(l, l2, l4, l3, stringArray[0], stringArray[1]);
        this.setDistcompServiceNodeInfo(jobManagerNodeInfo);
        return jobManagerNodeInfo;
    }

    @Override
    public int getNumIdleWorkers() {
        return WorkerPool.instance().getNumIdleWorkers();
    }

    @Override
    public int getNumBusyWorkers() {
        return WorkerPool.instance().getNumBusyWorkers();
    }

    @Override
    public Worker[] getIdleWorkers() {
        return WorkerPool.instance().getIdleWorkers();
    }

    @Override
    public Worker[] getBusyWorkers() {
        return WorkerPool.instance().getBusyWorkers();
    }

    @Override
    public WorkerProperties[] getIdleWorkerProperties() {
        return WorkerPool.instance().getIdleWorkerProperties();
    }

    @Override
    public WorkerProperties[] getBusyWorkerProperties() {
        return WorkerPool.instance().getBusyWorkerProperties();
    }

    @Override
    public void promote(Uuid uuid) throws DistcompException {
        boolean bl = true;
        this.jobPromoteOrDemote(bl, uuid);
    }

    @Override
    public void demote(Uuid uuid) throws DistcompException {
        boolean bl = false;
        this.jobPromoteOrDemote(bl, uuid);
    }

    @Override
    public void testCommunicationWithClient(CommTestInfo commTestInfo) throws DistcompException {
        try {
            commTestInfo.testCommunication();
        }
        catch (RemoteException remoteException) {
            throw new DistcompException(new CommTestException(remoteException));
        }
    }

    @Override
    public String getLookupURL() {
        LookupLocator[] lookupLocatorArray = this.fServiceConfig.getLookupLocators();
        if (lookupLocatorArray != null && lookupLocatorArray.length > 0) {
            return lookupLocatorArray[0].getHost() + ':' + lookupLocatorArray[0].getPort();
        }
        return "";
    }

    @Override
    public void removeWorker(Uuid uuid) {
        WorkerPool.instance().removeWorker(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobPromoteOrDemote(boolean bl, Uuid uuid) throws DistcompException {
        JobImpl jobImpl = this.retrieveQueuedJob(uuid);
        Object object = this.fPromoteDemoteLock;
        synchronized (object) {
            boolean bl2 = false;
            while (!bl2) {
                long l = jobImpl.getQueueNum();
                Uuid uuid2 = bl ? this.fStorage.readPreviousQueuedJob(l) : this.fStorage.readNextQueuedJob(l);
                if (uuid2 == null) {
                    return;
                }
                bl2 = this.swapQueuePosition(jobImpl, uuid2);
            }
        }
    }

    private JobImpl retrieveQueuedJob(Uuid uuid) throws DistcompException {
        JobImpl jobImpl;
        try {
            jobImpl = (JobImpl)this.fStorage.readWorkUnit(uuid);
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            throw new DistcompException(workUnitNotFoundException);
        }
        if (jobImpl.getState() != 1) {
            throw new DistcompException(new WorkUnitStateException("Job is not in the queued state"));
        }
        return jobImpl;
    }

    private boolean swapQueuePosition(JobImpl jobImpl, Uuid uuid) {
        JobImpl jobImpl2;
        try {
            jobImpl2 = this.retrieveQueuedJob(uuid);
        }
        catch (DistcompException distcompException) {
            return false;
        }
        long l = jobImpl.getQueueNum();
        long l2 = jobImpl2.getQueueNum();
        try {
            jobImpl.setQueueNum(l2);
        }
        catch (MJSException mJSException) {
            return false;
        }
        try {
            jobImpl2.setQueueNum(l);
        }
        catch (MJSException mJSException) {
            // empty catch block
        }
        return true;
    }

    private Uuid createJobInStorage(long l, int n, String string) {
        return this.fStorage.putJob(new JobImpl(l, n, string));
    }

    private Uuid createParallelJobInStorage(long l, int n, String string) {
        return this.fStorage.putJob(new ParallelJobImpl(l, n, string));
    }

    private Uuid createMatlabPoolJobInStorage(long l, int n, String string, byte[] byArray, byte[] byArray2) {
        return this.fStorage.putJob(new MatlabPoolJobImpl(l, n, string, byArray, byArray2));
    }

    private JobIDAndMLType[][] getJobsFromStorage(int[] nArray) {
        return this.fStorage.readJobsAndTypesByState(nArray);
    }

    private PersistentJobManagerConfiguration getPersistentConfiguration() {
        return (PersistentJobManagerConfiguration)this.fServiceConfig;
    }

    public long getMaxJMHeapMemoryForUnitTests() {
        return this.getPersistentConfiguration().getMaxJobManagerHeapMemory();
    }

    public long getMinTransferUsingDataStoreForUnitTests() {
        return this.fMinTransferUsingDataStore;
    }

    @Override
    public void destroyForUnitTests() throws Exception {
        JobCounter.clear();
        JobRunner.clear();
        WorkerPool.destroy();
        TaskDispatcherForJobs.clear();
        TaskDispatcherForParallelJobs.clear();
        WorkUnitTimeoutChecker.clear();
        super.destroyForUnitTests();
        this.prepareForShutdown();
        if (this.fJobManagerPeerSession != null) {
            this.fJobManagerPeerSession.stop();
        }
        this.fJobManagerPeerSession = null;
        this.getPersistentConfiguration().destroy();
    }

    public static final class MisMatchedSecurityLevelException
    extends RegistrationAuthority.FatalRegistrationFailedException {
        MisMatchedSecurityLevelException(String string, int n, int n2) {
            super("Worker " + string + " " + "can not register with the job manager as it has the wrong security level.\n" + "Job manager security level = " + n2 + "\n" + "Worker security level = " + n);
        }
    }

    public static final class WorkerNotTrustedException
    extends RegistrationAuthority.FatalRegistrationFailedException {
        WorkerNotTrustedException(String string) {
            super("Worker " + string + " is not trusted!");
        }
    }
}

