/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.storage.StorageCache;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.util.SystemTimeProvider;
import com.mathworks.toolbox.distcomp.util.TimeProvider;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import net.jini.id.Uuid;

public final class WorkUnitTimeoutChecker {
    private static WorkUnitTimeoutChecker sWorkUnitTimeoutChecker;
    private static Thread sCheckerThread;
    private final HashMap<Uuid, WorkUnitTimeout> fWorkUnitTimeouts = new HashMap();
    private final StorageCache fStorage;
    private final TimeProvider fTimeProvider;
    private boolean fTerminated = false;

    public WorkUnitTimeoutChecker(StorageCache storageCache) {
        this.fStorage = storageCache;
        this.fTimeProvider = new SystemTimeProvider();
    }

    public WorkUnitTimeoutChecker(StorageCache storageCache, TimeProvider timeProvider) {
        this.fStorage = storageCache;
        this.fTimeProvider = timeProvider;
    }

    static void init(StorageCache storageCache) {
        if (sWorkUnitTimeoutChecker == null) {
            sWorkUnitTimeoutChecker = new WorkUnitTimeoutChecker(storageCache);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    sWorkUnitTimeoutChecker.check();
                }
            };
            sCheckerThread = new Thread(runnable, "WorkUnitTimeoutChecker");
            sCheckerThread.start();
        }
    }

    static void clear() {
        sWorkUnitTimeoutChecker.terminate();
        try {
            sCheckerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        sWorkUnitTimeoutChecker = null;
    }

    public static WorkUnitTimeoutChecker instance() {
        return sWorkUnitTimeoutChecker;
    }

    public synchronized void addWorkUnit(Uuid uuid, long l) {
        if (l != Long.MAX_VALUE) {
            this.fWorkUnitTimeouts.put(uuid, new WorkUnitTimeout(uuid, l));
        }
        this.notify();
    }

    public synchronized void removeWorkUnit(Uuid uuid) {
        this.fWorkUnitTimeouts.remove(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        while (true) {
            WorkUnitTimeoutChecker workUnitTimeoutChecker = this;
            synchronized (workUnitTimeoutChecker) {
                if (this.fTerminated) {
                    return;
                }
            }
            this.removeExpiredRegistrationsAndThenWaitOrCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpiredRegistrationsAndThenWaitOrCancel() {
        ArrayList<Uuid> arrayList = new ArrayList<Uuid>();
        WorkUnitTimeoutChecker workUnitTimeoutChecker = this;
        synchronized (workUnitTimeoutChecker) {
            long l = Long.MAX_VALUE;
            long l2 = this.fTimeProvider.currentTimeMillis();
            long l3 = this.removeExpiredRegistrations(l2, arrayList);
            if (l3 < l) {
                l = l3;
            }
            if (arrayList.size() == 0) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        for (Uuid uuid : arrayList) {
            this.cancelWorkUnit(uuid);
        }
    }

    private synchronized void terminate() {
        this.fTerminated = true;
        this.notify();
    }

    private long removeExpiredRegistrations(long l, ArrayList<Uuid> arrayList) {
        long l2 = Long.MAX_VALUE;
        Collection<WorkUnitTimeout> collection = this.fWorkUnitTimeouts.values();
        Iterator<WorkUnitTimeout> iterator = collection.iterator();
        while (iterator.hasNext()) {
            WorkUnitTimeout workUnitTimeout = iterator.next();
            if (workUnitTimeout.isExpired(l)) {
                arrayList.add(workUnitTimeout.iWorkUnitID);
                iterator.remove();
                continue;
            }
            long l3 = workUnitTimeout.iStartTimeMillis + workUnitTimeout.iTimeoutMillis - l + 1L;
            if (l3 >= l2) continue;
            l2 = l3;
        }
        return l2;
    }

    private void cancelWorkUnit(Uuid uuid) {
        try {
            WorkUnitImpl workUnitImpl = this.fStorage.readWorkUnit(uuid);
            long l = workUnitImpl.getTimeout() / 1000L;
            String string = workUnitImpl.workUnitTypeForPrinting();
            String string2 = "The " + string + " was cancelled because it " + "failed to finish within the specified " + string + " timeout of " + l + " seconds.";
            if (workUnitImpl instanceof TaskImpl) {
                workUnitImpl.rerunOrCancel(string2);
            } else {
                workUnitImpl.cancel(string2);
            }
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            // empty catch block
        }
    }

    private class WorkUnitTimeout {
        private Uuid iWorkUnitID;
        private long iTimeoutMillis;
        private long iStartTimeMillis;

        WorkUnitTimeout(Uuid uuid, long l) {
            this.iWorkUnitID = uuid;
            this.iTimeoutMillis = l;
            this.iStartTimeMillis = WorkUnitTimeoutChecker.this.fTimeProvider.currentTimeMillis();
        }

        public boolean isExpired(long l) {
            long l2 = l - this.iStartTimeMillis;
            return l2 > this.iTimeoutMillis;
        }
    }
}

