/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import com.mathworks.jmi.Matlab;
import com.mathworks.toolbox.distcomp.local.LocalConstants;
import com.mathworks.toolbox.distcomp.local.MpiexecException;
import com.mathworks.toolbox.distcomp.remote.util.StreamRedirector;
import com.mathworks.toolbox.distcomp.util.NullOutputStream;
import com.mathworks.toolbox.distcomp.util.ProcessBuilderUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;

public class SmpdDaemonManager
implements Runnable {
    private static SmpdDaemonManager sSMPD_MANAGER;
    private Process fSmpdProcess = null;
    private int fSmpdPort;
    private File fSmpdFile;
    private StreamRedirector fRedirector;
    private StreamRedirector.RedirectionPair fInToken;
    private StreamRedirector.RedirectionPair fErrToken;
    private boolean fGotLaunchInformation = false;
    private String[] fCmdAndArgs;
    private String[] fEnvNames;
    private String[] fEnvValues;
    private int fUseCount = 0;

    public static synchronized SmpdDaemonManager getManager() {
        if (sSMPD_MANAGER == null) {
            sSMPD_MANAGER = new SmpdDaemonManager();
            Matlab.registerQuitListener((Runnable)sSMPD_MANAGER);
        }
        return sSMPD_MANAGER;
    }

    private SmpdDaemonManager() {
    }

    public synchronized int getPortAndIncrementUsage() throws MpiexecException {
        assert (this.fGotLaunchInformation);
        this.ensureSmpdProcess();
        ++this.fUseCount;
        return this.fSmpdPort;
    }

    public synchronized void releaseUsage() {
        --this.fUseCount;
        if (this.fUseCount < 0) {
            this.fUseCount = 0;
            assert (false);
        }
    }

    public synchronized boolean isDaemonInUse() {
        return this.fUseCount > 0;
    }

    public boolean supplyLaunchInformation(String[] stringArray, String[] stringArray2, String[] stringArray3, String string) throws MpiexecException, IllegalArgumentException {
        if (stringArray2 != null && stringArray3 != null) {
            if (stringArray2.length != stringArray3.length) {
                throw new IllegalArgumentException("Number of names must be the same as the number of values");
            }
            this.fEnvNames = Arrays.copyOf(stringArray2, stringArray2.length);
            this.fEnvValues = Arrays.copyOf(stringArray3, stringArray3.length);
        } else {
            if (stringArray2 != null || stringArray3 != null) {
                throw new IllegalArgumentException("Number of names must be the same as the number of values");
            }
            this.fEnvNames = new String[0];
            this.fEnvValues = new String[0];
        }
        this.fCmdAndArgs = Arrays.copyOf(stringArray, stringArray.length);
        this.fSmpdFile = new File(string);
        this.fGotLaunchInformation = true;
        this.ensureSmpdProcess();
        return true;
    }

    public synchronized void stopSmpd() {
        if (this.smpdProcessIsAlive()) {
            try {
                this.fSmpdFile.delete();
                this.fRedirector.removeRedirect(this.fInToken);
                this.fRedirector.removeRedirect(this.fErrToken);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.fSmpdProcess.destroy();
        }
    }

    @Override
    public void run() {
        this.stopSmpd();
    }

    private synchronized void ensureSmpdProcess() throws MpiexecException {
        if (!this.smpdProcessIsAlive()) {
            try {
                this.fSmpdPort = this.buildSmpdProcess();
            }
            catch (Exception exception) {
                throw new MpiexecException("Failed to launch SMPD process", exception);
            }
        }
    }

    private synchronized boolean smpdProcessIsAlive() {
        if (this.fSmpdProcess == null) {
            return false;
        }
        try {
            int n = this.fSmpdProcess.exitValue();
            this.fSmpdProcess = null;
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    private synchronized int buildSmpdProcess() throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(this.fCmdAndArgs);
        Map<String, String> map = processBuilder.environment();
        for (int i = 0; i < this.fEnvNames.length; ++i) {
            if (this.fEnvNames[i] == null || this.fEnvValues[i] == null) {
                throw new IllegalArgumentException("Names and values must be non-null");
            }
            map.put(this.fEnvNames[i], this.fEnvValues[i]);
        }
        this.fSmpdProcess = ProcessBuilderUtils.createProcessFromBuilderWithRetry(processBuilder, ProcessBuilderUtils.nullDelayer(), LocalConstants.sNUMBER_OF_PROCESS_RETRIES, LocalConstants.sPROCESS_RETRY_INTERVAL);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.fSmpdProcess.getInputStream()));
        String string = bufferedReader.readLine();
        NullOutputStream nullOutputStream = new NullOutputStream();
        this.fRedirector = StreamRedirector.getInstance();
        this.fInToken = this.fRedirector.addRedirect(this.fSmpdProcess.getInputStream(), nullOutputStream);
        this.fErrToken = this.fRedirector.addRedirect(this.fSmpdProcess.getErrorStream(), nullOutputStream);
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.stopSmpd();
            throw new IOException("Couldn't get the port from the SMPD process output: <" + string + ">");
        }
    }
}

