/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.logging;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.logging.LineEndingFormatter;
import com.mathworks.toolbox.distcomp.logging.SafeStreamHandler;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class DistcompConsoleHandler
extends SafeStreamHandler {
    public DistcompConsoleHandler(int n) {
        Level level = DistcompLevel.getLevelFromValue(n);
        this.setLevel(level);
        this.setFormatter(new LineEndingFormatter());
        this.setOutputStream(this.getStdoutStream());
    }

    @Override
    public synchronized void reallyPublish(LogRecord logRecord) {
        this.streamPublish(logRecord);
        this.flush();
    }

    private PrintStream getStdoutStream() {
        try {
            Class<?> clazz = Class.forName("com.mathworks.mvm.helpers.MatlabPrintStreamManager", true, DistcompConsoleHandler.class.getClassLoader());
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            Method method2 = clazz.getDeclaredMethod("getOriginalSystemOut", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Object object2 = method2.invoke(object, new Object[0]);
            return (PrintStream)object2;
        }
        catch (Throwable throwable) {
            System.out.println("Using current System.out for logging");
            return System.out;
        }
    }

    @Override
    public synchronized void close() {
        this.flush();
    }
}

