/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.datastore;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStore;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreItem;
import com.mathworks.toolbox.distcomp.util.UnavailableEphemeralPortsException;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.ServerException;

public class DataStoreInputStream
extends InputStream {
    private DataStore fDataStore;
    private DataStoreItem fDataStoreItem;

    public DataStoreInputStream(DataStore dataStore, DataStoreItem dataStoreItem) {
        this.fDataStore = dataStore;
        this.fDataStoreItem = dataStoreItem;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        return n == -1 ? -1 : byArray[0];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray2 = null;
        try {
            byArray2 = this.fDataStore.read(this.fDataStoreItem, n2);
        }
        catch (ConnectIOException connectIOException) {
            this.tryToDetectUnavailableEphemeralPorts(connectIOException);
        }
        catch (ServerException serverException) {
            this.tryToRecoverDistcompException(serverException);
        }
        if (byArray2 == null) {
            return 0;
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    private void tryToRecoverDistcompException(ServerException serverException) throws RemoteException {
        if (serverException.getCause() instanceof DistcompException) {
            throw (DistcompException)serverException.getCause();
        }
        throw serverException;
    }

    private void tryToDetectUnavailableEphemeralPorts(ConnectIOException connectIOException) throws RemoteException {
        if (connectIOException.getCause() instanceof BindException) {
            throw new DistcompException(new UnavailableEphemeralPortsException());
        }
        throw connectIOException;
    }
}

