/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.peerlookupservice;

import com.mathworks.toolbox.distcomp.jobmanager.JobManagerConnectorSSLSecurityDescription;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.JobManagerLookupRequest;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.Log;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.PeerLookupAccessorErrorCode;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.PeerLookupService;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.ServiceLookupExceptionResponse;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.ServiceLookupRequest;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.ServiceLookupResponse;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.ServiceLookupSucceededResponse;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.WorkerLookupRequest;
import com.mathworks.toolbox.distcomp.pmode.FatalErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerConnector;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerDispatcher;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSession;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.ProtocolId;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorPlainSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.HandShake;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessageFuture;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.distcomp.service.UnresolvableLookupURLException;
import com.mathworks.toolbox.distcomp.util.Accessor;
import com.mathworks.toolbox.distcomp.util.AccessorException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLException;

public final class PeerLookupAccessor
implements Accessor {
    private static final AtomicLong SEQUENCE_NUMBER_SOURCE = new AtomicLong(0L);
    private final PeerInstance fLocalInstance;
    private final InetSocketAddress fLookupServiceAddress;
    private final boolean fIsSecure;
    private int fLookupTimeoutSeconds = 30;

    public PeerLookupAccessor(String string, int n) throws AccessorException {
        this(new InetSocketAddress(string, n), true);
    }

    public PeerLookupAccessor(InetSocketAddress inetSocketAddress, boolean bl) throws PeerLookupAccessorException {
        this.fLookupServiceAddress = inetSocketAddress;
        this.fLocalInstance = new PeerInstance(ProtocolId.MJS, PeerLookupService.LOOKUP_SERVICE_GROUP_UUID, UUID.randomUUID());
        this.fIsSecure = bl;
    }

    public PeerLookupAccessor(String string) throws PeerLookupAccessorException {
        this(PeerLookupAccessor.urlToInetSocketAddress(string), true);
    }

    private static InetSocketAddress urlToInetSocketAddress(String string) throws BadLookupServiceURI {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new BadLookupServiceURI(string, (Throwable)uRISyntaxException);
        }
        if (uRI.getHost() == null) {
            throw new BadLookupServiceURI(string);
        }
        if (uRI.getPort() == -1) {
            throw new BadLookupServiceURI(string);
        }
        if (uRI.getScheme() == null || !PeerLookupService.isPeerLookupScheme(uRI)) {
            throw new BadLookupServiceURI(string);
        }
        return new InetSocketAddress(uRI.getHost(), uRI.getPort());
    }

    public int getLookupTimeoutSeconds() {
        return this.fLookupTimeoutSeconds;
    }

    public void setLookupTimeoutSeconds(int n) {
        this.fLookupTimeoutSeconds = n;
    }

    private PeerSession createSession(PeerInstance peerInstance) throws PeerLookupAccessorException {
        List<Connection> list = Collections.emptyList();
        Set<PeerDispatcher<? extends Message>> set = Collections.emptySet();
        return new PeerSession(peerInstance, new FatalErrorHandler(false), set, list);
    }

    private Connection connectToLookupService(InetSocketAddress inetSocketAddress, PeerInstance peerInstance) throws HandShake.HandShakeException, PeerConnector.CouldNotConnectException {
        ConnectorSecurityDescription connectorSecurityDescription;
        if (this.fIsSecure) {
            boolean bl = true;
            connectorSecurityDescription = new JobManagerConnectorSSLSecurityDescription(bl);
        } else {
            connectorSecurityDescription = new ConnectorPlainSecurityDescription();
        }
        ServerSocketConnectInfo serverSocketConnectInfo = new ServerSocketConnectInfo(inetSocketAddress, peerInstance.getGroupUuid(), connectorSecurityDescription, 10000L);
        PeerConnector peerConnector = new PeerConnector();
        return peerConnector.activelyConnectTo(serverSocketConnectInfo, peerInstance);
    }

    private Instance connectToLookupServiceInstance(PeerSession peerSession) throws PeerLookupAccessorException, UnresolvableLookupURLException {
        Connection connection;
        try {
            connection = this.connectToLookupService(this.fLookupServiceAddress, this.fLocalInstance);
        }
        catch (PeerConnector.CouldNotConnectUnknownHostException couldNotConnectUnknownHostException) {
            throw new UnresolvableLookupURLException(this.getLookupServiceURI().toString(), this.getLookupServiceURI().getHost(), couldNotConnectUnknownHostException);
        }
        catch (PeerMessagingException peerMessagingException) {
            if (peerMessagingException.getCause() instanceof SSLException) {
                throw new RequiredCertificateNotProvidedException(this.getLookupServiceURI(), (Throwable)peerMessagingException);
            }
            throw new CannotConnectToLookupServiceException(this.getLookupServiceURI(), (Throwable)peerMessagingException);
        }
        try {
            peerSession.addConnection(connection);
        }
        catch (RuntimeException runtimeException) {
            this.safeCloseConnection(connection);
            throw new CannotConnectToLookupServiceException(this.getLookupServiceURI(), (Throwable)runtimeException);
        }
        return connection.getRemoteInstance();
    }

    private void safeCloseConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (IOException iOException) {
            Log.LOGGER.log(DistcompLevel.TWO, "Failed to close connection to lookup service", iOException);
        }
    }

    @Override
    public Object[] getJobManagers(String string) throws AccessorException {
        JobManagerLookupRequest jobManagerLookupRequest = new JobManagerLookupRequest(SEQUENCE_NUMBER_SOURCE.getAndIncrement(), string);
        return this.makeRequest(jobManagerLookupRequest);
    }

    @Override
    public Object[] getMLWorkers(String string) throws AccessorException {
        WorkerLookupRequest workerLookupRequest = new WorkerLookupRequest(SEQUENCE_NUMBER_SOURCE.getAndIncrement(), string);
        return this.makeRequest(workerLookupRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] makeRequest(ServiceLookupRequest serviceLookupRequest) throws PeerLookupAccessorException, UnresolvableLookupURLException {
        PeerSession peerSession = this.createSession(this.fLocalInstance);
        try {
            Object[] objectArray = this.connectSendAndWait(peerSession, serviceLookupRequest);
            return objectArray;
        }
        finally {
            peerSession.normalShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] connectSendAndWait(PeerSession peerSession, ServiceLookupRequest serviceLookupRequest) throws PeerLookupAccessorException, UnresolvableLookupURLException {
        Instance instance = this.connectToLookupServiceInstance(peerSession);
        try {
            Object[] objectArray = this.sendRequestAndWaitForResponse(peerSession, instance, serviceLookupRequest);
            return objectArray;
        }
        finally {
            peerSession.removeInstance(instance);
        }
    }

    private Object[] sendRequestAndWaitForResponse(PeerSession peerSession, Instance instance, ServiceLookupRequest serviceLookupRequest) throws PeerLookupAccessorException {
        ObservableMessageFuture<ServiceLookupResponse> observableMessageFuture = new ObservableMessageFuture<ServiceLookupResponse>(ServiceLookupResponse.class);
        peerSession.getOutputGroup().sendTo(instance, serviceLookupRequest, observableMessageFuture);
        try {
            ServiceLookupResponse serviceLookupResponse = (ServiceLookupResponse)observableMessageFuture.get(this.fLookupTimeoutSeconds, TimeUnit.SECONDS);
            if (serviceLookupResponse != null) {
                if (serviceLookupResponse instanceof ServiceLookupSucceededResponse) {
                    ServiceLookupSucceededResponse serviceLookupSucceededResponse = (ServiceLookupSucceededResponse)serviceLookupResponse;
                    return serviceLookupSucceededResponse.getServices();
                }
                if (serviceLookupResponse instanceof ServiceLookupExceptionResponse) {
                    ServiceLookupExceptionResponse serviceLookupExceptionResponse = (ServiceLookupExceptionResponse)serviceLookupResponse;
                    throw new RemoteLookupServiceException(this.getLookupServiceURI(), serviceLookupExceptionResponse.getAccessorException());
                }
                Log.LOGGER.log(DistcompLevel.ONE, "Unexpected response type: " + serviceLookupResponse.getClass());
                throw new IllegalStateException("Unexpected response type: " + serviceLookupResponse.getClass());
            }
            Log.LOGGER.log(DistcompLevel.ONE, "PeerLookupAccessor: Timed out while waiting for response.");
            throw new LookupTimedOutException(this.getLookupServiceURI());
        }
        catch (InterruptedException interruptedException) {
            Log.LOGGER.log(DistcompLevel.ONE, "PeerLookupAccessor: Interrupted while waiting for response.");
            return new Object[0];
        }
        catch (ExecutionException executionException) {
            Log.LOGGER.log(DistcompLevel.ONE, "PeerLookupAccessor: ExecutionException while handling response.", executionException);
            return new Object[0];
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PeerLookupAccessor peerLookupAccessor = (PeerLookupAccessor)object;
        return !(this.fLookupServiceAddress != null ? !this.fLookupServiceAddress.equals(peerLookupAccessor.fLookupServiceAddress) : peerLookupAccessor.fLookupServiceAddress != null);
    }

    public int hashCode() {
        return this.fLookupServiceAddress != null ? this.fLookupServiceAddress.hashCode() : 0;
    }

    public String toString() {
        return "PeerLookupAccessor{" + this.getLookupServiceURI() + '}';
    }

    private URI getLookupServiceURI() {
        return PeerLookupService.createLookupServiceURI(this.fLookupServiceAddress.getHostName(), this.fLookupServiceAddress.getPort());
    }

    public static boolean isPeerLookupUrl(String string) {
        try {
            URI uRI = new URI(string);
            return PeerLookupService.isPeerLookupScheme(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    private static class LookupTimedOutException
    extends PeerLookupAccessorException {
        LookupTimedOutException(URI uRI) {
            super(PeerLookupAccessorErrorCode.LookupTimedOut, uRI.toString());
        }
    }

    private static class RemoteLookupServiceException
    extends PeerLookupAccessorException {
        RemoteLookupServiceException(URI uRI, AccessorException accessorException) {
            super(PeerLookupAccessorErrorCode.ExceptionFromRemoteLookupService, uRI.toString(), accessorException.getLocalizedMessage());
            this.initCause(accessorException);
        }
    }

    private static class CannotConnectToLookupServiceException
    extends PeerLookupAccessorException {
        CannotConnectToLookupServiceException(URI uRI, Throwable throwable) {
            super(PeerLookupAccessorErrorCode.CannotConnectToLookupService, uRI.toString(), uRI.getHost());
            this.initCause(throwable);
        }
    }

    private static class CannotStartPeerSessionException
    extends PeerLookupAccessorException {
        CannotStartPeerSessionException(URI uRI, Throwable throwable) {
            super(PeerLookupAccessorErrorCode.CannotStartPeerSession, uRI.toString());
            this.initCause(throwable);
        }
    }

    private static class BadLookupServiceURI
    extends PeerLookupAccessorException {
        BadLookupServiceURI(String string) {
            super(PeerLookupAccessorErrorCode.BadLookupServiceURI, string);
        }

        BadLookupServiceURI(String string, Throwable throwable) {
            super(PeerLookupAccessorErrorCode.BadLookupServiceURI, string);
            this.initCause(throwable);
        }
    }

    private static class RequiredCertificateNotProvidedException
    extends PeerLookupAccessorException {
        RequiredCertificateNotProvidedException(URI uRI, Throwable throwable) {
            super(PeerLookupAccessorErrorCode.RequiredCertificateNotProvided, uRI.toString());
            this.initCause(throwable);
        }
    }

    private static abstract class PeerLookupAccessorException
    extends AccessorException {
        private final String[] fMessageArguments;

        protected PeerLookupAccessorException(PeerLookupAccessorErrorCode peerLookupAccessorErrorCode, String ... stringArray) {
            super(peerLookupAccessorErrorCode);
            this.fMessageArguments = stringArray;
        }

        protected String[] getMessageArguments() {
            return this.fMessageArguments;
        }
    }
}

