/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.peerrmi;

import com.mathworks.toolbox.distcomp.mjs.peerrmi.ClientOutputGroupFactory;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.Log;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.ObjectRegistry;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.PeerRmiExporterProperties;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.PeerRmiInvocationHandler;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.PeerRmiRuntime;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.RemoteInterfaces;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.service.Exporter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.server.ExportException;

public final class PeerRmiExporter
implements Exporter {
    private static final String TAG = PeerRmiExporter.class.getSimpleName();
    private final PeerRmiRuntime fPeerRmiRuntime;
    private final Instance fInstance;
    private final ClientOutputGroupFactory fClientOutputGroupFactory;
    private final PeerRmiExporterProperties fProperties;
    private ObjectRegistry.ID fExportedObjectId;

    public PeerRmiExporter(PeerRmiRuntime peerRmiRuntime, Instance instance, ClientOutputGroupFactory clientOutputGroupFactory, PeerRmiExporterProperties peerRmiExporterProperties) {
        this.fPeerRmiRuntime = peerRmiRuntime;
        this.fInstance = instance;
        this.fClientOutputGroupFactory = clientOutputGroupFactory;
        this.fProperties = peerRmiExporterProperties;
    }

    @Override
    public Remote export(Remote remote) throws ExportException {
        if (this.fExportedObjectId != null) {
            throw new ExportException("An object has already been exported with this exporter");
        }
        try {
            this.fPeerRmiRuntime.startRuntime();
        }
        catch (PeerRmiRuntime.FailedToStartException failedToStartException) {
            throw new ExportException("Failed to start the Peer RMI runtime", failedToStartException);
        }
        RemoteInterfaces remoteInterfaces = new RemoteInterfaces(remote.getClass());
        Log.LOGGER.fine(TAG + ": Exporting " + remote.getClass());
        return this.export(remote, remoteInterfaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Remote export(Remote remote, RemoteInterfaces remoteInterfaces) {
        this.fExportedObjectId = this.registerObject(remote);
        Remote remote2 = null;
        try {
            PeerRmiInvocationHandler peerRmiInvocationHandler = new PeerRmiInvocationHandler(this.fExportedObjectId, remoteInterfaces.toClassArray(), this.fInstance, this.fClientOutputGroupFactory, this.fProperties.getMethodCallTimeout());
            Remote remote3 = remote2 = (Remote)Proxy.newProxyInstance(remote.getClass().getClassLoader(), remoteInterfaces.toClassArray(), (InvocationHandler)peerRmiInvocationHandler);
            return remote3;
        }
        finally {
            if (remote2 == null) {
                this.unregisterObject(this.fExportedObjectId);
            }
        }
    }

    @Override
    public boolean unexport(boolean bl) {
        Log.LOGGER.info(TAG + ": Unexporting object: " + this.fExportedObjectId);
        this.unregisterObject(this.fExportedObjectId);
        return true;
    }

    private ObjectRegistry.ID registerObject(Remote remote) {
        return this.fPeerRmiRuntime.getObjectRegistry().register(remote);
    }

    private void unregisterObject(ObjectRegistry.ID iD) {
        this.fPeerRmiRuntime.getObjectRegistry().unregister(iD);
    }

    @Override
    public boolean isExportSecure() {
        return this.fPeerRmiRuntime.isSecure();
    }

    @Override
    public int getExportPort() {
        return 0;
    }
}

