/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mwlogin;

import com.mathworks.toolbox.distcomp.mwlogin.AuthenticationRequiredDialog;
import com.mathworks.toolbox.distcomp.mwlogin.BlockableValidationStrategy;
import com.mathworks.toolbox.distcomp.mwlogin.EmptyUserTokenPair;
import com.mathworks.toolbox.distcomp.mwlogin.Expirable;
import com.mathworks.toolbox.distcomp.mwlogin.Log;
import com.mathworks.toolbox.distcomp.mwlogin.LoginErrorCode;
import com.mathworks.toolbox.distcomp.mwlogin.MJSValidationStrategy;
import com.mathworks.toolbox.distcomp.mwlogin.SimpleExpirable;
import com.mathworks.toolbox.distcomp.mwlogin.UserTokenPair;
import com.mathworks.toolbox.distcomp.mwlogin.ValidationFailedException;
import com.mathworks.widgets.login.CompletionStatus;
import com.mathworks.widgets.login.FailureType;
import com.mathworks.widgets.login.ValidationConsumer;
import com.mathworks.widgets.login.ValidationStrategy;
import com.mathworks.widgets.login.ValidationWorkFlow;
import com.mathworks.widgets.login.WorkFlowReturn;
import java.awt.Component;
import java.util.concurrent.Callable;
import java.util.logging.Level;

public class LoginTokenValidation {
    private BlockableValidationStrategy fValidationStrategy = null;
    private ValidationWorkFlow fValidationWorkFlow = null;
    private Callable<Integer> fShowAuthenticationRequiredCallback = null;
    private static Expirable<UserTokenPair> sUserTokenPair = new EmptyUserTokenPair();
    private static ValidationFailedException sStashedException = null;

    public LoginTokenValidation(boolean bl) {
        MJSValidationStrategy mJSValidationStrategy = new MJSValidationStrategy(bl);
        this.initialize(bl, mJSValidationStrategy);
    }

    public LoginTokenValidation(boolean bl, final ValidationConsumer validationConsumer) {
        MJSValidationStrategy mJSValidationStrategy = new MJSValidationStrategy(bl){

            public ValidationConsumer getValidationConsumer() {
                Log.LOGGER.log(Level.FINEST, "Using the provided login dialog consumer: " + validationConsumer);
                return validationConsumer;
            }
        };
        this.initialize(bl, mJSValidationStrategy);
    }

    private void initialize(boolean bl, MJSValidationStrategy mJSValidationStrategy) {
        if (bl) {
            LoginTokenValidation.clearPersistedToken();
        }
        this.fValidationStrategy = mJSValidationStrategy;
        this.fValidationWorkFlow = new ValidationWorkFlow((ValidationStrategy)this.fValidationStrategy);
        this.fShowAuthenticationRequiredCallback = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (!LoginTokenValidation.this.fValidationStrategy.getLoginPersistenceStrategy().readLoginToken().isEmpty()) {
                    return 0;
                }
                Component component = null;
                if (LoginTokenValidation.this.fValidationStrategy.getValidationConsumer() != null) {
                    component = LoginTokenValidation.this.fValidationStrategy.getValidationConsumer().getInvoker();
                }
                return AuthenticationRequiredDialog.showDialog(component);
            }
        };
    }

    public LoginTokenValidation(BlockableValidationStrategy blockableValidationStrategy, ValidationWorkFlow validationWorkFlow) {
        this.fValidationStrategy = blockableValidationStrategy;
        this.fValidationWorkFlow = validationWorkFlow;
        this.fShowAuthenticationRequiredCallback = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return 0;
            }
        };
    }

    public UserTokenPair validate() throws ValidationFailedException {
        LoginTokenValidation.clearStashedException();
        UserTokenPair userTokenPair = sUserTokenPair.getValue();
        if (userTokenPair != null) {
            return userTokenPair;
        }
        Integer n = null;
        try {
            n = this.fShowAuthenticationRequiredCallback.call();
        }
        catch (Exception exception) {
            Log.LOGGER.log(Level.FINEST, "Unexpected exception from calling show authentication dialog.", exception);
        }
        if (n != null && n == 1) {
            return null;
        }
        this.fValidationWorkFlow.startWorkFlow();
        try {
            this.fValidationStrategy.awaitComplete();
        }
        catch (InterruptedException interruptedException) {
            this.fValidationWorkFlow.cancelWorkFlow();
            ValidationDidNotCompleteException validationDidNotCompleteException = new ValidationDidNotCompleteException();
            LoginTokenValidation.stashFirstException(validationDidNotCompleteException);
            throw validationDidNotCompleteException;
        }
        WorkFlowReturn workFlowReturn = this.fValidationStrategy.getWorkFlowReturn();
        CompletionStatus completionStatus = workFlowReturn.getCompletionStatus();
        if (!completionStatus.equals((Object)CompletionStatus.SUCCEEDED)) {
            if (completionStatus.equals((Object)CompletionStatus.CANCELLED)) {
                return null;
            }
            FailureType failureType = workFlowReturn.getFailureType();
            switch (failureType) {
                case AUTHENTICATION_FAILURE: {
                    return null;
                }
                case NOT_SUPPORTED: {
                    LoginNotSupportedException loginNotSupportedException = new LoginNotSupportedException();
                    LoginTokenValidation.stashFirstException(loginNotSupportedException);
                    Log.LOGGER.log(Level.WARNING, "Login attempted in unsupported environment", loginNotSupportedException);
                    throw loginNotSupportedException;
                }
            }
            UnknownFailureTypeException unknownFailureTypeException = new UnknownFailureTypeException(completionStatus, failureType);
            LoginTokenValidation.stashFirstException(unknownFailureTypeException);
            Log.LOGGER.log(Level.SEVERE, "An unknown failure type was encountered", unknownFailureTypeException);
            throw unknownFailureTypeException;
        }
        String string = workFlowReturn.getLoginResponse().getToken();
        String string2 = workFlowReturn.getLoginResponse().getMwaUserName();
        userTokenPair = new UserTokenPair(string2, string);
        sUserTokenPair = new SimpleExpirable<UserTokenPair>(userTokenPair);
        return userTokenPair;
    }

    public static void clearPersistedToken() {
        sUserTokenPair.expireNow();
    }

    private static void stashFirstException(ValidationFailedException validationFailedException) {
        sStashedException = validationFailedException;
    }

    private static void clearStashedException() {
        sStashedException = null;
    }

    public static ValidationFailedException getStashedException() {
        return sStashedException;
    }

    private static class UnknownFailureTypeException
    extends ValidationFailedException {
        UnknownFailureTypeException(CompletionStatus completionStatus, FailureType failureType) {
            super(LoginErrorCode.UnknownFailureType, completionStatus.name(), failureType.name());
        }
    }

    private static class LoginNotSupportedException
    extends ValidationFailedException {
        LoginNotSupportedException() {
            super(LoginErrorCode.LoginNotSupported, new String[0]);
        }
    }

    private static class ValidationDidNotCompleteException
    extends ValidationFailedException {
        ValidationDidNotCompleteException() {
            super(LoginErrorCode.ValidationDidNotComplete, new String[0]);
        }
    }
}

