/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButtonMenuItem;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MPopup;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.toolbox.distcomp.parallelui.Actions;
import com.mathworks.toolbox.distcomp.parallelui.CommandHistoryTable;
import com.mathworks.toolbox.distcomp.parallelui.CommandInputPane;
import com.mathworks.toolbox.distcomp.parallelui.DesktopFindClient;
import com.mathworks.toolbox.distcomp.parallelui.IntSet;
import com.mathworks.toolbox.distcomp.parallelui.LabsState;
import com.mathworks.toolbox.distcomp.parallelui.OutputCollection;
import com.mathworks.toolbox.distcomp.parallelui.OutputComponent;
import com.mathworks.toolbox.distcomp.parallelui.OutputOrganizer;
import com.mathworks.toolbox.distcomp.parallelui.OutputWindow;
import com.mathworks.toolbox.distcomp.parallelui.ParallelUI;
import com.mathworks.toolbox.distcomp.parallelui.Prompt;
import com.mathworks.toolbox.distcomp.parallelui.PromptPad;
import com.mathworks.toolbox.distcomp.parallelui.PromptPanel;
import com.mathworks.toolbox.distcomp.parallelui.SerialMatlab;
import com.mathworks.toolbox.distcomp.parallelui.SingleEdgeBorder;
import com.mathworks.toolbox.distcomp.parallelui.Utilities;
import com.mathworks.toolbox.distcomp.pmode.Labs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.action.AbstractFindAction;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTMenuBoundary;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTMenuOmission;
import com.mathworks.widgets.desk.DTRecoverable;
import com.mathworks.widgets.desk.DTUnableToOpenException;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.find.FindClientInterface;
import com.mathworks.widgets.find.FindDialog;
import com.mathworks.widgets.find.FindEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Formatter;
import java.util.Locale;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.JTextComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParallelCommandWindow
extends DTClientBase
implements DTRecoverable,
Actions.Contributor {
    private Labs fLabs;
    private OutputCollection fOutputCollection;
    private Prompt fPrompt;
    private Actions fActions = new Actions();
    private OutputOrganizer fOutputOrganizer;
    private OutputWindow fOutputWindow;
    private OutputComponent fOutputComponent;
    private CommandHistoryTable fHistoryTable;
    private MJScrollPane fHistoryScroller;
    private PromptPanel fPromptPanel;
    private CommandInputPane fCommandPane;
    private MJScrollPane fCommandScroller;
    private PromptPad fPromptPad;
    private InputPanel fInputPanel;
    private MJSplitPane fSplitPane;
    private HistoryPosition fHistoryPosition;
    private EnumMap<HistoryPosition, HistoryPositionAction> fHistoryPositionActionMap = new EnumMap(HistoryPosition.class);
    private MJAbstractAction fToggleCommandsAction = new ToggleCommandsAction();
    private Action fFindAction;
    private FindClient fFindClient;
    private PrefListener fColorListener;
    private FontListener fFontListener;
    public static final String TITLE = "Parallel Command Window";
    public static final String ALT_TITLE = "Alt Command Window";
    private static final double DEFAULT_HISTORY_FRACTION = 0.35;
    private static final HistoryPosition DEFAULT_HISTORY_POSITION = HistoryPosition.LEFT;
    private static final String INTERRUPT_ACTION_KEY = "interrupt-labs";
    private static ParallelCommandWindow sInstance = null;
    private static final String HISTORY_POSITION_ATTRIBUTE = "HistoryPosition";
    private static final String SPLIT_POSITION_ATTRIBUTE = "SplitPosition";
    private static final String LAB_COUNT_ATTRIBUTE = "NumLabs";
    private static final String SHOW_COMMANDS_ATTRIBUTE = "ShowCommands";

    private ParallelCommandWindow(Labs labs, LabsState labsState, OutputCollection outputCollection) {
        Object object;
        this.fHistoryPosition = null;
        this.fSplitPane = null;
        this.fLabs = labs;
        this.fOutputCollection = outputCollection;
        this.fPrompt = new Prompt(labs, labsState);
        this.setName("ParallelCommandWindow");
        this.setLayout(new BorderLayout());
        this.fActions.registerContribution(Actions.Type.CLEAR_ALL_OUTPUT, this);
        this.fActions.registerContribution(Actions.Type.COMMANDS_IN_OUTPUT, this);
        if (this.fLabs.getNumLabs() > 1) {
            this.fOutputOrganizer = new OutputOrganizer(labs, outputCollection, this.fActions);
            this.fOutputComponent = this.fOutputOrganizer;
        } else {
            this.fOutputOrganizer = null;
            this.add(this.createToolBar(), "North");
            this.fOutputWindow = new OutputWindow(labs, outputCollection, this.fActions);
            this.fOutputWindow.setTitleBarVisible(false);
            this.fOutputWindow.setSources(new IntSet(1));
            this.fOutputComponent = this.fOutputWindow;
        }
        this.fToggleCommandsAction.setSelected(this.fOutputComponent.isShowingCommandText());
        this.fHistoryTable = new CommandHistoryTable(this, outputCollection, this.fOutputComponent, this.fActions, this.fLabs.getNumLabs(), false);
        this.fPromptPanel = new PromptPanel(labs, this.fPrompt, this.fHistoryTable);
        this.fCommandPane = new CommandInputPane(this, this.fHistoryTable, this.fActions);
        this.fHistoryScroller = new MJScrollPane((Component)((Object)this.fHistoryTable));
        this.fHistoryScroller.anchorToBottom();
        this.fHistoryScroller.getViewport().addMouseListener(this.fHistoryTable.getContextMouseListener());
        this.fHistoryScroller.setHorizontalScrollBarPolicy(31);
        this.fCommandScroller = new MJScrollPane((Component)((Object)this.fCommandPane));
        this.fCommandScroller.setHorizontalScrollBarPolicy(31);
        this.fCommandScroller.setBorder(BorderFactory.createEmptyBorder());
        this.fInputPanel = new InputPanel();
        this.fInputPanel.add((Component)this.fHistoryScroller);
        this.fInputPanel.add((Component)((Object)this.fPromptPanel));
        this.fInputPanel.add((Component)this.fCommandScroller);
        if (ParallelUI.isPromptPadEnabled()) {
            this.fPromptPad = new PromptPad(this.fLabs);
            object = this.fPromptPad.getToolBar();
            ((JComponent)object).setVisible(false);
            this.fInputPanel.add((Component)object);
        }
        this.fHistoryTable.getModel().addTableModelListener(this.fInputPanel);
        this.fCommandPane.getDocument().addDocumentListener(this.fInputPanel);
        this.fInputPanel.addMouseListener(this.fHistoryTable.getContextMouseListener());
        object = new HistoryPopupController();
        this.fHistoryTable.getSelectionModel().addListSelectionListener((ListSelectionListener)object);
        this.fCommandPane.addMouseListener((MouseListener)object);
        this.setHistoryPosition(DEFAULT_HISTORY_POSITION, 0.35);
        this.setTitle(ParallelUI.sIsSerialMatlab ? ALT_TITLE : TITLE);
        this.setIsGuest(true);
        this.setPermitCloseUponLayout(false);
        this.setMenuBar(this.createMenuBar());
        this.setStatusBar(DTClientProperty.NULL_STATUS_BAR);
        this.setWantTopSeparator(true);
        this.fColorListener = new PrefListener(){

            public void prefChanged(PrefEvent prefEvent) {
                if (prefEvent.getPrefKey().equals("ColorsBackground")) {
                    ParallelCommandWindow.this.updateBackground();
                } else if (prefEvent.getPrefKey().equals("ColorsText")) {
                    ParallelCommandWindow.this.updateForeground();
                } else if (prefEvent.getPrefKey().equals("Colors_M_")) {
                    ParallelCommandWindow.this.fHistoryTable.repaint();
                    ParallelCommandWindow.this.fOutputCollection.refreshAllDocuments();
                }
            }
        };
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)this.fColorListener);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)this.fColorListener);
        ColorPrefs.addColorListener((String)"Colors_M_", (PrefListener)this.fColorListener);
        this.updateBackground();
        this.updateForeground();
        this.fFontListener = new FontListener(){

            public void fontChanged(Font font) {
                ParallelCommandWindow.this.updateFont();
            }
        };
        FontPrefs.addCodeFontListener((FontListener)this.fFontListener);
        this.updateFont();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!(mouseEvent.getComponent() instanceof JTextField)) {
                    ParallelCommandWindow.this.fCommandPane.requestFocusInWindow();
                }
            }
        };
        this.recursiveAddMouseListener((Component)((Object)this.fInputPanel), mouseAdapter);
        this.fHistoryTable.addMouseListener(mouseAdapter);
        this.fOutputComponent.setKeyRedirector(new KeyRedirector());
        if (PlatformInfo.isWindows()) {
            this.fCommandPane.addMouseWheelListener(new WheelRedirector());
        }
        InputMap inputMap = new InputMap();
        inputMap.put(KeyStroke.getKeyStroke(67, 2), INTERRUPT_ACTION_KEY);
        if (PlatformInfo.isMacintosh()) {
            inputMap.put(KeyStroke.getKeyStroke(46, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK), INTERRUPT_ACTION_KEY);
        } else {
            inputMap.put(KeyStroke.getKeyStroke(3, 2), INTERRUPT_ACTION_KEY);
        }
        this.setInputMap(1, inputMap);
        this.getActionMap().put(INTERRUPT_ACTION_KEY, (Action)((Object)new InterruptLabsAction()));
    }

    public ParallelCommandWindow() throws DTUnableToOpenException {
        throw new DTUnableToOpenException("The Parallel Command Window can't be reopened by the desktop");
    }

    static ParallelCommandWindow getInstance() {
        return sInstance;
    }

    static ParallelCommandWindow createInstance(Labs labs, LabsState labsState, OutputCollection outputCollection) {
        if (sInstance != null) {
            throw new IllegalStateException("Cannot create second instance of ParallelCommandWindow");
        }
        sInstance = new ParallelCommandWindow(labs, labsState, outputCollection);
        return sInstance;
    }

    static void cleanupInstance() {
        if (sInstance != null) {
            sInstance.cleanup();
            sInstance = null;
        }
    }

    private void cleanup() {
        ColorPrefs.removeColorListener((String)"ColorsText", (PrefListener)this.fColorListener);
        ColorPrefs.removeColorListener((String)"ColorsBackground", (PrefListener)this.fColorListener);
        ColorPrefs.removeColorListener((String)"Colors_M_", (PrefListener)this.fColorListener);
        FontPrefs.removeCodeFontListener((FontListener)this.fFontListener);
        this.fCommandPane.cleanup();
    }

    protected void setParentDesktop(Desktop desktop) {
        super.setParentDesktop(desktop);
    }

    void suspend() {
        this.fCommandPane.suspend();
        this.fHistoryTable.suspendEvaluation();
    }

    void resume() {
        this.fCommandPane.resume();
        this.fHistoryTable.resumeEvaluation();
    }

    void evaluate(String[] stringArray) {
        IntSet intSet = Utilities.allLabs(this.fLabs);
        String string = this.fPrompt.toString();
        if (stringArray.length == 1 && stringArray[0].equals("clc") && this.fPrompt.getAvailableTargets().equals(this.fPrompt.getTargetLabs())) {
            this.fOutputCollection.addCommand(stringArray[0], string, intSet);
            this.fHistoryTable.setLastEvaluateCount(1);
            this.fOutputCollection.clearSession();
            return;
        }
        if (stringArray.length == 1 && !(this.fLabs instanceof SerialMatlab) && (stringArray[0].equals("exit") || stringArray[0].equals("quit") || stringArray[0].startsWith("quit "))) {
            stringArray[0] = "pmode exit";
        }
        ParallelUI.setBusy(intSet);
        int n = 0;
        if (stringArray.length == 1) {
            String string2 = stringArray[0].trim();
            if (string2.length() == 0) {
                string2 = "\n";
            } else {
                ++n;
            }
            this.fOutputCollection.addCommand(string2, string, intSet);
            this.fLabs.eval(string2, ParallelUI.getObserver());
        } else {
            String[] stringArray2;
            int n2 = stringArray.length;
            ArrayList<String[]> arrayList = new ArrayList<String[]>(stringArray.length);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n2; ++i) {
                stringArray2 = stringArray[i].trim();
                if (stringArray2.length() <= 0) continue;
                arrayList.add(stringArray2);
                stringBuilder.append((String)stringArray2);
                if (i >= n2 - 1) continue;
                stringBuilder.append('\n');
            }
            String string3 = stringBuilder.toString();
            stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
            n = stringArray2.length;
            this.fOutputCollection.addCommands(stringArray2, string3, string, intSet);
            this.fLabs.eval(string3, ParallelUI.getObserver());
        }
        this.fHistoryTable.setLastEvaluateCount(n);
        this.fCommandPane.clearCommandText();
    }

    @Override
    public Action getAction(Actions.Type type) {
        switch (type) {
            case CLEAR_ALL_OUTPUT: {
                return new ClearAllOutputAction();
            }
            case COMMANDS_IN_OUTPUT: {
                return this.fToggleCommandsAction;
            }
        }
        return null;
    }

    @Override
    public Component getActionFocusComponent() {
        return null;
    }

    public void saveState(Document document, Element element) {
        element.setAttribute(HISTORY_POSITION_ATTRIBUTE, this.fHistoryPosition.toString());
        float f = this.getHistoryFraction();
        Formatter formatter = new Formatter(Locale.US);
        formatter.format("%6.4f", Float.valueOf(f));
        element.setAttribute(SPLIT_POSITION_ATTRIBUTE, formatter.toString());
        if (this.fOutputComponent != null) {
            element.setAttribute(SHOW_COMMANDS_ATTRIBUTE, Boolean.toString(this.fOutputComponent.isShowingCommandText()));
        }
        if (this.fOutputOrganizer != null) {
            element.setAttribute(LAB_COUNT_ATTRIBUTE, Integer.toString(this.fLabs.getNumLabs()));
            this.fOutputOrganizer.saveState(document, element);
        }
    }

    public void restoreState(SimpleElement simpleElement) {
        try {
            int n = 1;
            String string = simpleElement.getAttribute(LAB_COUNT_ATTRIBUTE);
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid NumLabs: " + string);
                }
            }
            if (this.fOutputComponent != null) {
                boolean bl = this.fOutputComponent.isShowingCommandText();
                string = simpleElement.getAttribute(SHOW_COMMANDS_ATTRIBUTE);
                try {
                    bl = Boolean.valueOf(string);
                }
                catch (Exception exception) {
                    throw new DataFormatException("Invalid ShowCommands: " + string);
                }
                this.fOutputComponent.setShowCommandText(bl);
                this.fToggleCommandsAction.setSelected(bl);
            }
            if (this.fOutputOrganizer != null && n == this.fLabs.getNumLabs()) {
                this.fOutputOrganizer.restoreState(simpleElement);
            }
            string = simpleElement.getAttribute(HISTORY_POSITION_ATTRIBUTE);
            HistoryPosition historyPosition = DEFAULT_HISTORY_POSITION;
            if (string != null) {
                try {
                    historyPosition = HistoryPosition.valueOf(string.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new DataFormatException("Invalid HistoryPosition: " + string);
                }
            }
            string = simpleElement.getAttribute(SPLIT_POSITION_ATTRIBUTE);
            float f = 0.35f;
            if (string != null) {
                try {
                    f = Float.parseFloat(string);
                }
                catch (Exception exception) {
                    throw new DataFormatException("Invalid SplitPosition: " + string);
                }
                if (f < 0.0f || f > 1.0f) {
                    throw new DataFormatException("Invalid SplitPosition: " + string);
                }
            }
            this.setHistoryPosition(historyPosition, f);
        }
        catch (DataFormatException dataFormatException) {
            System.out.println("Unable to restore Parallel Command Window state due to:");
            System.out.println(dataFormatException.getMessage());
        }
    }

    private void setHistoryPosition(HistoryPosition historyPosition, double d) {
        if (historyPosition != this.fHistoryPosition) {
            Object object;
            BasicSplitPaneDivider basicSplitPaneDivider;
            Object object2;
            boolean bl;
            boolean bl2 = bl = historyPosition == HistoryPosition.LEFT || historyPosition == HistoryPosition.RIGHT || historyPosition == HistoryPosition.ABOVE;
            if (bl && this.fSplitPane == null) {
                this.fSplitPane = new MJSplitPane(){

                    public void setDividerLocation(int n) {
                        super.setDividerLocation(n);
                        double d = this.getResizeWeight();
                        if (d < 0.05) {
                            this.setResizeWeight(0.0);
                        } else if (d > 0.95) {
                            this.setResizeWeight(1.0);
                        }
                    }
                };
                this.fSplitPane.setProportionalResizeEnabled(true);
                this.fSplitPane.setBorder(BorderFactory.createEmptyBorder());
                object2 = this.fSplitPane.getUI();
                if (object2 instanceof BasicSplitPaneUI) {
                    basicSplitPaneDivider = ((BasicSplitPaneUI)object2).getDivider();
                    basicSplitPaneDivider.setBorder(BorderFactory.createEmptyBorder());
                }
                if (this.fSplitPane.getParent() != this) {
                    this.add((Component)this.fSplitPane, "Center");
                }
            } else if (this.fSplitPane != null) {
                this.fSplitPane.setTopComponent(null);
                this.fSplitPane.setBottomComponent(null);
                if (!bl) {
                    this.remove((Component)this.fSplitPane);
                    this.fSplitPane = null;
                }
            }
            this.fInputPanel.setBorder(BorderFactory.createEmptyBorder());
            object2 = this.fOutputComponent.getComponent();
            if (object2 instanceof OutputWindow) {
                ((JComponent)object2).setBorder(new SingleEdgeBorder(3));
            } else {
                ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder());
            }
            this.fHistoryScroller.setBorder(BorderFactory.createEmptyBorder());
            this.fPromptPanel.setAlignWithHistory(false);
            basicSplitPaneDivider = null;
            if (historyPosition == HistoryPosition.LEFT || historyPosition == HistoryPosition.RIGHT) {
                basicSplitPaneDivider = new MJPanel((LayoutManager)new BorderLayout());
                basicSplitPaneDivider.add((Component)object2, "Center");
                basicSplitPaneDivider.add((Component)((Object)this.fInputPanel), "South");
                this.fSplitPane.setOrientation(1);
            }
            switch (historyPosition) {
                case LEFT: {
                    this.fSplitPane.setLeftComponent((Component)this.fHistoryScroller);
                    this.fSplitPane.setRightComponent((Component)basicSplitPaneDivider);
                    if (d >= 0.0) {
                        this.fSplitPane.setDividerLocation(d);
                    }
                    this.fHistoryScroller.setBorder((Border)new SingleEdgeBorder(4));
                    ((JComponent)((Object)basicSplitPaneDivider)).setBorder(new SingleEdgeBorder(2));
                    break;
                }
                case RIGHT: {
                    this.fSplitPane.setLeftComponent((Component)basicSplitPaneDivider);
                    this.fSplitPane.setRightComponent((Component)this.fHistoryScroller);
                    if (d >= 0.0) {
                        this.fSplitPane.setDividerLocation(1.0 - d);
                    }
                    ((JComponent)((Object)basicSplitPaneDivider)).setBorder(new SingleEdgeBorder(4));
                    this.fHistoryScroller.setBorder((Border)new SingleEdgeBorder(2));
                    break;
                }
                case ABOVE: {
                    this.fInputPanel.add((Component)this.fHistoryScroller);
                    this.fSplitPane.setOrientation(0);
                    this.fSplitPane.setTopComponent((Component)object2);
                    this.fSplitPane.setBottomComponent((Component)((Object)this.fInputPanel));
                    if (d >= 0.0) {
                        this.fSplitPane.setDividerLocation(1.0 - d);
                    }
                    this.fInputPanel.setBorder(new SingleEdgeBorder(1));
                    this.fHistoryScroller.setBorder((Border)new SingleEdgeBorder(3));
                    this.fPromptPanel.setAlignWithHistory(true);
                    break;
                }
                case POPUP: {
                    object = UIManager.getBorder("PopupMenu.border");
                    if (object != null) {
                        this.fHistoryScroller.setBorder((Border)object);
                    }
                }
                case HIDDEN: {
                    this.add((Component)object2, "Center");
                    this.add((Component)((Object)this.fInputPanel), "South");
                    if (this.fHistoryScroller.getParent() == null) break;
                    this.fHistoryScroller.getParent().remove((Component)this.fHistoryScroller);
                }
            }
            this.fHistoryPosition = historyPosition;
            object = this.fHistoryPositionActionMap.values().iterator();
            while (object.hasNext()) {
                HistoryPositionAction historyPositionAction;
                historyPositionAction.setSelected((historyPositionAction = (HistoryPositionAction)((Object)object.next())).iHistoryPosition == historyPosition);
            }
        }
    }

    private float getHistoryFraction() {
        if (this.fSplitPane == null) {
            return 0.0f;
        }
        int n = this.fSplitPane.getOrientation() == 0 ? this.fSplitPane.getHeight() : this.fSplitPane.getWidth();
        float f = 0.5f;
        if (n != 0) {
            f = ((float)this.fSplitPane.getDividerLocation() + 0.5f) / (float)n;
        }
        if (this.fHistoryPosition != HistoryPosition.LEFT) {
            f = 1.0f - f;
        }
        return f;
    }

    private void setShowCommandText(boolean bl) {
        this.fToggleCommandsAction.setSelected(bl);
        this.fToggleCommandsAction.setTip(ParallelUI.sRes.getString(bl ? "tip.HideCommandsInOutputArea" : "tip.ShowCommandsInOutputArea"));
        this.fOutputComponent.setShowCommandText(bl);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.fOutputComponent != null) {
            this.fOutputComponent.getComponent().setBackground(color);
            this.fHistoryTable.setBackground(color);
            this.fHistoryScroller.getViewport().setBackground(color);
            this.fInputPanel.setBackground(color);
            this.fCommandPane.setBackgroundColor(color, false);
            this.fPromptPanel.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.fOutputComponent != null) {
            this.fOutputComponent.getComponent().setForeground(color);
            this.fHistoryTable.setForeground(color);
            this.fCommandPane.setTextColor(color, false);
            this.fPromptPanel.setForeground(color);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fOutputComponent != null) {
            this.fOutputComponent.getComponent().setFont(font);
            this.fHistoryTable.setFont(font);
            this.fCommandPane.setFont(font, false);
            this.fPromptPanel.setFont(font);
        }
    }

    public void requestFocus() {
        this.fCommandPane.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.fCommandPane.requestFocusInWindow();
    }

    private void updateBackground() {
        this.setBackground(ColorPrefs.getBackgroundColor());
    }

    private void updateForeground() {
        this.setForeground(ColorPrefs.getTextColor());
    }

    private void updateFont() {
        this.setFont(FontPrefs.getCodeFont());
    }

    private void recursiveAddMouseListener(Component component, MouseListener mouseListener) {
        component.addMouseListener(mouseListener);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.recursiveAddMouseListener(container.getComponent(i), mouseListener);
            }
        }
    }

    private JMenuBar createMenuBar() {
        MJMenuBar mJMenuBar = new MJMenuBar();
        MJMenu mJMenu = new MJMenu();
        DTMenuMergeTag.EDIT.setTag((JMenuItem)mJMenu);
        mJMenu.add(this.fActions.getAction(Actions.Type.UNDO));
        mJMenu.add(this.fActions.getAction(Actions.Type.CUT));
        mJMenu.add(this.fActions.getAction(Actions.Type.COPY));
        mJMenu.add(this.fActions.getAction(Actions.Type.PASTE));
        mJMenu.add(this.fActions.getAction(Actions.Type.SELECT_ALL));
        mJMenu.add(this.fActions.getAction(Actions.Type.DELETE));
        Action action = this.fActions.getAction(Actions.Type.CLEAR_ALL_OUTPUT);
        MLMenuMergeTag.CLEAR_COMMAND.setTag(action);
        mJMenu.add(action);
        Action action2 = this.fActions.getAction(Actions.Type.CLEAR_HISTORY);
        MLMenuMergeTag.CLEAR_HISTORY.setTag(action2);
        mJMenu.add(action2);
        mJMenu.add((JMenuItem)new DTMenuOmission((DTMenuMergeTag)MLMenuMergeTag.CLEAR_WORKSPACE));
        mJMenuBar.add((JMenu)new DTMenuOmission((DTMenuMergeTag)MLMenuMergeTag.DEBUG));
        mJMenuBar.add((JMenu)mJMenu);
        if (!PlatformInfo.isMacintosh() || !"true".equalsIgnoreCase(System.getProperty("apple.laf.useScreenMenuBar"))) {
            MJMenu mJMenu2;
            mJMenu = new MJMenu();
            DTMenuMergeTag.WINDOW.setTag((JMenuItem)mJMenu);
            mJMenu.add((JMenuItem)new DTMenuBoundary(DTMenuMergeTag.START_OF_MENU));
            if (this.fOutputOrganizer != null) {
                Action object = this.fActions.getAction(Actions.Type.TILE_OUTPUT);
                mJMenu2 = new MJMenu(object);
                mJMenu2.addMenuListener((MenuListener)((Object)object));
                mJMenu.add((JMenuItem)mJMenu2);
                Action action3 = this.fActions.getAction(Actions.Type.TAB_OUTPUT);
                mJMenu2 = new MJMenu(action3);
                mJMenu2.addMenuListener((MenuListener)((Object)action3));
                mJMenu.add((JMenuItem)mJMenu2);
                mJMenu.add(this.fActions.getAction(Actions.Type.SINGLE_OUTPUT));
            }
            mJMenu2 = new MJMenu(ParallelUI.sRes.getString("menu.HistoryPosition"));
            for (HistoryPosition historyPosition : HistoryPosition.values()) {
                MJRadioButtonMenuItem mJRadioButtonMenuItem = new MJRadioButtonMenuItem(this.getHistoryPositionAction(historyPosition));
                mJMenu2.add((JMenuItem)mJRadioButtonMenuItem);
            }
            mJMenu.add((JMenuItem)mJMenu2);
            mJMenu.addSeparator();
            mJMenuBar.add((JMenu)mJMenu);
        }
        return mJMenuBar;
    }

    private JToolBar createToolBar() {
        MJToolBar mJToolBar = new MJToolBar();
        mJToolBar.setFloatable(false);
        mJToolBar.addToggle(this.fActions.getAction(Actions.Type.COMMANDS_IN_OUTPUT));
        mJToolBar.add(this.fActions.getAction(Actions.Type.CLEAR_ALL_OUTPUT));
        return mJToolBar;
    }

    private Action getHistoryPositionAction(HistoryPosition historyPosition) {
        HistoryPositionAction historyPositionAction = this.fHistoryPositionActionMap.get((Object)historyPosition);
        if (historyPositionAction == null) {
            historyPositionAction = new HistoryPositionAction(historyPosition);
            this.fHistoryPositionActionMap.put(historyPosition, historyPositionAction);
        }
        return historyPositionAction;
    }

    private class KeyRedirector
    implements KeyListener {
        private boolean iForwardedLastPress;

        private KeyRedirector() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.iForwardedLastPress = false;
            int n = keyEvent.getKeyCode();
            if ((keyEvent.getModifiers() & 0xFFFFFFFE) == 0 && !MJUtilities.isModifierOnly((int)n)) {
                boolean bl;
                boolean bl2 = bl = n == 127 || n == 8 || n == 10 || n == 27 || n == 9 || n == 155;
                if (!bl && keyEvent.getComponent() instanceof JComponent) {
                    InputMap inputMap = ((JComponent)keyEvent.getComponent()).getInputMap(0);
                    boolean bl3 = bl = inputMap.get(KeyStroke.getKeyStrokeForEvent(keyEvent)) == null;
                }
                if (bl) {
                    this.forwardEvent(keyEvent);
                    ParallelCommandWindow.this.fCommandPane.requestFocusInWindow();
                    this.iForwardedLastPress = true;
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.iForwardedLastPress) {
                this.forwardEvent(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this.iForwardedLastPress) {
                this.forwardEvent(keyEvent);
            }
        }

        void forwardEvent(KeyEvent keyEvent) {
            ParallelCommandWindow.this.fCommandPane.dispatchEvent(new KeyEvent((Component)((Object)ParallelCommandWindow.this.fCommandPane), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation()));
        }
    }

    private class WheelRedirector
    implements MouseWheelListener {
        private WheelRedirector() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!mouseWheelEvent.isControlDown()) {
                Component component = mouseWheelEvent.getComponent();
                Point point = SwingUtilities.convertPoint(component, mouseWheelEvent.getX(), mouseWheelEvent.getY(), (Component)((Object)ParallelCommandWindow.this.fHistoryTable));
                MouseWheelEvent mouseWheelEvent2 = new MouseWheelEvent((Component)((Object)ParallelCommandWindow.this.fHistoryTable), 507, mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
                ParallelCommandWindow.this.fHistoryTable.dispatchEvent(mouseWheelEvent2);
                mouseWheelEvent.consume();
            }
        }
    }

    private class HistoryPopupController
    extends MouseAdapter
    implements ListSelectionListener {
        private MPopup iPopup;

        private HistoryPopupController() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ParallelCommandWindow.this.fHistoryPosition == HistoryPosition.POPUP) {
                boolean bl;
                boolean bl2 = bl = ParallelCommandWindow.this.fHistoryTable.getSelectedRowCount() > 0;
                if (bl && this.iPopup == null) {
                    Point point = new Point();
                    point.y -= ((ParallelCommandWindow)ParallelCommandWindow.this).fHistoryScroller.getPreferredSize().height;
                    SwingUtilities.convertPointToScreen(point, (Component)((Object)ParallelCommandWindow.this.fPromptPanel));
                    this.iPopup = MPopup.getPopup((Component)((Object)ParallelCommandWindow.this.fPromptPanel), (Component)ParallelCommandWindow.this.fHistoryScroller, (int)point.x, (int)point.y);
                    this.iPopup.show();
                } else if (!bl && this.iPopup != null) {
                    this.iPopup.hide();
                    this.iPopup = null;
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (ParallelCommandWindow.this.fHistoryPosition == HistoryPosition.POPUP && this.iPopup != null && mouseEvent.getSource() == ParallelCommandWindow.this.fCommandPane) {
                this.iPopup.hide();
                this.iPopup = null;
            }
        }
    }

    private class InputPanel
    extends MJPanel
    implements TableModelListener,
    DocumentListener {
        private int iCommandLineCount;

        InputPanel() {
            this.setLayout(null);
        }

        public Dimension getMinimumSize() {
            Dimension dimension = ParallelCommandWindow.this.fPromptPanel.getPreferredSize();
            dimension.height += 2;
            return dimension;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = ParallelCommandWindow.this.fPromptPanel.getPreferredSize();
            Dimension dimension2 = ParallelCommandWindow.this.fCommandPane.getPreferredSize();
            if (dimension.height > dimension2.height) {
                dimension2.height = dimension.height;
            }
            if (ParallelCommandWindow.this.fPromptPad != null && ParallelCommandWindow.this.fPromptPad.getToolBar().isVisible()) {
                dimension2.height += ((ParallelCommandWindow)ParallelCommandWindow.this).fPromptPad.getToolBar().getPreferredSize().height;
            }
            dimension2.height += 2;
            return dimension2;
        }

        public void doLayout() {
            int n;
            Serializable serializable;
            Insets insets = this.getInsets();
            int n2 = this.getWidth() - insets.left - insets.right;
            int n3 = this.getHeight() - insets.top - insets.bottom;
            int n4 = ((ParallelCommandWindow)ParallelCommandWindow.this).fCommandPane.getPreferredSize().height;
            Dimension dimension = ParallelCommandWindow.this.fPromptPanel.getPreferredSize();
            if (n4 < dimension.height) {
                n4 = dimension.height;
            }
            if (n4 > n3) {
                n4 = n3;
            }
            int n5 = insets.left;
            int n6 = insets.top + n3 - n4;
            ParallelCommandWindow.this.fPromptPanel.setBounds(n5, n6, dimension.width, dimension.height);
            ParallelCommandWindow.this.fCommandScroller.setBounds(n5 + dimension.width, n6, n2 - dimension.width, n4);
            n3 -= n4;
            if (ParallelCommandWindow.this.fPromptPad != null && ParallelCommandWindow.this.fPromptPad.getToolBar().isVisible()) {
                serializable = ParallelCommandWindow.this.fPromptPad.getToolBar();
                n = ((JComponent)serializable).getPreferredSize().height;
                n3 -= n;
                ((Component)serializable).setBounds(insets.left, n6 -= n, n2, n);
            }
            if (ParallelCommandWindow.this.fHistoryScroller.getParent() == this) {
                serializable = ParallelCommandWindow.this.fHistoryScroller.getBorder().getBorderInsets((Component)ParallelCommandWindow.this.fHistoryScroller);
                n = ((ParallelCommandWindow)ParallelCommandWindow.this).fHistoryTable.getPreferredSize().height + ((Insets)serializable).top + ((Insets)serializable).bottom;
                if (n >= n3) {
                    n = n3;
                }
                ParallelCommandWindow.this.fHistoryScroller.setBounds(insets.left, n6 -= n, n2, n);
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (ParallelCommandWindow.this.fHistoryScroller.getParent() == this) {
                this.revalidate();
                this.repaint();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateLineCount();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateLineCount();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void updateLineCount() {
            int n = ParallelCommandWindow.this.fCommandPane.getNumLines();
            if (n != this.iCommandLineCount) {
                if (ParallelCommandWindow.this.fPromptPad != null) {
                    if (this.iCommandLineCount == 1 && n > 1) {
                        ParallelCommandWindow.this.fPromptPad.attachedTo((JTextComponent)((Object)ParallelCommandWindow.this.fCommandPane));
                        ParallelCommandWindow.this.fPromptPad.getToolBar().setVisible(true);
                    } else if (this.iCommandLineCount > 1 && n == 1) {
                        ParallelCommandWindow.this.fPromptPad.detach();
                        ParallelCommandWindow.this.fPromptPad.getToolBar().setVisible(false);
                    }
                }
                this.iCommandLineCount = n;
                this.revalidate();
                this.repaint();
                JComponent jComponent = (JComponent)this.getParent();
                if (!(jComponent instanceof JSplitPane)) {
                    jComponent.revalidate();
                    jComponent.repaint();
                }
            }
        }
    }

    private class FindClient
    extends DesktopFindClient {
        FindClient() {
            super((String)ParallelCommandWindow.this.getClientProperty(DTClientProperty.TITLE), (Component)((Object)ParallelCommandWindow.this), ParallelCommandWindow.this.getParentDesktop());
        }

        public void findForward(FindEvent findEvent) {
        }

        public void findBack(FindEvent findEvent) {
        }

        public void replace(FindEvent findEvent) {
        }

        public void replaceAll(FindEvent findEvent) {
        }
    }

    private class InterruptLabsAction
    extends MJAbstractAction {
        private InterruptLabsAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ParallelCommandWindow.this.fCommandPane.clearCommandText();
            IntSet intSet = ParallelCommandWindow.this.fPrompt.getTargetLabs();
            ParallelCommandWindow.this.fOutputCollection.interruptOutput(intSet);
            ParallelCommandWindow.this.fLabs.interruptAndRemovePendingCommands(ParallelUI.getObserver());
        }
    }

    private class FindAction
    extends AbstractFindAction {
        FindAction() {
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FindDialog.invoke((FindClientInterface)ParallelCommandWindow.this.fFindClient, (String)"", (int)0);
        }
    }

    private class ToggleCommandsAction
    extends MJAbstractAction {
        ToggleCommandsAction() {
            super(ParallelUI.sRes.getString("action.ShowCommands"));
            this.setComponentName("ToggleCommands");
            this.setButtonOnlyIcon(new ImageIcon(ParallelCommandWindow.class.getResource("resources/showcommands.gif")));
            this.setTip(ParallelUI.sRes.getString("tip.ShowCommandsInOutputArea"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ParallelCommandWindow.this.setShowCommandText(this.isSelected());
        }
    }

    private class ClearAllOutputAction
    extends MJAbstractAction {
        ClearAllOutputAction() {
            super(ParallelUI.sRes.getString("action.ClearAll"));
            this.setComponentName("ClearAllOutputWindows");
            this.setButtonOnlyIcon(new ImageIcon(ParallelCommandWindow.class.getResource("resources/clearoutput.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ParallelCommandWindow.this.fOutputCollection.clearSession();
        }
    }

    private class HistoryPositionAction
    extends MJAbstractAction {
        private HistoryPosition iHistoryPosition;

        HistoryPositionAction(HistoryPosition historyPosition) {
            super(ParallelUI.sRes.getString("action." + (Object)((Object)historyPosition)));
            this.iHistoryPosition = historyPosition;
            this.setComponentName(ParallelCommandWindow.HISTORY_POSITION_ATTRIBUTE + historyPosition.toString());
            this.setSelected(this.iHistoryPosition == ParallelCommandWindow.this.fHistoryPosition);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ParallelCommandWindow.this.setHistoryPosition(this.iHistoryPosition, 0.35);
            ParallelCommandWindow.this.revalidate();
            ParallelCommandWindow.this.repaint();
        }
    }

    private static enum HistoryPosition {
        LEFT,
        RIGHT,
        ABOVE,
        POPUP,
        HIDDEN;

    }
}

