/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.jidesoft.swing.StyleRange;
import com.mathworks.toolbox.distcomp.parallelui.TextStyleInfo;
import com.mathworks.toolbox.distcomp.parallelui.TextSyntax;
import com.mathworks.widgets.Tokenizer;
import com.mathworks.widgets.TokenizerFactory;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class SyntaxTextStyleInfo
implements TextStyleInfo {
    private final Tokenizer.TokenInfo[] fTokens;

    public SyntaxTextStyleInfo(TextSyntax textSyntax, String string) {
        this(textSyntax, string.toCharArray());
    }

    public SyntaxTextStyleInfo(TextSyntax textSyntax, char[] cArray) {
        this.fTokens = textSyntax.getTokenizer().tokenize(cArray);
    }

    @Override
    public StyleRange[] getStyleRanges() {
        ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>(this.fTokens.length);
        for (Tokenizer.TokenInfo tokenInfo : this.fTokens) {
            Color color = this.getTokenColor(tokenInfo);
            if (color == null) continue;
            arrayList.add(new StyleRange(tokenInfo.getOffset(), tokenInfo.getLength(), color));
        }
        return arrayList.toArray(new StyleRange[arrayList.size()]);
    }

    @Override
    public int getAttributesCount() {
        return this.fTokens.length;
    }

    @Override
    public int getAttributesStart(int n) {
        return this.fTokens[n].getOffset();
    }

    @Override
    public int getAttributesLength(int n) {
        return this.fTokens[n].getLength();
    }

    @Override
    public AttributeSet getAttributes(int n) {
        Tokenizer.TokenInfo tokenInfo = this.fTokens[n];
        Color color = this.getTokenColor(tokenInfo);
        if (color != null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, color);
            return simpleAttributeSet;
        }
        return null;
    }

    private Color getTokenColor(Tokenizer.TokenInfo tokenInfo) {
        String string = tokenInfo.getColorPreferenceName();
        return string == null ? null : TokenizerFactory.getColorFromName((String)string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SyntaxTextStyleInfo)) {
            return false;
        }
        SyntaxTextStyleInfo syntaxTextStyleInfo = (SyntaxTextStyleInfo)object;
        if (this.fTokens.length != syntaxTextStyleInfo.fTokens.length) {
            return false;
        }
        for (int i = 0; i < this.fTokens.length; ++i) {
            if (this.fTokens[i].getOffset() == syntaxTextStyleInfo.fTokens[i].getOffset() && this.fTokens[i].getLength() == syntaxTextStyleInfo.fTokens[i].getLength() && this.fTokens[i].getColorPreferenceName() == syntaxTextStyleInfo.fTokens[i].getColorPreferenceName()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 11;
        for (Tokenizer.TokenInfo tokenInfo : this.fTokens) {
            n += 17 * tokenInfo.getOffset();
            n += 17 * tokenInfo.getLength();
            n += 17 * tokenInfo.getColorPreferenceName().hashCode();
        }
        return n;
    }
}

