/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.MDispatchableCommand;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.Session;
import com.mathworks.toolbox.distcomp.pmode.shared.BufferTransferrable;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public abstract class BufferTransferCommand
extends MDispatchableCommand
implements BufferTransferrable {
    protected transient ByteBufferHandle fBuffer;

    public BufferTransferCommand(ByteBufferHandle byteBufferHandle) {
        this.fBuffer = byteBufferHandle;
    }

    @Override
    public ByteBufferHandle[] getByteBuffers() {
        return new ByteBufferHandle[]{this.fBuffer};
    }

    @Override
    public void setByteBuffers(ByteBufferHandle[] byteBufferHandleArray) {
        if (byteBufferHandleArray == null) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Invalid attempt to setByteBuffers on a BufferTransferCommand with null buffer length ");
        } else if (byteBufferHandleArray.length != 1) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Invalid attempt to setByteBuffers on a BufferTransferCommand with buffer length " + byteBufferHandleArray.length);
        } else {
            this.fBuffer = byteBufferHandleArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeBufferToFile(File file) throws IOException {
        assert (file != null) : "localFile input must not be null";
        assert (this.fBuffer != null) : "fBuffer must not be null";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.write(this.fBuffer.get());
                fileChannel.close();
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "IOException caught during write to file", iOException);
            throw iOException;
        }
    }

    @Override
    public abstract void dispatch(ReturnGroup var1, Instance var2, Session var3);
}

