/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;

class DebugUtils {
    public static long sINTERRUPT_RETRY_INTERVAL_NANOS = 2000000000L;

    DebugUtils() {
    }

    static void interruptMatlabClearDebugState() {
        DebugUtils.interruptMatlabClearDebugState(null);
    }

    static void interruptMatlabClearDebugState(final CompletionObserver completionObserver) {
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Sending an interrupt to matlab.");
        final MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
        CompletionObserver completionObserver2 = new CompletionObserver(){

            public void completed(int n, Object object) {
                if (completionObserver != null) {
                    matlabMCR.evalNoOutput("disp('')", completionObserver);
                }
            }
        };
        MatlabInterrupter.start(completionObserver2);
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Interrupter has now started.");
        matlabMCR.evalNoOutput("dbclear all;", DebugUtils.getLoggingCompletionObserver("sDBCLEAR_COMMAND"));
        matlabMCR.evalNoOutput("if system_dependent('IsDebugMode'), dbquit all; end;", DebugUtils.getLoggingCompletionObserver("sDBQUIT_COMMAND"));
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "sDBCLEAR_COMMAND and sDBQUIT_COMMAND put on IQM");
    }

    static void interruptMatlabClearDebugStateUseMwmpi(CompletionObserver completionObserver) {
        MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
        DebugUtils.interruptMatlabClearDebugState(completionObserver);
        matlabMCR.evalNoOutput("remoteParallelFunction([], [], true)", DebugUtils.getLoggingCompletionObserver("sUSE_MWMPI_COMMAND"));
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "sUSE_MWMPI_COMMAND put on IQM");
    }

    private static CompletionObserver getLoggingCompletionObserver(final String string) {
        return new CompletionObserver(){

            public void completed(int n, Object object) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Completion observer with logMessage : " + string + " with status " + Matlab.getExecutionStatus((int)n));
            }
        };
    }

    static class MatlabInterrupter
    extends Thread
    implements CompletionObserver {
        MatlabMCR fMCR = MatlabRefStore.getMatlabRef();
        CompletionObserver fObs;
        ReentrantLock fLock;
        Condition fCond;
        AtomicBoolean fInterruptHasOccurred;
        Semaphore fIndicateEvalHasOccurred;

        static MatlabInterrupter start(CompletionObserver completionObserver) {
            assert (!NativeMatlab.nativeIsMatlabThread()) : "Do not attempt to interrupt MATLAB from MATLAB!";
            MatlabInterrupter matlabInterrupter = new MatlabInterrupter(completionObserver);
            matlabInterrupter.start();
            matlabInterrupter.fIndicateEvalHasOccurred.acquireUninterruptibly();
            return matlabInterrupter;
        }

        MatlabInterrupter(CompletionObserver completionObserver) {
            this.fObs = completionObserver;
            this.fLock = new ReentrantLock();
            this.fCond = this.fLock.newCondition();
            this.fInterruptHasOccurred = new AtomicBoolean(false);
            this.fIndicateEvalHasOccurred = new Semaphore(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = true;
            int n = 0;
            this.fLock.lock();
            try {
                while (!this.fInterruptHasOccurred.get()) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "About to call fMCR.interrupt " + ++n + ", " + this.getId());
                    this.fMCR.interrupt();
                    if (bl) {
                        this.fMCR.evalNoOutput("disp('')", (CompletionObserver)this);
                        this.fMCR.evalNoOutput("disp('')", new CompletionObserver(){

                            public void completed(int n, Object object) {
                                MatlabInterrupter.this.checkAndLogNullCommandStatus(2, n);
                            }
                        });
                        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Pushed 2 sNULL_MATLAB_COMMAND onto IQM " + this.getId());
                        bl = false;
                        this.fIndicateEvalHasOccurred.release();
                    }
                    try {
                        this.fCond.awaitNanos(sINTERRUPT_RETRY_INTERVAL_NANOS);
                    }
                    catch (InterruptedException interruptedException) {
                        PackageInfo.LOGGER.log(DistcompLevel.TWO, "InterruptedException caught whilst awaiting, ", this.getId());
                    }
                }
            }
            finally {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Interrupt thread ending");
                this.fLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(int n, Object object) {
            this.fInterruptHasOccurred.set(true);
            this.checkAndLogNullCommandStatus(1, n);
            this.fLock.lock();
            try {
                this.fCond.signalAll();
            }
            finally {
                this.fLock.unlock();
            }
            this.fObs.completed(n, object);
        }

        private void checkAndLogNullCommandStatus(int n, int n2) {
            if (!NativeMatlab.nativeIsMatlabThread()) {
                PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Completion observer (" + n + ") not invoked on MATLAB main thread.");
                assert (false) : "Completion observer (" + n + ") must run on the MATLAB main thread.";
            }
            String string = Matlab.getExecutionStatus((int)n2) == 4 ? "CTRL_C" : "COMPLETE";
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "sNULL_MATLAB_COMMAND (" + n + ") complete, execution: " + string + ", about to set flag, " + this.getId());
        }
    }
}

