/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.DispatchInvoker;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MCommand;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DispatcherImpl
implements Dispatcher<Message> {
    private LinkedList<DispatchInvoker> fDispatchers = new LinkedList();
    private ConcurrentHashMap<Class, DispatchInvoker> fDispatcherCacheMap = new ConcurrentHashMap(20);
    private ReentrantReadWriteLock fDispatchLock = new ReentrantReadWriteLock();

    public static DispatcherImpl create() {
        return new DispatcherImpl();
    }

    protected DispatcherImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Message message, Instance instance) {
        ReentrantReadWriteLock.ReadLock readLock = this.fDispatchLock.readLock();
        readLock.lock();
        try {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Dispatching object of type:\n   " + message.getClass().getName());
            if (message instanceof MCommand) {
                MCommand mCommand = (MCommand)message;
                mCommand.setSourceProcess(instance);
            }
            boolean bl = this.dispatchToList(message, instance);
            assert (bl) : "Received an unknown object type to dispatch: " + message.getClass().getName();
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDispatcher(Dispatcher<? extends Message> dispatcher) {
        DispatchInvoker dispatchInvoker = DispatchInvoker.create(dispatcher);
        ReentrantReadWriteLock.WriteLock writeLock = this.fDispatchLock.writeLock();
        writeLock.lock();
        try {
            Class clazz = dispatchInvoker.getMessageClass();
            this.fDispatchers.add(dispatchInvoker);
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Added  " + dispatcher.getClass().getName() + " to list of DispatchInvokers");
            this.fDispatcherCacheMap.put(clazz, dispatchInvoker);
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Added  " + clazz.getName() + " to list of msg cache to be invoked by " + dispatcher.getClass().getName());
        }
        finally {
            writeLock.unlock();
        }
    }

    private boolean dispatchToList(Message message, Instance instance) {
        Class<?> clazz = message.getClass();
        DispatchInvoker dispatchInvoker = this.fDispatcherCacheMap.get(clazz);
        if (dispatchInvoker != null) {
            dispatchInvoker.invoke(message, instance);
            return true;
        }
        for (DispatchInvoker dispatchInvoker2 : this.fDispatchers) {
            if (!dispatchInvoker2.isInvokableObject(clazz)) continue;
            this.fDispatcherCacheMap.put(clazz, dispatchInvoker2);
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Added  " + clazz.getName() + " to list of msg cache to be invoked by " + dispatchInvoker2.getDispatcher().getClass().getName());
            dispatchInvoker2.invoke(message, instance);
            return true;
        }
        return false;
    }
}

