/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.CmdExecResults;
import com.mathworks.toolbox.distcomp.pmode.MatlabOutputWriters;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;

class MResultsHandler
implements MatlabOutputWriters.MatlabOutputListener {
    private long fSequenceNum = -1L;
    private Instance fRequester = null;
    private ReturnGroup fOut;

    public MResultsHandler(ReturnGroup returnGroup) {
        this.fOut = returnGroup;
    }

    public void commandAboutToStart(long l, Instance instance) {
        assert (this.fSequenceNum == -1L) : "commandAboutToStart called with existing active sequence";
        assert (this.fRequester == null) : "commandAboutToStart called with existing active requester";
        this.fSequenceNum = l;
        this.fRequester = instance;
        MatlabOutputWriters.getInstance().flushAllPendingOutputNoException();
        MatlabOutputWriters.getInstance().addOutputListener(this);
    }

    public void commandCompleted(long l, String string) {
        assert (this.fSequenceNum == l) : "commandCompleted called with a non-matching sequence number";
    }

    public void deadlockDetectionCompleted(long l, int n, String string) {
        assert (this.fSequenceNum == l) : "commandCompleted called with a non-matching sequence number";
        MatlabOutputWriters.getInstance().flushAllPendingOutputNoException();
        MatlabOutputWriters.getInstance().removeOutputListener(this);
        CmdExecResults cmdExecResults = new CmdExecResults(n, l);
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Exec result: " + cmdExecResults);
        this.fOut.returnTo(this.fRequester, cmdExecResults);
        this.fSequenceNum = -1L;
        this.fRequester = null;
    }

    @Override
    public void stdout(String string) {
        if (this.fSequenceNum != -1L) {
            this.sendCommandOutput(this.fSequenceNum, string);
        }
    }

    @Override
    public void stderr(String string) {
        if (this.fSequenceNum != -1L) {
            this.sendCommandOutput(this.fSequenceNum, string);
        }
    }

    private void sendCommandOutput(long l, String string) {
        assert (this.fRequester != null) : "sendCommandOutput called with no valid requester";
        MatlabOutputWriters.returnCommandOutput(string, this.fOut, l, this.fRequester);
    }
}

