/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class MessageTracker {
    private CountDownLatch fMessageCounter;
    private AtomicBoolean fMessagesSent;
    private Map<Instance, ReturnMessage> fResultMap;

    MessageTracker(int n) {
        this.fMessageCounter = new CountDownLatch(n);
        this.fMessagesSent = new AtomicBoolean(false);
        this.fResultMap = new ConcurrentHashMap<Instance, ReturnMessage>();
    }

    boolean alreadySent() {
        return this.fMessagesSent.get();
    }

    boolean markSent() {
        return this.fMessagesSent.getAndSet(true);
    }

    void skip() {
        this.markSent();
        while (!this.isComplete()) {
            this.fMessageCounter.countDown();
        }
    }

    void messageReturned(Instance instance, ReturnMessage returnMessage) {
        if (returnMessage != null) {
            this.fResultMap.put(instance, returnMessage);
        }
        this.fMessageCounter.countDown();
    }

    boolean hasReturnFrom(Instance instance) {
        return this.fResultMap.containsKey(instance);
    }

    ReturnMessage getResult(ProcessInstance processInstance) {
        assert (this.isComplete()) : "Attempt to get result prior to completion";
        return this.fResultMap.get(processInstance);
    }

    boolean isComplete() {
        return this.await(0L, TimeUnit.SECONDS);
    }

    boolean await(long l, TimeUnit timeUnit) {
        boolean bl = false;
        try {
            bl = this.fMessageCounter.await(l, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return bl;
    }
}

