/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.CannotAcquireLabsException;
import com.mathworks.toolbox.distcomp.pmode.CmdWinOutput;
import com.mathworks.toolbox.distcomp.pmode.DrainableOutput;
import com.mathworks.toolbox.distcomp.pmode.DrainableOutputImpl;
import com.mathworks.toolbox.distcomp.pmode.FevalResult;
import com.mathworks.toolbox.distcomp.pmode.IntervalResultImpl;
import com.mathworks.toolbox.distcomp.pmode.IntervalType;
import com.mathworks.toolbox.distcomp.pmode.LoopState;
import com.mathworks.toolbox.distcomp.pmode.LoopStateTracker;
import com.mathworks.toolbox.distcomp.pmode.MFevalCommand;
import com.mathworks.toolbox.distcomp.pmode.MFevalLargeDataCommand;
import com.mathworks.toolbox.distcomp.pmode.MInterrupt;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.ParforController;
import com.mathworks.toolbox.distcomp.pmode.PendingInterval;
import com.mathworks.toolbox.distcomp.pmode.SessionConstants;
import com.mathworks.toolbox.distcomp.pmode.SessionDestroyedException;
import com.mathworks.toolbox.distcomp.pmode.shared.FinalReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ResourceManager;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionService;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ParforControllerImpl
implements ParforController {
    private final ResourceManager fResourceManager;
    private final OutputGroup fOutGroup;
    private final SessionService fSessionService;
    private DrainableOutput fDrainableOutput;
    private int fNumLabsAcquired;
    private int fNumFinalIntervals;
    private AtomicInteger fNumMessagesInFlight;
    private boolean fLoopInterrupted;
    private LoopStateTracker fLoopStateTracker;
    private ByteBufferHandle fInitData;
    private final List<PendingInterval> fPendingQueue;
    private static final int HEAD = 0;
    private LinkedBlockingQueue<Integer> fAvailableLabs = new LinkedBlockingQueue();
    private LinkedBlockingQueue<ParforController.IntervalResult> fIntervalCompleteQueue = new LinkedBlockingQueue();
    private CountDownLatch fCompletedLatch = new CountDownLatch(1);

    public static ParforControllerImpl create(SessionService sessionService, OutputGroup outputGroup) throws SessionDestroyedException, CannotAcquireLabsException {
        Object object;
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Creating a new ParforControllerImpl");
        ResourceManager resourceManager = sessionService.getResourceManager();
        if (!sessionService.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        try {
            object = resourceManager.acquireCurrentHolderToken(SessionConstants.sPARFOR_CREATION_TIMEOUT);
        }
        catch (InterruptedException interruptedException) {
            object = null;
        }
        if (object == null) {
            throw new CannotAcquireLabsException("Failed to create a ParforController - timeout reached waiting for the previous one to have all messages returned");
        }
        ParforControllerImpl parforControllerImpl = new ParforControllerImpl(sessionService, outputGroup);
        parforControllerImpl.init();
        resourceManager.setCurrentHolder(parforControllerImpl, object);
        return parforControllerImpl;
    }

    private ParforControllerImpl(SessionService sessionService, OutputGroup outputGroup) {
        this.fOutGroup = outputGroup;
        this.fSessionService = sessionService;
        this.fPendingQueue = Collections.synchronizedList(new LinkedList());
        this.fLoopStateTracker = new LoopStateTracker(0);
        this.fNumFinalIntervals = 0;
        this.fLoopInterrupted = false;
        this.fNumMessagesInFlight = new AtomicInteger(0);
        this.fResourceManager = sessionService.getResourceManager();
    }

    private void init() {
    }

    @Override
    public synchronized int acquireLabs(int n) throws SessionDestroyedException {
        assert (this.fLoopStateTracker.getState() == LoopState.Initialized) : "Invalid LoopState - should be Initialized but is " + (Object)((Object)this.fLoopStateTracker.getState());
        assert (n > 0) : "Number of labs requested in acquireLabs must be greater than zero";
        if (!this.fSessionService.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        this.fNumLabsAcquired = Math.min(n, this.fOutGroup.getNumDestinations());
        this.fLoopStateTracker = new LoopStateTracker(this.fNumLabsAcquired);
        for (int i = 0; i < this.fNumLabsAcquired; ++i) {
            this.makeLabAvailable(i);
            this.fLoopStateTracker.setState(i, LoopState.Acquired);
        }
        Instance[] instanceArray = ProcessInstance.getAllLabs(this.fNumLabsAcquired);
        this.fDrainableOutput = new DrainableOutputImpl(instanceArray, false);
        return this.fNumLabsAcquired;
    }

    @Override
    public BlockingQueue<ParforController.IntervalResult> getIntervalCompleteQueue() {
        return this.fIntervalCompleteQueue;
    }

    @Override
    public synchronized int getNumAcquiredLabs() {
        return this.fNumLabsAcquired;
    }

    @Override
    public boolean awaitCompleted(int n, TimeUnit timeUnit) {
        try {
            return this.fCompletedLatch.await(n, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public int[] pGetIntervalNumbers() {
        return new int[]{this.fNumLabsAcquired, this.fNumFinalIntervals};
    }

    public boolean pGetLoopInterrupted() {
        return this.fLoopInterrupted;
    }

    public LoopStateTracker pGetLoopStateTracker() {
        return this.fLoopStateTracker;
    }

    public List<PendingInterval> pGetPendingQueue() {
        return this.fPendingQueue;
    }

    @Override
    public synchronized void beginLoop(ByteBufferHandle byteBufferHandle) {
        assert (this.fLoopStateTracker.getState() == LoopState.Acquired) : "Invalid LoopState - should be Acquired but is " + (Object)((Object)this.fLoopStateTracker.getState());
        this.fInitData = byteBufferHandle;
        this.fLoopStateTracker.setState(LoopState.Started);
    }

    @Override
    public synchronized boolean addInterval(int n, ByteBufferHandle byteBufferHandle) {
        return this.addInterval(n, byteBufferHandle, IntervalType.Normal);
    }

    @Override
    public synchronized boolean addFinalInterval(int n, ByteBufferHandle byteBufferHandle) {
        return this.addInterval(n, byteBufferHandle, IntervalType.Final);
    }

    @Override
    public void interruptOnError() {
        this.fDrainableOutput.closeForOutput();
        this.doInterrupt();
    }

    @Override
    public synchronized void interrupt() {
        this.doInterrupt();
    }

    @Override
    public DrainableOutput getDrainableOutput() {
        return this.fDrainableOutput;
    }

    private boolean addInterval(int n, ByteBufferHandle byteBufferHandle, IntervalType intervalType) {
        Integer n2;
        assert (this.fLoopStateTracker.getState().ordinal() >= LoopState.Started.ordinal()) : "Invalid LoopState - should be Started but is " + (Object)((Object)this.fLoopStateTracker.getState());
        assert (this.fNumFinalIntervals < this.fNumLabsAcquired) : "Number of final intervals cannot be more that the number of labs";
        if (this.fLoopInterrupted || !this.fSessionService.isSessionRunning()) {
            return false;
        }
        if (intervalType == IntervalType.Final) {
            ++this.fNumFinalIntervals;
        }
        if ((n2 = this.getNextAvailableLab()) != null) {
            this.sendInterval(n2, n, byteBufferHandle, intervalType);
        } else {
            this.fPendingQueue.add(new PendingInterval(n, byteBufferHandle, intervalType));
        }
        return true;
    }

    private void sendInterval(int n, PendingInterval pendingInterval) {
        this.sendInterval(n, pendingInterval.fTag, pendingInterval.fData, pendingInterval.fType);
    }

    private void sendInterval(final int n, final int n2, ByteBufferHandle byteBufferHandle, final IntervalType intervalType) {
        assert (!this.fLoopInterrupted) : "Should not send an interval if the loop state is interrupted";
        assert (this.fLoopStateTracker.getNumStarted() <= this.fNumLabsAcquired) : "Number of start intervals cannot be more that the number of labs";
        LoopState loopState = this.fLoopStateTracker.getState(n);
        assert (loopState != LoopState.SendComplete) : "Invalid LoopState - should not be SendComplete";
        Object[] objectArray = new Object[]{loopState == LoopState.Acquired ? this.fInitData : ByteBufferHandle.allocate(0), byteBufferHandle, intervalType == IntervalType.Final};
        MFevalLargeDataCommand mFevalLargeDataCommand = new MFevalLargeDataCommand(SessionConstants.sPARFOR_FUNCTION, objectArray, SessionConstants.sPARFOR_FUNCTION_NLHS, MFevalCommand.ConsoleOutput.Return);
        MessageObserver messageObserver = new MessageObserver(){

            @Override
            public void completed(ReturnMessage returnMessage, Instance instance) {
                ParforControllerImpl.this.handleReturnMessage(n, n2, intervalType, returnMessage, instance);
            }
        };
        this.fOutGroup.sendTo(ProcessInstance.getLabInstance(n + 1), mFevalLargeDataCommand, messageObserver);
        this.fNumMessagesInFlight.getAndIncrement();
        byteBufferHandle.free();
        if (loopState == LoopState.Acquired) {
            this.fLoopStateTracker.setState(n, LoopState.Started);
        }
        if (intervalType == IntervalType.Final) {
            this.fLoopStateTracker.setState(n, LoopState.SendComplete);
        }
        if (this.fLoopStateTracker.getNumStarted() == this.fNumLabsAcquired && this.fInitData != null) {
            this.fInitData.free();
            this.fInitData = null;
        }
    }

    private void handleReturnMessage(int n, int n2, IntervalType intervalType, ReturnMessage returnMessage, Instance instance) {
        if (returnMessage instanceof FinalReturnMessage) {
            if (returnMessage instanceof FevalResult) {
                FevalResult fevalResult = (FevalResult)returnMessage;
                this.onIntervalCompleted(n, n2, intervalType, fevalResult, instance);
            }
        } else if (returnMessage instanceof CmdWinOutput) {
            String[] stringArray = ((CmdWinOutput)returnMessage).getStrings();
            this.fDrainableOutput.addOutput(ProcessInstance.getLabInstance(n + 1), stringArray);
        }
    }

    private synchronized void onFinalReturnMessage(ReturnMessage returnMessage, Instance instance) {
        int n = this.fNumMessagesInFlight.decrementAndGet();
        assert (n >= 0) : "Cannot have less than zero messages in flight";
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Received a message: " + returnMessage + ", fLoopInterrupted: " + this.fLoopInterrupted + ", numInFlight: " + n);
        if (n == 0) {
            if (this.fLoopInterrupted || this.fNumFinalIntervals == this.fNumLabsAcquired) {
                this.fLoopStateTracker.setState(LoopState.ReceiveComplete);
                this.fResourceManager.releaseCurrentHolder(this);
                this.fCompletedLatch.countDown();
            }
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Messages in flight == 0");
        }
    }

    private synchronized void onIntervalCompleted(int n, int n2, IntervalType intervalType, FevalResult fevalResult, Instance instance) {
        if (!this.fLoopInterrupted) {
            IntervalResultImpl intervalResultImpl = new IntervalResultImpl(n2, fevalResult);
            boolean bl = this.fIntervalCompleteQueue.offer(intervalResultImpl);
            assert (bl) : "Unable to put return interval on the interval complete queue";
            if (intervalResultImpl.hasError()) {
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Error detected on rank " + n + " - interrupting loop");
                this.fDrainableOutput.closeForOutput();
                this.doInterrupt();
            } else if (intervalType == IntervalType.Normal) {
                if (this.fPendingQueue.isEmpty()) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Putting token for rank " + n + " on the available labs queue");
                    this.makeLabAvailable(n);
                } else {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Sending a pending interval to rank " + n);
                    this.sendInterval(n, this.fPendingQueue.remove(0));
                }
            } else if (intervalType == IntervalType.Final) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Rank : " + n + " is now finished processing intervals");
                this.fLoopStateTracker.setState(n, LoopState.ReceiveComplete);
            }
        }
        this.onFinalReturnMessage(fevalResult, instance);
    }

    private synchronized void doInterrupt() {
        if (this.fLoopInterrupted || !this.fSessionService.isSessionRunning()) {
            return;
        }
        if (this.fLoopStateTracker.getState() == LoopState.ReceiveComplete) {
            return;
        }
        this.fLoopInterrupted = true;
        MInterrupt mInterrupt = new MInterrupt();
        MessageObserver messageObserver = new MessageObserver(){

            @Override
            public void completed(ReturnMessage returnMessage, Instance instance) {
                if (returnMessage instanceof FinalReturnMessage) {
                    ParforControllerImpl.this.onFinalReturnMessage(returnMessage, instance);
                }
            }
        };
        for (int i = 0; i < this.fNumLabsAcquired; ++i) {
            this.fOutGroup.sendTo(ProcessInstance.getLabInstance(i + 1), mInterrupt, messageObserver);
            this.fNumMessagesInFlight.getAndIncrement();
        }
        this.fPendingQueue.clear();
        this.fAvailableLabs.clear();
    }

    private void makeLabAvailable(int n) {
        boolean bl = this.fAvailableLabs.offer(n);
        assert (bl) : "Unable to put token on the available labs queue";
    }

    private Integer getNextAvailableLab() {
        return this.fAvailableLabs.poll();
    }
}

