/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.LongArrayHolder;
import com.mathworks.toolbox.distcomp.pmode.MFevalLargeDataCommand;
import com.mathworks.toolbox.distcomp.pmode.SessionConstants;
import com.mathworks.toolbox.distcomp.pmode.SingleRemoteEvaluationObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public final class RemoteCompositeAssistant {
    private ConcurrentMap<ProcessInstance, ConcurrentLinkedQueue<Long>> fProc2Keys = new ConcurrentHashMap<ProcessInstance, ConcurrentLinkedQueue<Long>>();
    private SessionService fSession;
    private OutputGroup fComms;

    RemoteCompositeAssistant(SessionService sessionService, OutputGroup outputGroup) {
        this.fSession = sessionService;
        this.fComms = outputGroup;
    }

    public SingleRemoteEvaluationObserver retrieveCompositeValue(ProcessInstance processInstance, Object object) {
        assert (this.fSession.isSessionRunning()) : "No session to retrieve value";
        MFevalLargeDataCommand mFevalLargeDataCommand = new MFevalLargeDataCommand(SessionConstants.sSPMD_COMPOSITE_RETRIEVAL, new Object[]{object, this.returnRemoteClearKeys(processInstance)}, SessionConstants.sSPMD_COMPOSITE_RETRIEVAL_NARGOUT);
        SingleRemoteEvaluationObserver singleRemoteEvaluationObserver = new SingleRemoteEvaluationObserver();
        this.fComms.sendTo(processInstance, mFevalLargeDataCommand, singleRemoteEvaluationObserver);
        return singleRemoteEvaluationObserver;
    }

    public SingleRemoteEvaluationObserver sendCompositeValue(ProcessInstance processInstance, Object object) {
        assert (this.fSession.isSessionRunning()) : "No session to retrieve value";
        MFevalLargeDataCommand mFevalLargeDataCommand = new MFevalLargeDataCommand(SessionConstants.sSPMD_COMPOSITE_SEND, new Object[]{object, this.returnRemoteClearKeys(processInstance)}, SessionConstants.sSPMD_COMPOSITE_SEND_NARGOUT);
        SingleRemoteEvaluationObserver singleRemoteEvaluationObserver = new SingleRemoteEvaluationObserver();
        this.fComms.sendTo(processInstance, mFevalLargeDataCommand, singleRemoteEvaluationObserver);
        return singleRemoteEvaluationObserver;
    }

    public void notifyRemoteClear(ProcessInstance processInstance, long l) {
        if (!this.fProc2Keys.containsKey(processInstance)) {
            ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue();
            this.fProc2Keys.putIfAbsent(processInstance, concurrentLinkedQueue);
        }
        ((ConcurrentLinkedQueue)this.fProc2Keys.get(processInstance)).add(l);
    }

    public Object returnRemoteClearKeys(ProcessInstance processInstance) {
        ConcurrentLinkedQueue<Long> concurrentLinkedQueue = this.fProc2Keys.replace(processInstance, new ConcurrentLinkedQueue());
        if (concurrentLinkedQueue == null || concurrentLinkedQueue.size() == 0) {
            return null;
        }
        return LongArrayHolder.build(concurrentLinkedQueue);
    }
}

