/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.CannotAcquireLabsException;
import com.mathworks.toolbox.distcomp.pmode.Client;
import com.mathworks.toolbox.distcomp.pmode.ClientImpl;
import com.mathworks.toolbox.distcomp.pmode.ClientMExecutorImpl;
import com.mathworks.toolbox.distcomp.pmode.ClientShutdownHandlerImpl;
import com.mathworks.toolbox.distcomp.pmode.ClientStartupSucceeded;
import com.mathworks.toolbox.distcomp.pmode.ClosableSessionConnections;
import com.mathworks.toolbox.distcomp.pmode.DispatcherImpl;
import com.mathworks.toolbox.distcomp.pmode.FatalErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.FileDependenciesAssistant;
import com.mathworks.toolbox.distcomp.pmode.LabMExecutorImpl;
import com.mathworks.toolbox.distcomp.pmode.LabShutdownHandlerImpl;
import com.mathworks.toolbox.distcomp.pmode.LabStartupSucceeded;
import com.mathworks.toolbox.distcomp.pmode.Labs;
import com.mathworks.toolbox.distcomp.pmode.LabsImpl;
import com.mathworks.toolbox.distcomp.pmode.LanguageControllerProvider;
import com.mathworks.toolbox.distcomp.pmode.MExecutor;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.ParforController;
import com.mathworks.toolbox.distcomp.pmode.ParforControllerImpl;
import com.mathworks.toolbox.distcomp.pmode.PathNotificationListener;
import com.mathworks.toolbox.distcomp.pmode.RemoteCompositeAssistant;
import com.mathworks.toolbox.distcomp.pmode.ResourceManagerImpl;
import com.mathworks.toolbox.distcomp.pmode.ReturnMessageDispatcherImpl;
import com.mathworks.toolbox.distcomp.pmode.SessionCreatedEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionCreatedListener;
import com.mathworks.toolbox.distcomp.pmode.SessionDestroyedException;
import com.mathworks.toolbox.distcomp.pmode.SessionEndedEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionListener;
import com.mathworks.toolbox.distcomp.pmode.SessionShutdownEvent;
import com.mathworks.toolbox.distcomp.pmode.SpmdController;
import com.mathworks.toolbox.distcomp.pmode.SpmdControllerImpl;
import com.mathworks.toolbox.distcomp.pmode.SpmdExecutor;
import com.mathworks.toolbox.distcomp.pmode.SpmdExecutorImpl;
import com.mathworks.toolbox.distcomp.pmode.StartupSucceeded;
import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.DispatchableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessageRegistry;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ResourceManager;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionService;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.pmode.transfer.Transfer;
import com.mathworks.toolbox.distcomp.util.Executor;
import com.mathworks.toolbox.distcomp.util.FixedThreadPool;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.distcomp.util.ObjectCountDownLatch;
import com.mathworks.toolbox.distcomp.util.RunCallableOnce;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class Session
implements SessionService,
LanguageControllerProvider {
    private final boolean fIsClient;
    private Executor fListenerExec;
    private ObservableMessageRegistry fReturnMessageRegistry;
    private ErrorHandler fErrorHandler;
    private ResourceManager fResourceManager;
    private Executor fDispatcherExec;
    private CommunicationGroup fCommGroup;
    private Dispatcher<Message> fDispatcher;
    private MExecutor fMExec;
    private SpmdExecutor fSpmdExec;
    private ObjectCountDownLatch<Instance> fStartupSucceededCounter;
    private RunCallableOnce fOnSessionStartupComplete;
    private RemoteCompositeAssistant fRemoteCompositeAssistant;
    private FileDependenciesAssistant fFileDependenciesAssistant;
    private Transfer fTransfer;
    private Client fClient;
    private Labs fLabs;
    private ShutdownHandler fShutdownHandler;
    private PathNotificationListener fPathNotificationListener;
    private final Set<SessionListener> fSessionListenerSet = Collections.synchronizedSet(new HashSet());
    private static final Set<SessionCreatedListener> sSessionCreatedListenersSet = Collections.synchronizedSet(new HashSet());

    static Session create(Connection connection, int n) {
        ProcessInstance.setThisProcess(ProcessInstance.getLabInstance(n));
        Session session = new Session(n);
        session.initSessionServices();
        session.initSession(new Connection[]{connection}, new ProcessInstance[]{ProcessInstance.getClientInstance()}, ProcessInstance.getThisProcess());
        Session.notifySessionCreatedListeners(session);
        return session;
    }

    static Session create(Connection[] connectionArray) {
        ProcessInstance.setThisProcess(ProcessInstance.getClientInstance());
        Session session = new Session();
        session.initSessionServices();
        session.initSession(connectionArray, ProcessInstance.getAllLabs(connectionArray.length), ProcessInstance.getThisProcess());
        Session.notifySessionCreatedListeners(session);
        return session;
    }

    private Session(int n) {
        this.fIsClient = false;
    }

    private Session() {
        this.fIsClient = true;
    }

    public Client getClient() {
        return this.fClient;
    }

    public Labs getLabs() {
        return this.fLabs;
    }

    public Transfer getTransfer() {
        return this.fTransfer;
    }

    public int getPoolSize() {
        return this.fCommGroup.getNumDestinations();
    }

    public CommunicationGroup getCommGroupForDebugONLY() {
        return this.fCommGroup;
    }

    public Dispatcher getDispatcherForDebugONLY() {
        return this.fDispatcher;
    }

    public synchronized FileDependenciesAssistant getFileDependenciesAssistant() throws SessionDestroyedException {
        if (!this.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        if (this.fFileDependenciesAssistant == null) {
            assert (this.fCommGroup != null) : "Unable to make FileDependenciesAssistant if there is no CommunicationGroup Available";
            this.fFileDependenciesAssistant = new FileDependenciesAssistant(this, this.fCommGroup);
        }
        return this.fFileDependenciesAssistant;
    }

    public static boolean addSessionCreatedListener(SessionCreatedListener sessionCreatedListener) {
        return sSessionCreatedListenersSet.add(sessionCreatedListener);
    }

    public static boolean removeSessionCreatedListener(SessionCreatedListener sessionCreatedListener) {
        return sSessionCreatedListenersSet.remove(sessionCreatedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifySessionCreatedListeners(Session session) {
        SessionCreatedEvent sessionCreatedEvent = new SessionCreatedEvent(session);
        SessionCreatedListener[] sessionCreatedListenerArray = sSessionCreatedListenersSet;
        synchronized (sSessionCreatedListenersSet) {
            SessionCreatedListener[] sessionCreatedListenerArray2 = sSessionCreatedListenersSet.toArray(new SessionCreatedListener[sSessionCreatedListenersSet.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (SessionCreatedListener sessionCreatedListener : sessionCreatedListenerArray2) {
                try {
                    sessionCreatedListener.sessionCreated(sessionCreatedEvent);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public boolean addSessionListener(SessionListener sessionListener) {
        return this.fSessionListenerSet.add(sessionListener);
    }

    public boolean removeSessionListener(SessionListener sessionListener) {
        return this.fSessionListenerSet.remove(sessionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySessionEnded(final SessionShutdownEvent sessionShutdownEvent) {
        SessionEndedEventDispatcher sessionEndedEventDispatcher;
        switch (sessionShutdownEvent.getShutdownState()) {
            case NORMAL: {
                sessionEndedEventDispatcher = new SessionEndedEventDispatcher(){

                    @Override
                    public void dispatch(SessionListener sessionListener) {
                        sessionListener.sessionClosed(new SessionEndedEvent(Session.this, sessionShutdownEvent));
                    }
                };
                break;
            }
            case ERROR: {
                sessionEndedEventDispatcher = new SessionEndedEventDispatcher(){

                    @Override
                    public void dispatch(SessionListener sessionListener) {
                        sessionListener.sessionErrored(new SessionEndedEvent(Session.this, sessionShutdownEvent));
                    }
                };
                break;
            }
            default: {
                PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Session ended with unexpected ShutdownState" + (Object)((Object)sessionShutdownEvent.getShutdownState()));
                return;
            }
        }
        SessionListener[] sessionListenerArray = this.fSessionListenerSet;
        synchronized (this.fSessionListenerSet) {
            SessionListener[] sessionListenerArray2 = this.fSessionListenerSet.toArray(new SessionListener[this.fSessionListenerSet.size()]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (SessionListener sessionListener : sessionListenerArray2) {
                try {
                    sessionEndedEventDispatcher.dispatch(sessionListener);
                }
                catch (Throwable throwable) {
                    PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Listener threw exception.", throwable);
                }
            }
            return;
        }
    }

    @Override
    public synchronized RemoteCompositeAssistant getCompositeAssistant() throws SessionDestroyedException {
        if (!this.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        if (this.fRemoteCompositeAssistant == null) {
            assert (this.fCommGroup != null) : "Unable to make RemoteCompositeAssistant if there is no CommunicationGroup Available";
            this.fRemoteCompositeAssistant = new RemoteCompositeAssistant(this, this.fCommGroup);
        }
        return this.fRemoteCompositeAssistant;
    }

    @Override
    public ParforController createParforController() throws SessionDestroyedException, CannotAcquireLabsException {
        return ParforControllerImpl.create(this, this.fCommGroup);
    }

    @Override
    public SpmdController createSpmdController() throws SessionDestroyedException, CannotAcquireLabsException {
        return SpmdControllerImpl.create(this, this.fCommGroup);
    }

    public boolean isPoolManagerSession() {
        return !this.fShutdownHandler.hasShutdownBegun() && this.fIsClient;
    }

    public void startSendPathAndClearNotificationToLabs() {
        if (this.fPathNotificationListener != null) {
            this.fPathNotificationListener.register();
        }
    }

    public void stopSendPathAndClearNotificationToLabs() {
        if (this.fPathNotificationListener != null) {
            this.fPathNotificationListener.unregister();
        }
    }

    public boolean normalShutdown() {
        return this.fShutdownHandler.normalShutdown();
    }

    @Override
    public Executor getListenerExecutor() {
        return this.fListenerExec;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    @Override
    public ObservableMessageRegistry getReturnMessageRegistry() {
        return this.fReturnMessageRegistry;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    @Override
    public boolean isSessionRunning() {
        return this.fShutdownHandler != null && !this.fShutdownHandler.hasShutdownBegun();
    }

    @Override
    public boolean hasSessionStarted() {
        return this.fStartupSucceededCounter.complete();
    }

    public boolean waitForSessionToStart(long l, TimeUnit timeUnit) throws InterruptedException {
        if (!this.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        if (this.hasSessionStarted()) {
            return true;
        }
        assert (this.fStartupSucceededCounter != null) : "Startup Counter missing";
        return this.fStartupSucceededCounter.await(l, timeUnit);
    }

    private void startupSucceeded(Instance instance) {
        this.fStartupSucceededCounter.countDown(instance);
        if (this.hasSessionStarted()) {
            this.fOnSessionStartupComplete.run();
        }
    }

    private void initSessionServices() {
        this.fErrorHandler = new FatalErrorHandler(this.fIsClient);
        this.fListenerExec = FixedThreadPool.create(1);
        this.fReturnMessageRegistry = ReturnMessageDispatcherImpl.create(this.fListenerExec, this.fErrorHandler);
        this.fResourceManager = new ResourceManagerImpl();
    }

    private void initSession(Connection[] connectionArray, ProcessInstance[] processInstanceArray, ProcessInstance processInstance) {
        block9: {
            DispatcherImpl dispatcherImpl;
            Session session;
            block8: {
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Initializing session.");
                session = this;
                try {
                    this.fCommGroup = CommunicationGroup.build(this.fErrorHandler, this.fReturnMessageRegistry, connectionArray, processInstanceArray, processInstance);
                }
                catch (Exception exception) {
                    PackageInfo.LOGGER.log(DistcompLevel.THREE, "Failed to build CommunicationGroup", exception);
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError((Object)"Failed to build comm group");
                }
            }
            ClosableSessionConnections closableSessionConnections = new ClosableSessionConnections(){

                @Override
                public void run(SessionShutdownEvent sessionShutdownEvent) {
                    Session.this.closeIOStopExecutors(sessionShutdownEvent);
                }
            };
            this.fClient = null;
            this.fLabs = null;
            this.fSpmdExec = null;
            this.fDispatcher = dispatcherImpl = DispatcherImpl.create();
            dispatcherImpl.addDispatcher(this.fReturnMessageRegistry.getDispatcher());
            dispatcherImpl.addDispatcher(new DispatchableMessageDispatcherImpl());
            if (this.fIsClient) {
                this.fShutdownHandler = new ClientShutdownHandlerImpl(session, this.fCommGroup, closableSessionConnections);
                this.fMExec = new ClientMExecutorImpl();
                this.fLabs = LabsImpl.create(session, this.fCommGroup);
                this.fStartupSucceededCounter = new ObjectCountDownLatch(this.getPoolSize() + 1);
            } else {
                this.fShutdownHandler = LabShutdownHandlerImpl.create(session, this.fCommGroup, closableSessionConnections);
                this.fMExec = new LabMExecutorImpl(this.fCommGroup);
                this.fClient = ClientImpl.create(session, this.fCommGroup);
                this.fSpmdExec = new SpmdExecutorImpl(this.fCommGroup);
                dispatcherImpl.addDispatcher(this.fSpmdExec);
                this.fStartupSucceededCounter = new ObjectCountDownLatch(2);
            }
            dispatcherImpl.addDispatcher(this.fMExec);
            dispatcherImpl.addDispatcher(this.fShutdownHandler);
            this.fTransfer = new Transfer(session, this.fCommGroup);
            dispatcherImpl.addDispatcher(this.fTransfer.getTransferManager());
            dispatcherImpl.addDispatcher(new SessionMessageDispatcherImpl());
            this.fPathNotificationListener = new PathNotificationListener(this.fCommGroup);
            this.fDispatcherExec = FixedThreadPool.create(1);
            try {
                this.fCommGroup.setDispatcher(this.fDispatcher, this.fDispatcherExec);
            }
            catch (Exception exception) {
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Failed to set dispatcher for comm group", exception);
                if ($assertionsDisabled) break block9;
                throw new AssertionError((Object)"Failed to set dispatcher for CommunicationGroup");
            }
        }
        this.fErrorHandler.activate(this.fShutdownHandler);
        this.fOnSessionStartupComplete = new RunCallableOnce(new Runnable(){

            @Override
            public void run() {
                Session.this.fShutdownHandler.sessionStartupComplete();
            }
        });
        if (this.fIsClient) {
            this.fCommGroup.sendToAll(new ClientStartupSucceeded());
            this.startupSucceeded(ProcessInstance.getThisProcess());
        } else {
            MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
            CompletionObserver completionObserver = new CompletionObserver(){

                public void completed(int n, Object object) {
                    if (Session.this.isSessionRunning()) {
                        Session.this.fCommGroup.sendTo(ProcessInstance.getClientInstance(), new LabStartupSucceeded());
                        Session.this.startupSucceeded(ProcessInstance.getThisProcess());
                    }
                }
            };
            matlabMCR.eval(";", completionObserver);
        }
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Initialization complete.");
    }

    private int getNumIOThreads(int n) {
        return (int)Math.min((double)n, 1.0 + Math.floor(Math.sqrt(n)));
    }

    private void closeIOStopExecutors(SessionShutdownEvent sessionShutdownEvent) {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "In closeIOStopExecutors with event data: " + (Object)((Object)sessionShutdownEvent.getShutdownState()));
        try {
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Unregister PathNotificationListener.");
            this.fPathNotificationListener.unregister();
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when unregistering fPathNotificationListener.", throwable);
        }
        try {
            if (this.fListenerExec != null) {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Stopping fListenerExec.");
                this.fListenerExec.destroy();
            }
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when stopping fInputExec.", throwable);
        }
        try {
            if (this.fDispatcherExec != null) {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Stopping fDispatcherExec.");
                this.fDispatcherExec.destroy();
            }
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when stopping fDispatcherExec.", throwable);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fCommGroup.");
            this.fCommGroup.closeStreams();
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing fCommGroup.", throwable);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fMExec.");
            this.fMExec.destroy();
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing M executor.", throwable);
        }
        try {
            if (this.fSpmdExec != null) {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fSpmdExec.");
                this.fSpmdExec.destroy();
            }
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing SPMD executor.", throwable);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fTransfer.");
            this.fTransfer.destroy();
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing transfer object.", throwable);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fReturnMessageRegistry.");
            this.fReturnMessageRegistry.destroy();
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing ReturnMessageRegistry object.", throwable);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Firing SessionEndedEvent listeners.");
            this.notifySessionEnded(sessionShutdownEvent);
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when Firing SessionEndedEvent listeners.", throwable);
        }
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Closed IO, Executors and MExecutor.");
    }

    private class DispatchableMessageDispatcherImpl
    implements Dispatcher<DispatchableMessage> {
        private DispatchableMessageDispatcherImpl() {
        }

        @Override
        public void dispatch(DispatchableMessage dispatchableMessage, Instance instance) {
            dispatchableMessage.dispatch(Session.this.fCommGroup, instance, Session.this);
        }
    }

    private class SessionMessageDispatcherImpl
    implements Dispatcher<SessionMessage> {
        private SessionMessageDispatcherImpl() {
        }

        @Override
        public void dispatch(SessionMessage sessionMessage, Instance instance) {
            if (sessionMessage instanceof StartupSucceeded) {
                if (sessionMessage instanceof ClientStartupSucceeded) {
                    assert (!Session.this.fIsClient) : "Received a ClientStartupSucceeded message on a client";
                } else if (sessionMessage instanceof LabStartupSucceeded) assert (Session.this.fIsClient) : "Received a StartupACKFromLab on a lab.";
                Session.this.startupSucceeded(instance);
            } else assert (false) : "Received an unexpected class " + sessionMessage.getClass().getName();
        }
    }

    private static interface SessionEndedEventDispatcher {
        public void dispatch(SessionListener var1);
    }
}

