/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.DebugUtils;
import com.mathworks.toolbox.distcomp.pmode.FevalLargeDataResult;
import com.mathworks.toolbox.distcomp.pmode.MatlabOutputWriters;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionConstants;
import com.mathworks.toolbox.distcomp.pmode.SpmdBlock;
import com.mathworks.toolbox.distcomp.pmode.SpmdBlockResult;
import com.mathworks.toolbox.distcomp.pmode.SpmdExecutor;
import com.mathworks.toolbox.distcomp.pmode.SpmdExecutorCommand;
import com.mathworks.toolbox.distcomp.pmode.SpmdInterrupt;
import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;

public class SpmdExecutorImpl
implements SpmdExecutor {
    private CommunicationGroup fCommGroup;
    private MatlabMCR fMCR;
    private AtomicBoolean fIsAlive;
    private Semaphore fInterruptProgress;
    private BlockProperties fBlockProperties;
    private ExecutorState fState;

    public SpmdExecutorImpl(CommunicationGroup communicationGroup) {
        this.fCommGroup = communicationGroup;
        this.fMCR = MatlabRefStore.getMatlabRef();
        this.fIsAlive = new AtomicBoolean(true);
        this.fInterruptProgress = new Semaphore(0);
        this.fBlockProperties = null;
        this.fState = ExecutorState.IDLE;
    }

    @Override
    public void dispatch(SpmdExecutorCommand spmdExecutorCommand, Instance instance) {
        if (spmdExecutorCommand instanceof SpmdBlock) {
            this.execute((SpmdBlock)spmdExecutorCommand);
        } else if (spmdExecutorCommand instanceof SpmdInterrupt) {
            this.interrupt((SpmdInterrupt)spmdExecutorCommand);
        }
    }

    private synchronized ExecutorState moveToState(ExecutorState executorState) {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "SPMD Starting move to state: " + (Object)((Object)executorState) + " from " + (Object)((Object)this.fState));
        ExecutorState executorState2 = this.fState;
        this.fState = executorState;
        return executorState2;
    }

    private synchronized BlockProperties moveToPrelude(SpmdBlock spmdBlock) {
        ExecutorState executorState = this.moveToState(ExecutorState.EXECUTING_PRELUDE);
        assert (executorState == ExecutorState.IDLE) : "Bad IDLE->PRELUDE state progression";
        this.fBlockProperties = new BlockProperties(spmdBlock);
        return this.fBlockProperties;
    }

    private synchronized boolean moveToBody(BlockProperties blockProperties) {
        ExecutorState executorState = this.moveToState(ExecutorState.EXECUTING_BODY);
        assert (executorState == ExecutorState.EXECUTING_PRELUDE) : "Bad PRELUDE->BODY state progression";
        return blockProperties.isInterruptReceived();
    }

    private synchronized boolean moveToWaiting(BlockProperties blockProperties) {
        ExecutorState executorState = this.moveToState(ExecutorState.WAITING_FOR_INTERRUPT_COMPLETION);
        assert (executorState == ExecutorState.EXECUTING_BODY) : "Bad BODY->WAITING_FOR_INTERRUPT state progression";
        return blockProperties.isInterruptReceived();
    }

    private synchronized void moveToCleanup() {
        ExecutorState executorState = this.moveToState(ExecutorState.EXECUTING_CLEANUP);
        assert (executorState == ExecutorState.WAITING_FOR_INTERRUPT_COMPLETION) : "Bad BODY->CLEANUP state progression";
    }

    private synchronized void moveToIdle() {
        ExecutorState executorState = this.moveToState(ExecutorState.IDLE);
        assert (executorState == ExecutorState.EXECUTING_CLEANUP) : "Bad CLEANUP->IDLE state progression";
        this.fBlockProperties = null;
    }

    @Override
    public void execute(SpmdBlock spmdBlock) {
        assert (this.fIsAlive.get()) : "Received block to execute after destroy()";
        assert (this.fInterruptProgress.availablePermits() == 0) : "Invalid number of interrupt permits";
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor executing: " + spmdBlock.getSequenceNumber());
        BlockProperties blockProperties = this.moveToPrelude(spmdBlock);
        this.triggerPrelude(blockProperties);
    }

    private void triggerPrelude(final BlockProperties blockProperties) {
        CompletionObserver completionObserver = new CompletionObserver(){

            public void completed(int n, Object object) {
                SpmdExecutorImpl.this.triggerBody(blockProperties);
            }
        };
        blockProperties.getWriters().start();
        this.fMCR.fevalConsoleOutput(SessionConstants.sSPMD_BLOCK_EXECUTION, blockProperties.getBlock().getPreludeArgs(SessionConstants.sSPMD_BLOCK_PRELUDE_ARG), SessionConstants.sSPMD_BLOCK_BODY_NARGOUT, completionObserver);
    }

    private void triggerBody(final BlockProperties blockProperties) {
        CompletionObserver completionObserver = new CompletionObserver(){

            public void completed(int n, Object object) {
                final boolean bl = SpmdExecutorImpl.this.moveToWaiting(blockProperties);
                SpmdBlockResult spmdBlockResult = SpmdExecutorImpl.this.buildBlockResult(blockProperties.getSequenceNumber(), n, object, bl);
                if (spmdBlockResult.isError()) {
                    SpmdExecutorImpl.this.fCommGroup.returnTo(blockProperties.getBlock().getSourceProcess(), spmdBlockResult);
                    blockProperties.getWriters().stop();
                } else {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD skipping return of SpmdBlockResult - nothing interesting - interrupted? " + bl);
                }
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        if (bl) {
                            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD waiting for interrupt completion...");
                            try {
                                SpmdExecutorImpl.this.fInterruptProgress.acquire();
                            }
                            catch (InterruptedException interruptedException) {
                                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD interrupted while waiting", interruptedException);
                            }
                        }
                        SpmdExecutorImpl.this.triggerCleanup(blockProperties);
                    }
                };
                thread.start();
            }
        };
        boolean bl = this.moveToBody(blockProperties);
        if (bl) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD already interrupted, skipping body");
            blockProperties.getWriters().stop();
            this.moveToWaiting(blockProperties);
            this.triggerCleanup(blockProperties);
        } else {
            this.fMCR.fevalConsoleOutput(SessionConstants.sSPMD_BLOCK_EXECUTION, new Object[]{SessionConstants.sSPMD_BLOCK_EXECUTION_ARG}, SessionConstants.sSPMD_BLOCK_BODY_NARGOUT, completionObserver);
        }
    }

    private SpmdBlockResult buildBlockResult(long l, int n, Object object, boolean bl) {
        if (bl) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD Block was interrupted - building 'no error' result");
            return SpmdBlockResult.NO_ERROR_RESULT;
        }
        if (n != 0) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Non-zero execution status - definitely a problem: " + n);
            return new SpmdBlockResult(l, true, null);
        }
        try {
            Object[] objectArray = (Object[])object;
            boolean[] blArray = (boolean[])objectArray[0];
            boolean bl2 = !blArray[0];
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD build block result - Got error? " + bl2);
            return new SpmdBlockResult(l, bl2, objectArray[1]);
        }
        catch (Exception exception) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "An error occurred extracting error info", exception);
            return new SpmdBlockResult(l, true, null);
        }
    }

    private void triggerCleanup(final BlockProperties blockProperties) {
        assert (this.fIsAlive.get()) : "Attempt to cleanup after destroy()";
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor cleanup: " + blockProperties.getSequenceNumber());
        this.moveToCleanup();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor cleanup, state changed");
        CompletionObserver completionObserver = new CompletionObserver(){

            public void completed(int n, Object object) {
                blockProperties.getWriters().stop();
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor cleanup completed with status: " + n);
                FevalLargeDataResult fevalLargeDataResult = new FevalLargeDataResult(n, object, SessionConstants.sSPMD_BLOCK_BODY_NARGOUT, blockProperties.getSequenceNumber());
                SpmdExecutorImpl.this.moveToIdle();
                SpmdExecutorImpl.this.fCommGroup.returnTo(blockProperties.getBlock().getSourceProcess(), fevalLargeDataResult);
            }
        };
        this.fMCR.fevalConsoleOutput(SessionConstants.sSPMD_BLOCK_EXECUTION, new Object[]{SessionConstants.sSPMD_BLOCK_CLEANUP_ARG}, SessionConstants.sSPMD_BLOCK_BODY_NARGOUT, completionObserver);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor cleanup, feval sent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt(final SpmdInterrupt spmdInterrupt) {
        assert (this.fIsAlive.get()) : "Received interrupt after destroy()";
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            if (this.fBlockProperties != null) {
                this.fBlockProperties.setInterruptReceived(true);
            }
            switch (this.fState) {
                case IDLE: {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor ignoring received interrupt after block completion");
                    break;
                }
                case EXECUTING_PRELUDE: {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor received interrupt during prelude, no action taken, block should be skipped");
                    break;
                }
                case EXECUTING_BODY: {
                    assert (this.fBlockProperties != null) : "Should have valid fBlockProperties";
                    assert (this.fBlockProperties.getSequenceNumber() == spmdInterrupt.getBlockSequence()) : "Wrong interrupt sequence: received " + spmdInterrupt.getBlockSequence() + " while executing " + this.fBlockProperties.getSequenceNumber();
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor received interrupt during block, will interrupt");
                    bl = true;
                    break;
                }
                case WAITING_FOR_INTERRUPT_COMPLETION: 
                case EXECUTING_CLEANUP: {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor ignoring received during cleanup");
                    break;
                }
                default: {
                    assert (false) : "Unexpectedly fell through state selection";
                    break;
                }
            }
        }
        if (bl) {
            object = new CompletionObserver(){

                public void completed(int n, Object object) {
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, "SpmdInterrupt successfully completed, returning to: " + spmdInterrupt.getSourceProcess());
                    SpmdExecutorImpl.this.fInterruptProgress.release();
                }
            };
            SpmdExecutorImpl spmdExecutorImpl = this;
            synchronized (spmdExecutorImpl) {
                this.fBlockProperties.getWriters().stop();
            }
            DebugUtils.interruptMatlabClearDebugStateUseMwmpi((CompletionObserver)object);
        }
    }

    @Override
    public void destroy() {
        boolean bl = this.fIsAlive.getAndSet(false);
        assert (bl) : "2nd call to destroy";
    }

    private final class BlockWriters
    implements MatlabOutputWriters.MatlabOutputListener {
        private long fSequence;
        private Instance fProcess;
        private boolean fStopped = false;

        private BlockWriters(long l, Instance instance) {
            this.fSequence = l;
            this.fProcess = instance;
        }

        public void start() {
            MatlabOutputWriters.getInstance().flushAllPendingOutputNoException();
            MatlabOutputWriters.getInstance().addOutputListener(this);
        }

        public void stop() {
            if (!this.fStopped) {
                MatlabOutputWriters.getInstance().flushAllPendingOutputNoException();
                MatlabOutputWriters.getInstance().removeOutputListener(this);
                this.fStopped = true;
            }
        }

        @Override
        public void stdout(String string) {
            this.sendCommandOutput(string);
        }

        @Override
        public void stderr(String string) {
            this.sendCommandOutput(string);
        }

        private void sendCommandOutput(String string) {
            assert (SpmdExecutorImpl.this.fCommGroup != null) : "Unable to return command output if the return group is null";
            MatlabOutputWriters.returnCommandOutput(string, SpmdExecutorImpl.this.fCommGroup, this.fSequence, this.fProcess);
        }
    }

    private final class BlockProperties {
        private final SpmdBlock fSpmdBlock;
        private final BlockWriters fWriters;
        private boolean fInterruptReceived;

        private BlockProperties(SpmdBlock spmdBlock) {
            this.fSpmdBlock = spmdBlock;
            this.fWriters = new BlockWriters(spmdBlock.getSequenceNumber(), spmdBlock.getSourceProcess());
            this.fInterruptReceived = false;
        }

        public SpmdBlock getBlock() {
            return this.fSpmdBlock;
        }

        public synchronized boolean isInterruptReceived() {
            return this.fInterruptReceived;
        }

        public synchronized boolean setInterruptReceived(boolean bl) {
            boolean bl2 = this.fInterruptReceived;
            this.fInterruptReceived = bl;
            return bl2;
        }

        public BlockWriters getWriters() {
            return this.fWriters;
        }

        public long getSequenceNumber() {
            return this.fSpmdBlock.getSequenceNumber();
        }
    }

    static enum ExecutorState {
        IDLE,
        EXECUTING_PRELUDE,
        EXECUTING_BODY,
        WAITING_FOR_INTERRUPT_COMPLETION,
        EXECUTING_CLEANUP;

    }
}

