/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.io.ConnectionManager;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolAcceptor;
import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolPeerInstance;
import com.mathworks.toolbox.distcomp.pmode.io.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredActiveAcceptor;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;

final class MatlabPoolBrokeredAcceptor
extends MatlabPoolAcceptor {
    private final BrokeredActiveAcceptor fBrokeredActiveAcceptor;
    private MatlabPoolPeerInstance fLocalPeer;

    MatlabPoolBrokeredAcceptor(MatlabPoolPeerInstance matlabPoolPeerInstance, BrokeredAcceptInfo brokeredAcceptInfo) throws PeerMessagingException, InterruptedException {
        this.fLocalPeer = matlabPoolPeerInstance;
        this.fBrokeredActiveAcceptor = BrokeredActiveAcceptor.createBrokeredActiveAcceptor(matlabPoolPeerInstance, brokeredAcceptInfo);
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "ConnectionManager (" + this.fLocalPeer + ") constructed.");
    }

    @Override
    ConnectInfo getInfoToConnect() {
        return this.fBrokeredActiveAcceptor.getInfoToConnect();
    }

    @Override
    ConnectionManager.ConnectionAndNumberOfLabs activelyAccept() {
        try {
            Connection connection = this.fBrokeredActiveAcceptor.activelyAccept();
            if (connection != null) {
                int n = ((MatlabPoolPeerInstance)connection.getRemoteInstance()).getNumberOfLabs();
                connection.switchToMatlabPoolProcessInstance();
                return new ConnectionManager.ConnectionAndNumberOfLabs(connection, n);
            }
            return null;
        }
        catch (PeerMessagingException peerMessagingException) {
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "activelyAccept() caught " + peerMessagingException.getMessage(), peerMessagingException);
            return null;
        }
    }

    @Override
    void close() {
        this.fBrokeredActiveAcceptor.close();
    }

    public String toString() {
        return "MatlabPoolBrokeredAcceptor{, fLocalPeer=" + this.fLocalPeer + ", fBrokeredActiveAcceptor=" + this.fBrokeredActiveAcceptor + '}';
    }
}

