/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io.broker;

import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerClientInfo;
import com.mathworks.toolbox.distcomp.pmode.io.broker.Log;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerConnector;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerDispatcher;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSession;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSessionFatalErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.ProtocolId;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

final class BrokerPeerSessionFactory {
    private BrokerPeerSessionFactory() {
    }

    static PeerInstance createPeerOfBroker(BrokerClientInfo brokerClientInfo) {
        UUID uUID = UUID.randomUUID();
        Log.LOGGER.finest("brokerConnectInfo is " + brokerClientInfo.getConnectToBrokerInfo());
        UUID uUID2 = brokerClientInfo.getConnectToBrokerInfo().getGroupUUID();
        PeerInstance peerInstance = new PeerInstance(ProtocolId.MJS, uUID2, uUID);
        return peerInstance;
    }

    static Connection createConnectionToBroker(PeerInstance peerInstance, BrokerClientInfo brokerClientInfo, String string) throws PeerMessagingException {
        Log.LOGGER.finest(string + ": Local peer id with broker is " + peerInstance.getUuid());
        PeerConnector peerConnector = new PeerConnector();
        Connection connection = peerConnector.activelyConnectTo(brokerClientInfo.getConnectToBrokerInfo(), brokerClientInfo.getBrokerConnectInterval(), brokerClientInfo.getBrokerConnectTimeout(), peerInstance);
        Log.LOGGER.fine(string + ": Connected to broker " + brokerClientInfo + " via " + connection);
        return connection;
    }

    static PeerSession createPeerSessionWithBroker(PeerInstance peerInstance, Connection connection, String string) {
        PeerSessionFatalErrorHandler peerSessionFatalErrorHandler = new PeerSessionFatalErrorHandler();
        HashSet<Connection> hashSet = new HashSet<Connection>();
        hashSet.add(connection);
        Set<PeerDispatcher<? extends Message>> set = Collections.emptySet();
        PeerSession peerSession = new PeerSession(peerInstance, peerSessionFatalErrorHandler, set, hashSet);
        Log.LOGGER.finest(string + ":Created session " + peerSession);
        return peerSession;
    }
}

