/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io.broker;

import com.mathworks.toolbox.distcomp.pmode.shared.ConnectionFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.SSLConnectionFactory;
import java.io.Serializable;
import javax.net.ssl.SSLContext;

public class BrokeredConnectorSSLSecurityDescription
implements ConnectorSecurityDescription,
Serializable {
    private final transient SSLContext fSSLContext;
    private final transient boolean fUseClientMode;

    public BrokeredConnectorSSLSecurityDescription(SSLContext sSLContext, boolean bl) {
        this.fSSLContext = sSLContext;
        this.fUseClientMode = bl;
    }

    @Override
    public ConnectionFactory createConnectionFactoryForConnector() {
        return new SSLConnectionFactory(this.fSSLContext, this.fUseClientMode);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BrokeredConnectorSSLSecurityDescription brokeredConnectorSSLSecurityDescription = (BrokeredConnectorSSLSecurityDescription)object;
        if (this.fUseClientMode != brokeredConnectorSSLSecurityDescription.fUseClientMode) {
            return false;
        }
        return !(this.fSSLContext != null ? !this.fSSLContext.equals(brokeredConnectorSSLSecurityDescription.fSSLContext) : brokeredConnectorSSLSecurityDescription.fSSLContext != null);
    }

    public int hashCode() {
        int n = this.fSSLContext != null ? this.fSSLContext.hashCode() : 0;
        n = 31 * n + (this.fUseClientMode ? 1 : 0);
        return n;
    }

    public String toString() {
        return "BrokeredConnectorSSLSecurityDescription{fUseClientMode=" + this.fUseClientMode + '}';
    }
}

