/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.AbstractPeerAcceptor;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.HandShake;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public final class PeerActiveAcceptor
extends AbstractPeerAcceptor {
    public PeerActiveAcceptor(String string, Instance instance, ServerSocketAcceptInfo serverSocketAcceptInfo) throws AbstractPeerAcceptor.InitializeServerSocketChannelException {
        super(string, instance, serverSocketAcceptInfo);
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "PeerActiveAcceptor (" + instance + ") constructed.");
    }

    private Connection acceptAndConfigureConnection() throws AbstractPeerAcceptor.CouldNotConfigureSocketChannelException, HandShake.HandShakeException, CouldNotAcceptException {
        SocketChannel socketChannel;
        try {
            socketChannel = this.getServerSocketChannel().accept();
        }
        catch (IOException iOException) {
            throw new CouldNotAcceptException(this.getServerSocketChannel(), iOException);
        }
        if (socketChannel != null) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Did accept() : " + socketChannel);
            try {
                return this.createConnection(socketChannel);
            }
            catch (AbstractPeerAcceptor.CouldNotConfigureSocketChannelException couldNotConfigureSocketChannelException) {
                this.safeClose(socketChannel, couldNotConfigureSocketChannelException);
                throw couldNotConfigureSocketChannelException;
            }
            catch (HandShake.HandShakeException handShakeException) {
                this.safeClose(socketChannel, handShakeException);
                throw handShakeException;
            }
            catch (RuntimeException runtimeException) {
                this.safeClose(socketChannel, runtimeException);
                throw runtimeException;
            }
        }
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "accept() returned null instead of a SocketChannel.");
        return null;
    }

    private void safeClose(SocketChannel socketChannel, Exception exception) {
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Closing socket " + socketChannel + " because we caught an exception during bootstrap.", exception);
            socketChannel.close();
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Exception while closing socketChannel " + socketChannel.socket(), iOException);
        }
    }

    public Connection activelyAccept() {
        try {
            return this.acceptAndConfigureConnection();
        }
        catch (Exception exception) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Unexpected exception within activelyAccept()", exception);
            return null;
        }
    }

    public Connection activelyAccept(long l, long l2) throws PeerMessagingException {
        long l3;
        assert (l > 0L) : "poll interval must be greater than 0 but is " + l;
        assert (l2 > 0L) : "timeout must be greater than 0 but is " + l2;
        assert (l <= l2) : "poll interval " + l + " is greater than timeout " + l2 + ". It'll still try twice.";
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Starting to poll on accept every " + l + " ms for " + l2 + " ms");
        long l4 = System.currentTimeMillis();
        PeerMessagingException peerMessagingException = null;
        do {
            try {
                Connection connection = this.acceptAndConfigureConnection();
                if (connection != null) {
                    return connection;
                }
            }
            catch (PeerMessagingException peerMessagingException2) {
                if (peerMessagingException == null) {
                    peerMessagingException = peerMessagingException2;
                }
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyAccept() caught exception", peerMessagingException2);
            }
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new ActivelyAcceptInterruptedException(this.getServerSocketChannel(), interruptedException);
            }
        } while (l2 > (l3 = System.currentTimeMillis()) - l4);
        try {
            return this.acceptAndConfigureConnection();
        }
        catch (PeerMessagingException peerMessagingException3) {
            if (peerMessagingException == null) {
                peerMessagingException = peerMessagingException3;
            }
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyAccept() caught exception", peerMessagingException3);
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to accept after " + l2 + " ms");
            throw peerMessagingException;
        }
    }

    public String toString() {
        return "[PeerActiveAcceptor for: " + this.getLocalPeerInstance() + " with ServerSocketChannel: " + this.getServerSocketChannel() + "]";
    }

    private static final class ActivelyAcceptInterruptedException
    extends PeerMessagingException {
        private final InetSocketAddress fLocalSocketAddress;

        private ActivelyAcceptInterruptedException(ServerSocketChannel serverSocketChannel, InterruptedException interruptedException) {
            super(AbstractPeerAcceptor.AbstractPeerAcceptorErrorCode.ActivelyAcceptInterruptedException, interruptedException);
            this.fLocalSocketAddress = (InetSocketAddress)serverSocketChannel.socket().getLocalSocketAddress();
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.fLocalSocketAddress, this.getCause().getLocalizedMessage()};
        }
    }

    private static final class CouldNotAcceptException
    extends PeerMessagingException {
        private final InetSocketAddress fLocalSocketAddress;

        private CouldNotAcceptException(ServerSocketChannel serverSocketChannel, IOException iOException) {
            super(AbstractPeerAcceptor.AbstractPeerAcceptorErrorCode.CouldNotAcceptException, iOException);
            this.fLocalSocketAddress = (InetSocketAddress)serverSocketChannel.socket().getLocalSocketAddress();
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.fLocalSocketAddress, this.getCause().getLocalizedMessage()};
        }
    }
}

