/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.util.concurrent.DaemonThreadFactory;
import com.mathworks.toolbox.distcomp.util.i18n.BundleKey;
import com.mathworks.toolbox.distcomp.util.i18n.HasI18nMatlabErrorId;
import com.mathworks.toolbox.distcomp.util.i18n.I18NMatlabMessage;
import com.mathworks.toolbox.distcomp.util.i18n.MessageGenerator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public final class PeerSessionFatalErrorHandler
implements ErrorHandler {
    private final ExecutorService fShutdownExecutor;
    private final AtomicBoolean fIsShuttingDown = new AtomicBoolean(false);
    private ShutdownHandler fShutdownHandler = null;
    private boolean fHasBeenDeactivated = false;
    private boolean fHasError = false;
    private FatalError fError;

    public PeerSessionFatalErrorHandler(ExecutorService executorService) {
        this.fShutdownExecutor = executorService;
    }

    public PeerSessionFatalErrorHandler() {
        this.fShutdownExecutor = Executors.newSingleThreadExecutor(new DaemonThreadFactory(this.getClass().getSimpleName() + " fShutdownExecutor"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readError(Instance instance, Throwable throwable) {
        String string;
        ShutdownHandler shutdownHandler;
        PeerSessionFatalErrorHandler peerSessionFatalErrorHandler = this;
        synchronized (peerSessionFatalErrorHandler) {
            if (this.fHasError || this.fHasBeenDeactivated) {
                return;
            }
            this.fHasError = true;
            shutdownHandler = this.fShutdownHandler;
            this.fError = new FatalError(FatalErrorHandlerI18NText.ReadError, throwable, instance);
            string = this.fError.getMessage();
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, string);
        if (shutdownHandler != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Read error, forcing a shutdown.");
            this.tryShutdown(shutdownHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeError(Instance instance, Throwable throwable) {
        String string;
        ShutdownHandler shutdownHandler;
        PeerSessionFatalErrorHandler peerSessionFatalErrorHandler = this;
        synchronized (peerSessionFatalErrorHandler) {
            if (this.fHasError || this.fHasBeenDeactivated) {
                return;
            }
            this.fHasError = true;
            shutdownHandler = this.fShutdownHandler;
            this.fError = new FatalError(FatalErrorHandlerI18NText.WriteError, throwable, instance);
            string = this.fError.getMessage();
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, string);
        if (shutdownHandler != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Write error, forcing a shutdown.");
            this.tryShutdown(shutdownHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lostCommunication(Instance instance, Throwable throwable) {
        String string;
        ShutdownHandler shutdownHandler;
        PeerSessionFatalErrorHandler peerSessionFatalErrorHandler = this;
        synchronized (peerSessionFatalErrorHandler) {
            if (this.fHasError || this.fHasBeenDeactivated) {
                return;
            }
            this.fHasError = true;
            shutdownHandler = this.fShutdownHandler;
            this.fError = new FatalError(FatalErrorHandlerI18NText.LostConnection, throwable, instance);
            string = this.fError.getMessage();
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, string);
        if (shutdownHandler != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Lost communication, forcing a shutdown.");
            this.tryShutdown(shutdownHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executorError(Throwable throwable) {
        String string;
        ShutdownHandler shutdownHandler;
        PeerSessionFatalErrorHandler peerSessionFatalErrorHandler = this;
        synchronized (peerSessionFatalErrorHandler) {
            if (this.fHasError || this.fHasBeenDeactivated) {
                return;
            }
            this.fHasError = true;
            shutdownHandler = this.fShutdownHandler;
            this.fError = new FatalError(FatalErrorHandlerI18NText.InternalRuntimeError, throwable, new Object[0]);
            string = this.fError.getMessage();
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, string);
        if (shutdownHandler != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Executor error, forcing a shutdown.");
            this.tryShutdown(shutdownHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate(ShutdownHandler shutdownHandler) {
        PeerSessionFatalErrorHandler peerSessionFatalErrorHandler = this;
        synchronized (peerSessionFatalErrorHandler) {
            if (!this.fHasError) {
                assert (!this.fHasBeenDeactivated) : "Attempt to activate a handler after it has been deactivated";
                this.fShutdownHandler = shutdownHandler;
                return;
            }
        }
        if (shutdownHandler != null) {
            this.tryShutdown(shutdownHandler);
        }
    }

    @Override
    public synchronized void deactivate() {
        this.fShutdownHandler = null;
        this.fHasBeenDeactivated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryShutdown(final ShutdownHandler shutdownHandler) {
        FatalError fatalError;
        assert (shutdownHandler != null) : "Shutdown handler was null during a call to tryShutdown";
        if (this.fIsShuttingDown.getAndSet(true)) {
            return;
        }
        PeerSessionFatalErrorHandler peerSessionFatalErrorHandler = this;
        synchronized (peerSessionFatalErrorHandler) {
            assert (this.fHasError) : "tryShutdown was called without an error";
            fatalError = this.fError;
        }
        this.fShutdownExecutor.execute(new Runnable(){

            @Override
            public void run() {
                shutdownHandler.forceShutdown(fatalError);
            }
        });
        this.fShutdownExecutor.shutdown();
    }

    public static final class FatalError
    implements I18NMatlabMessage,
    Serializable {
        private final FatalErrorHandlerI18NText fErrorText;
        private final Throwable fCause;
        private final Object[] fMessageArguments;

        public FatalError(FatalErrorHandlerI18NText fatalErrorHandlerI18NText, Throwable throwable, Object ... objectArray) {
            this.fErrorText = fatalErrorHandlerI18NText;
            this.fMessageArguments = objectArray;
            this.fCause = throwable;
        }

        @Override
        public String getLocalizedMessage() {
            String string = this.fErrorText.createLocalizedMessage(this.fMessageArguments);
            if (null != this.fCause && this.fCause instanceof HasI18nMatlabErrorId) {
                string = string + " " + FatalErrorHandlerI18NText.FatalErrorCauseClause.createLocalizedMessage(this.fCause.getLocalizedMessage());
            }
            return string;
        }

        @Override
        public String getMessage() {
            String string = this.fErrorText.createMessage(this.fMessageArguments);
            if (null != this.fCause && this.fCause instanceof HasI18nMatlabErrorId) {
                string = string + " " + FatalErrorHandlerI18NText.FatalErrorCauseClause.createMessage(this.fCause.getLocalizedMessage());
            }
            return string;
        }

        @Override
        public String getMatlabErrorId() {
            return this.fErrorText.getMatlabErrorId();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FatalError fatalError = (FatalError)object;
            if (this.fCause != null ? !this.fCause.equals(fatalError.fCause) : fatalError.fCause != null) {
                return false;
            }
            if (this.fErrorText != fatalError.fErrorText) {
                return false;
            }
            return Arrays.equals(this.fMessageArguments, fatalError.fMessageArguments);
        }

        public int hashCode() {
            int n = this.fErrorText.hashCode();
            n = 31 * n + (this.fCause != null ? this.fCause.hashCode() : 0);
            n = 31 * n + (this.fMessageArguments != null ? Arrays.hashCode(this.fMessageArguments) : 0);
            return n;
        }
    }

    public static enum FatalErrorHandlerI18NText implements HasI18nMatlabErrorId,
    Serializable
    {
        FatalErrorCauseClause,
        LostConnection,
        ReadError,
        WriteError,
        InternalRuntimeError;

        private static final String RESOURCE_BASE_NAME = "com.mathworks.toolbox.distcomp.pmode.peermessaging.resources.RES_peermessaging";
        private static final String RESOURCE_BUNDLE_KEY_PREFIX = "parallel.peermessaging.";
        private static final String MATLAB_ERROR_ID_PREFIX = "parallel:peermessaging:";

        @Override
        public String getMatlabErrorId() {
            return MATLAB_ERROR_ID_PREFIX + this.toString();
        }

        @Override
        public String getResourceBundleName() {
            return RESOURCE_BASE_NAME;
        }

        @Override
        public String getBundleKey() {
            return RESOURCE_BUNDLE_KEY_PREFIX + this.toString();
        }

        @Override
        public String createMessage(Object ... objectArray) {
            return MessageGenerator.createMessage((BundleKey)this, false, objectArray);
        }

        @Override
        public String createLocalizedMessage(Object ... objectArray) {
            return MessageGenerator.createLocalizedMessage(this, false, objectArray);
        }
    }
}

