/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.SSLConnectionFactory;
import com.mathworks.toolbox.distcomp.util.security.SSLContextFactory;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;

public final class ConnectorSSLSecurityDescription
implements ConnectorSecurityDescription,
Serializable {
    private final boolean fConnectorUseClientMode;
    private final Certificate fCertificate;

    public ConnectorSSLSecurityDescription(Certificate certificate, boolean bl) {
        this.fCertificate = certificate;
        this.fConnectorUseClientMode = bl;
    }

    @Override
    public SSLConnectionFactory createConnectionFactoryForConnector() {
        SSLContextFactory sSLContextFactory = new SSLContextFactory();
        SSLContext sSLContext = sSLContextFactory.createClientSSLContext(this.fCertificate);
        return new SSLConnectionFactory(sSLContext, this.fConnectorUseClientMode);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConnectorSSLSecurityDescription connectorSSLSecurityDescription = (ConnectorSSLSecurityDescription)object;
        if (this.fConnectorUseClientMode != connectorSSLSecurityDescription.fConnectorUseClientMode) {
            return false;
        }
        return this.fCertificate.equals(connectorSSLSecurityDescription.fCertificate);
    }

    public int hashCode() {
        int n = this.fConnectorUseClientMode ? 1 : 0;
        n = 31 * n + this.fCertificate.hashCode();
        return n;
    }

    public String toString() {
        String string = this.fCertificate == null ? "null" : ((X509Certificate)this.fCertificate).getSubjectX500Principal().toString();
        return "ConnectorSSLSecurityDescription{fConnectorUseClientMode=" + this.fConnectorUseClientMode + ", fCertificate=" + string + '}';
    }
}

