/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;

public class LabsResponseVector {
    private boolean[] fVec;

    public LabsResponseVector(int n) {
        assert (n > 0) : "Number of labs/sources must be > 0.";
        this.fVec = new boolean[n];
    }

    public synchronized void receivedResponse(Instance instance) {
        assert (instance instanceof ProcessInstance) : "Got a response from something other than a Process Instance";
        ProcessInstance processInstance = (ProcessInstance)instance;
        assert (processInstance.getProcessType() == ProcessInstance.ProcessType.LAB) : "Got a response from a client";
        int n = processInstance.getLabIndex() - 1;
        assert (n >= 0 && n < this.fVec.length) : "Invalid source index " + n;
        assert (!this.fVec[n]) : "Received multiple responses from source index " + n;
        this.fVec[n] = true;
    }

    public synchronized boolean hasAllResponses() {
        for (int i = 0; i < this.fVec.length; ++i) {
            if (this.fVec[i]) continue;
            return false;
        }
        return true;
    }

    public synchronized void clearAll() {
        for (int i = 0; i < this.fVec.length; ++i) {
            this.fVec[i] = false;
        }
    }

    public void waitTillHasAllResponses(int n) {
        assert (n > 0) : "Wait time must be positive.";
        long l = System.currentTimeMillis();
        long l2 = 0L;
        while (!this.hasAllResponses() && l2 <= (long)n) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l2 = System.currentTimeMillis() - l;
        }
    }
}

