/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.pmode.shared.FinalReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ObservableMessageFuture<V extends FinalReturnMessage>
implements Future<V>,
MessageObserver {
    private final CountDownLatch fCountDownLatch = new CountDownLatch(1);
    private final Class<V> fFinalReturnMessageClass;
    private V fFinalReturnMessage = null;
    private ExecutionException fExecutionException = null;

    public ObservableMessageFuture(Class<V> clazz) {
        this.fFinalReturnMessageClass = clazz;
    }

    @Override
    public boolean cancel(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.fCountDownLatch.await();
        return this.getFinalReturnMessage();
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException {
        this.fCountDownLatch.await(l, timeUnit);
        return this.getFinalReturnMessage();
    }

    private V getFinalReturnMessage() throws ExecutionException {
        if (this.fExecutionException != null) {
            throw this.fExecutionException;
        }
        return this.fFinalReturnMessage;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.fCountDownLatch.getCount() == 0L;
    }

    @Override
    public void completed(ReturnMessage returnMessage, Instance instance) {
        if (returnMessage instanceof FinalReturnMessage) {
            try {
                this.fFinalReturnMessage = (FinalReturnMessage)this.fFinalReturnMessageClass.cast(returnMessage);
            }
            catch (ClassCastException classCastException) {
                this.fExecutionException = new ExecutionException(classCastException);
            }
            this.fCountDownLatch.countDown();
        }
    }
}

