/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.transfer;

import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferCommand;
import com.mathworks.toolbox.distcomp.util.i18n.BundleKey;
import com.mathworks.toolbox.distcomp.util.i18n.HasI18nMatlabErrorId;
import com.mathworks.toolbox.distcomp.util.i18n.MessageGenerator;
import java.io.Serializable;

public final class TransferError
extends TransferCommand {
    private final String fErrorID;
    private final String fErrorMsg;
    private final TransferErrorCode fErrorCode;
    private final Serializable[] fMessageParameters;

    TransferError(long l, String string, String string2) {
        super(l);
        this.fErrorID = string;
        this.fErrorMsg = string2;
        this.fErrorCode = null;
        this.fMessageParameters = null;
    }

    TransferError(long l, TransferErrorCode transferErrorCode, Serializable ... serializableArray) {
        super(l);
        this.fErrorID = null;
        this.fErrorMsg = null;
        this.fErrorCode = transferErrorCode;
        this.fMessageParameters = serializableArray;
    }

    public String getErrorIdentifier() {
        if (null != this.fErrorCode) {
            return this.fErrorCode.getMatlabErrorId();
        }
        return this.fErrorID;
    }

    public String getErrorMessage() {
        if (null != this.fErrorCode) {
            return this.fErrorCode.createLocalizedMessage(this.fMessageParameters);
        }
        return this.fErrorMsg;
    }

    public static TransferError getSessionDestroyedError(long l) {
        return new TransferError(l, TransferErrorCode.SessionDestroyed, new Serializable[0]);
    }

    public static TransferError getLabsUnexpectedError(long l, ProcessInstance processInstance, String string) {
        return new TransferError(l, TransferErrorCode.UnexpectedTransferError, new Serializable[]{processInstance, string});
    }

    public static TransferError getLabsInterruptedError(long l) {
        return new TransferError(l, TransferErrorCode.LabTransferInterrupted, new Serializable[0]);
    }

    public static TransferError getTransferAlreadyCancelled(long l) {
        return new TransferError(l, TransferErrorCode.TransferCancelled, new Serializable[0]);
    }

    public static TransferError getRemoteIsAhead(long l) {
        return new TransferError(l, TransferErrorCode.RemoteEndAlreadyHalted, new Serializable[0]);
    }

    public static enum TransferErrorCode implements HasI18nMatlabErrorId
    {
        ClientTransferInterrupted,
        SessionDestroyed,
        UnexpectedTransferError,
        LabTransferInterrupted,
        TransferCancelled,
        RemoteEndAlreadyHalted;

        private static final String RESOURCE_BASE_NAME = "com.mathworks.toolbox.distcomp.pmode.transfer.resources.RES_transfer";
        private static final String RESOURCE_BUNDLE_KEY_PREFIX = "parallel.peermessaging.";
        private static final String MATLAB_ERROR_ID_PREFIX = "parallel:peermessaging:";

        @Override
        public String getMatlabErrorId() {
            return MATLAB_ERROR_ID_PREFIX + this.toString();
        }

        @Override
        public String getResourceBundleName() {
            return RESOURCE_BASE_NAME;
        }

        @Override
        public String getBundleKey() {
            return RESOURCE_BUNDLE_KEY_PREFIX + this.toString();
        }

        @Override
        public String createMessage(Object ... objectArray) {
            return MessageGenerator.createMessage((BundleKey)this, true, objectArray);
        }

        @Override
        public String createLocalizedMessage(Object ... objectArray) {
            return MessageGenerator.createLocalizedMessage(this, true, objectArray);
        }
    }
}

