/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.process;

import com.mathworks.toolbox.distcomp.process.InvalidUserOrPasswordException;
import com.mathworks.toolbox.distcomp.process.ProcessImpl;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CommandLine {
    private List<String> fCommand = null;
    private File fDirectory = null;
    private boolean fRedirectErrorStream = false;
    private String fUser = null;
    private String fPassword = null;
    private Map<String, String> fEnvironment = CommandLine.copyCurrentEnvironment();
    private OutputStream fOutputRedirectStream = null;
    private OutputStream fErrorRedirectStream = null;

    private static Map<String, String> copyCurrentEnvironment() {
        Map<String, String> map = System.getenv();
        return new NoNullsHashMap<String, String>(map);
    }

    public CommandLine(List<String> list) {
        this.fCommand = list;
    }

    public CommandLine(String ... stringArray) {
        this.fCommand = new Vector<String>(Arrays.asList(stringArray));
    }

    public CommandLine command(String ... stringArray) {
        this.fCommand = new Vector<String>(Arrays.asList(stringArray));
        return this;
    }

    public CommandLine command(List<String> list) {
        this.fCommand = list;
        return this;
    }

    public List<String> command() {
        return this.fCommand;
    }

    public File directory() {
        return this.fDirectory;
    }

    public CommandLine directory(File file) {
        this.fDirectory = file;
        return this;
    }

    public CommandLine redirectErrorStream(boolean bl) {
        this.fRedirectErrorStream = bl;
        return this;
    }

    public boolean redirectErrorStream() {
        return this.fRedirectErrorStream;
    }

    public Map<String, String> environment() {
        return this.fEnvironment;
    }

    public CommandLine redirectOutput(OutputStream outputStream) {
        this.fOutputRedirectStream = outputStream;
        return this;
    }

    public CommandLine redirectError(OutputStream outputStream) {
        this.fErrorRedirectStream = outputStream;
        return this;
    }

    public CommandLine user(String string, String string2) {
        this.fUser = string;
        this.fPassword = string2;
        return this;
    }

    public Process start() throws IOException, InvalidUserOrPasswordException {
        String[] stringArray = this.getCommandArray();
        File file = this.getProcessWorkingDirectory();
        Map<String, String> map = this.environment();
        return this.startProcess(stringArray, file, map, this.redirectErrorStream(), this.fUser, this.fPassword);
    }

    public Process start(int n, long l) throws IOException, InvalidUserOrPasswordException {
        int n2 = n;
        boolean bl = false;
        while (true) {
            try {
                Process process = this.start();
                return process;
            }
            catch (IOException iOException) {
                if (--n2 <= 0) {
                    throw iOException;
                }
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected Process startProcess(String[] stringArray, File file, Map<String, String> map, boolean bl, String string, String string2) throws IOException, InvalidUserOrPasswordException {
        ProcessImpl processImpl = new ProcessImpl(this.fOutputRedirectStream, this.fErrorRedirectStream);
        processImpl.start(stringArray, file.getAbsolutePath(), map, bl, string, string2);
        return processImpl;
    }

    private File getProcessWorkingDirectory() {
        File file = this.directory();
        if (file == null) {
            file = new File(System.getProperty("user.dir"));
        }
        return file;
    }

    private String[] getCommandArray() {
        List<String> list = this.command();
        String[] stringArray = list.toArray(new String[list.size()]);
        return stringArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CommandLine commandLine = (CommandLine)object;
        if (this.fCommand != null ? !((Object)this.fCommand).equals(commandLine.fCommand) : commandLine.fCommand != null) {
            return false;
        }
        if (this.fDirectory != null ? !this.fDirectory.equals(commandLine.fDirectory) : commandLine.fDirectory != null) {
            return false;
        }
        if (this.fEnvironment != null ? !((Object)this.fEnvironment).equals(commandLine.fEnvironment) : commandLine.fEnvironment != null) {
            return false;
        }
        if (this.fPassword != null ? !this.fPassword.equals(commandLine.fPassword) : commandLine.fPassword != null) {
            return false;
        }
        return !(this.fUser != null ? !this.fUser.equals(commandLine.fUser) : commandLine.fUser != null);
    }

    public int hashCode() {
        int n = this.fCommand != null ? ((Object)this.fCommand).hashCode() : 0;
        n = 31 * n + (this.fDirectory != null ? this.fDirectory.hashCode() : 0);
        n = 31 * n + (this.fUser != null ? this.fUser.hashCode() : 0);
        n = 31 * n + (this.fPassword != null ? this.fPassword.hashCode() : 0);
        n = 31 * n + (this.fEnvironment != null ? ((Object)this.fEnvironment).hashCode() : 0);
        return n;
    }

    public String toString() {
        return "CommandLine{fCommand=" + this.fCommand + ", fDirectory=" + this.fDirectory + ", fUser='" + this.fUser + '\'' + ", fEnvironment=" + this.fEnvironment + '}';
    }

    static class NoNullsHashMap<K, V>
    extends HashMap<K, V> {
        NoNullsHashMap(Map<? extends K, ? extends V> map) {
            super(map);
        }

        @Override
        public V put(K k, V v) {
            if (k == null || v == null) {
                throw new NullPointerException();
            }
            return super.put(k, v);
        }
    }
}

