/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.PeerOrLocalShellSender;
import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.CopyCommand;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.ListFileAttributesCommand;
import com.mathworks.toolbox.distcomp.remote.NoCommonProtocolSetException;
import com.mathworks.toolbox.distcomp.remote.NoMatchingProtocolException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.ProtocolProvider;
import com.mathworks.toolbox.distcomp.remote.RemoveFileCommand;
import com.mathworks.toolbox.distcomp.remote.spi.Protocol;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSFTPCopier;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchShellSender;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.SshParameter;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RemoteExecutor {
    private static final ParametersAndProtocols SSH_SFTP_PARAMETERS_AND_PROTOCOLS = RemoteExecutor.createSshSftpParametersAndProtocols();
    private static final ParametersAndProtocols SC_PARAMETERS_AND_PROTOCOLS = RemoteExecutor.createScParametersAndProtocols();

    private RemoteExecutor() {
    }

    private static ParametersAndProtocols createSshSftpParametersAndProtocols() {
        JSchSFTPCopier jSchSFTPCopier = new JSchSFTPCopier();
        JSchShellSender jSchShellSender = new JSchShellSender();
        ParameterSet parameterSet = SshParameter.SSH_PARAMETER_SET;
        HashMap<Class<? extends Command>, Protocol> hashMap = new HashMap<Class<? extends Command>, Protocol>();
        hashMap.put(jSchShellSender.getCommandClass(), jSchShellSender);
        hashMap.put(CopyCommand.class, jSchSFTPCopier);
        hashMap.put(RemoveFileCommand.class, jSchSFTPCopier);
        hashMap.put(ListFileAttributesCommand.class, jSchSFTPCopier);
        return new ParametersAndProtocols(parameterSet, hashMap);
    }

    private static ParametersAndProtocols createScParametersAndProtocols() {
        PeerOrLocalShellSender peerOrLocalShellSender = new PeerOrLocalShellSender();
        ParameterSet parameterSet = peerOrLocalShellSender.getParameterSet();
        HashMap<Class<? extends Command>, Protocol> hashMap = new HashMap<Class<? extends Command>, Protocol>();
        hashMap.put(peerOrLocalShellSender.getCommandClass(), peerOrLocalShellSender);
        return new ParametersAndProtocols(parameterSet, hashMap);
    }

    private static ParametersAndProtocols selectParametersAndProtocols(PathUtils.PlatformType platformType, Set<Class<? extends Command>> set) throws NoCommonProtocolSetException {
        PathUtils.PlatformType platformType2 = PathUtils.Platform.getLocal().getPlatformType();
        if (PathUtils.PlatformType.WINDOWS == platformType2 && PathUtils.PlatformType.WINDOWS == platformType) {
            return SC_PARAMETERS_AND_PROTOCOLS;
        }
        if (RemoteExecutor.SSH_SFTP_PARAMETERS_AND_PROTOCOLS.hasProtocolForAll(set)) {
            return SSH_SFTP_PARAMETERS_AND_PROTOCOLS;
        }
        throw new NoCommonProtocolSetException(set);
    }

    public static ParameterSet getParameterSet(PathUtils.PlatformType platformType, Set<Class<? extends Command>> set) throws NoCommonProtocolSetException {
        return RemoteExecutor.selectParametersAndProtocols(platformType, set).getParameterSet();
    }

    public static Future execute(Command command, String string, ParameterMap parameterMap, PathUtils.PlatformType platformType) throws DispatchException, NoMatchingProtocolException, NoCommonProtocolSetException {
        Protocol protocol = RemoteExecutor.selectProtocol(command.getClass(), platformType);
        return protocol.execute(command, string, parameterMap);
    }

    static Protocol selectProtocol(Class<? extends Command> clazz, PathUtils.PlatformType platformType) throws NoCommonProtocolSetException, NoMatchingProtocolException {
        HashSet<Class<? extends Command>> hashSet = new HashSet<Class<? extends Command>>(1);
        hashSet.add(clazz);
        return RemoteExecutor.selectParametersAndProtocols(platformType, hashSet).selectProtocol(clazz);
    }

    public static ParameterSet getParameterSetForRecommendedProtocol(Class<? extends Command> clazz) throws NoMatchingProtocolException {
        Protocol protocol = RemoteExecutor.getRecommendedProtocol(clazz);
        return protocol.getParameterSet();
    }

    public static Future executeUsingRecommendedProtocol(Command command, String string, ParameterMap parameterMap) throws DispatchException, NoMatchingProtocolException {
        Protocol protocol = RemoteExecutor.getRecommendedProtocol(command.getClass());
        ParameterMap parameterMap2 = parameterMap.createCopy();
        return protocol.execute(command, string, parameterMap2);
    }

    public static Protocol getRecommendedProtocol(Class<? extends Command> clazz) throws NoMatchingProtocolException {
        List<Protocol> list = ProtocolProvider.getInstance().getProtocolsForCommand(clazz);
        try {
            return list.get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoMatchingProtocolException(clazz);
        }
    }

    private static final class ParametersAndProtocols {
        private final ParameterSet fParametersToGather;
        private final Map<Class<? extends Command>, Protocol> fProtocolsForCommands;

        ParametersAndProtocols(ParameterSet parameterSet, Map<Class<? extends Command>, Protocol> map) {
            this.fParametersToGather = parameterSet;
            this.fProtocolsForCommands = map;
        }

        ParameterSet getParameterSet() {
            return this.fParametersToGather;
        }

        Protocol selectProtocol(Class<? extends Command> clazz) throws NoMatchingProtocolException {
            Protocol protocol = null;
            for (Class<? extends Command> clazz2 : this.fProtocolsForCommands.keySet()) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                protocol = this.fProtocolsForCommands.get(clazz2);
            }
            if (protocol == null) {
                throw new NoMatchingProtocolException(clazz, this.fProtocolsForCommands.keySet());
            }
            return protocol;
        }

        private boolean hasProtocolForAll(Set<Class<? extends Command>> set) {
            for (Class<? extends Command> clazz : set) {
                if (this.hasProtocolFor(clazz)) continue;
                return false;
            }
            return true;
        }

        private boolean hasProtocolFor(Class<? extends Command> clazz) {
            for (Class<? extends Command> clazz2 : this.fProtocolsForCommands.keySet()) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }
    }
}

