/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.RemoteStreamException;
import com.mathworks.toolbox.distcomp.remote.ShellFuture;
import com.mathworks.toolbox.distcomp.remote.util.OutputRedirector;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;

public class SimpleShellFuture
implements Future {
    private final ShellFuture fShellFuture;
    private final ByteArrayOutputStream fErrorSink;
    private final ByteArrayOutputStream fOutputSink;
    private final OutputRedirector fOutputRedirector;

    public SimpleShellFuture(ShellFuture shellFuture) throws RemoteStreamException {
        this.fShellFuture = shellFuture;
        this.fErrorSink = new ByteArrayOutputStream();
        this.fOutputSink = new ByteArrayOutputStream();
        this.fOutputRedirector = new OutputRedirector(this.fShellFuture.getInputStream(), this.fShellFuture.getErrorStream(), this.fOutputSink, this.fErrorSink);
    }

    @Override
    public void cancel() {
        this.fShellFuture.cancel();
    }

    @Override
    public boolean isRunning() {
        return this.fShellFuture.isRunning();
    }

    @Override
    public void awaitEnd() throws InterruptedException, FulfillmentException {
        this.fShellFuture.awaitEnd();
        this.fOutputRedirector.close();
    }

    public boolean isExitStatusOfRemoteCommand() {
        return this.fShellFuture.isExitStatusOfRemoteCommand();
    }

    public int getExitStatus() throws InterruptedException, FulfillmentException {
        return this.fShellFuture.getExitStatus();
    }

    public String getErrorString() throws FulfillmentException, InterruptedException {
        this.fShellFuture.awaitEnd();
        return this.fErrorSink.toString();
    }

    public String getOutputString() throws FulfillmentException, InterruptedException {
        this.fShellFuture.awaitEnd();
        return this.fOutputSink.toString();
    }

    public static Map<String, SimpleShellFuture> createSimpleShellFutures(Map<String, ? extends Future> map) throws RemoteStreamException {
        HashMap<String, SimpleShellFuture> hashMap = new HashMap<String, SimpleShellFuture>(map.size());
        for (String string : map.keySet()) {
            Future future = map.get(string);
            assert (future instanceof ShellFuture) : "A Future in hostsToShellFutures is not a ShellFuture, but is a " + future.getClass();
            ShellFuture shellFuture = (ShellFuture)future;
            hashMap.put(string, new SimpleShellFuture(shellFuture));
        }
        return hashMap;
    }
}

