/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.cli;

import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.cli.CommandExecutor;
import com.mathworks.toolbox.distcomp.remote.cli.CommandLineCanceledException;
import com.mathworks.toolbox.distcomp.remote.cli.CommandLineParser;
import com.mathworks.toolbox.distcomp.remote.cli.CommandSpecifier;
import com.mathworks.toolbox.distcomp.remote.cli.FactoryRegistry;
import com.mathworks.toolbox.distcomp.remote.cli.InternalStateException;
import com.mathworks.toolbox.distcomp.remote.cli.ResourceHandler;
import com.mathworks.toolbox.distcomp.remote.cli.UserPrompt;
import java.util.List;

public final class CommandLine {
    public static void main(String[] stringArray) {
        CommandLine.setupLogging();
        FactoryRegistry factoryRegistry = new FactoryRegistry();
        factoryRegistry.registerDefaultCommandFactories();
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.addDefaultResourceBundle();
        try {
            int n = CommandLine.parseAndExecute(stringArray, factoryRegistry, resourceHandler);
            System.exit(n);
        }
        catch (CommandLineCanceledException commandLineCanceledException) {
            System.exit(-1);
        }
        catch (InternalStateException internalStateException) {
            internalStateException.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public static int parseAndExecute(String[] stringArray, FactoryRegistry factoryRegistry, ResourceHandler resourceHandler) {
        Object object;
        CommandLineParser commandLineParser = new CommandLineParser(stringArray, factoryRegistry, resourceHandler);
        CommandSpecifier commandSpecifier = commandLineParser.getCommandSpecifier();
        List<String> list = commandLineParser.getHostnames();
        boolean bl = commandLineParser.isQuiet();
        if (!bl) {
            object = new UserPrompt(resourceHandler);
            if (commandSpecifier.getProtocol() == null) {
                commandSpecifier.setProtocol(((UserPrompt)object).promptForProtocol(commandSpecifier.getCommand().getClass()));
            }
            ((UserPrompt)object).promptForParameters(commandSpecifier);
        }
        if (commandSpecifier.getProtocol() != null) {
            Logger.LOGGER.fine("CommandExecutor.protocol: " + commandSpecifier.getProtocol().getProtocolName());
        }
        Logger.LOGGER.fine("CommandExecutor.protocolMap:\n" + commandSpecifier.getProtocolParameterMap().toString());
        object = new CommandExecutor();
        return ((CommandExecutor)object).execute(commandSpecifier.getCommand(), commandSpecifier.getProtocolParameterMap(), list, commandSpecifier.getProtocol());
    }

    public static void setupLogging() {
        Logger.LOGGER.setUseParentHandlers(false);
    }
}

