/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.cli;

import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.cli.CommandFactory;
import com.mathworks.toolbox.distcomp.remote.cli.CopyCommandFactory;
import com.mathworks.toolbox.distcomp.remote.cli.ShellCommandFactory;
import com.mathworks.toolbox.distcomp.remote.cli.TunnelCommandFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class FactoryRegistry {
    private final Map<String, Class<? extends Command>> fCommandClassByType = new HashMap<String, Class<? extends Command>>();
    private final Map<Class<? extends Command>, CommandFactory<? extends Command>> fFactoryByCommandClass = new HashMap<Class<? extends Command>, CommandFactory<? extends Command>>();

    public void registerDefaultCommandFactories() {
        this.registerCommandFactory(new ShellCommandFactory());
        this.registerCommandFactory(new CopyCommandFactory());
        this.registerCommandFactory(new TunnelCommandFactory());
    }

    public void registerCommandFactory(CommandFactory<? extends Command> commandFactory) {
        this.fCommandClassByType.put(commandFactory.getCommandType(), commandFactory.getCommandClass());
        this.fFactoryByCommandClass.put(commandFactory.getCommandClass(), commandFactory);
    }

    public Class<? extends Command> getCommandClassByType(String string) {
        return this.fCommandClassByType.get(string);
    }

    public CommandFactory<?> getFactoryByCommandClass(Class<? extends Command> clazz) {
        return this.fFactoryByCommandClass.get(clazz);
    }

    public boolean isCommandTypeRegistered(String string) {
        return this.fCommandClassByType.containsKey(string);
    }

    public Set<String> getCommandTypes() {
        return this.fCommandClassByType.keySet();
    }
}

