/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.cli;

import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.cli.InternalStateException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ResourceHandler {
    private static final String RESOURCE_BASENAME = "com.mathworks.toolbox.distcomp.remote.resources.RES_remote";
    private final LinkedList<ResourceBundle> fResourceBundles = new LinkedList();

    public final void addDefaultResourceBundle() {
        this.addResourceBundle(RESOURCE_BASENAME);
    }

    public final void addResourceBundle(String string) {
        this.fResourceBundles.addFirst(ResourceBundle.getBundle(string));
    }

    String getResourceKey(Parameter<?> parameter) {
        return this.getResourceKey(parameter.getIdentifier());
    }

    String getResourceValue(Parameter<?> parameter) {
        return this.getResourceValue(parameter.getIdentifier());
    }

    String getResourcePrompt(Parameter<?> parameter) {
        return this.getResourcePrompt(parameter.getIdentifier());
    }

    String getResourceDescription(Parameter<?> parameter) {
        return this.getResourceDescription(parameter.getIdentifier());
    }

    boolean isResourceUndocumented(Parameter<?> parameter) {
        return this.isResourceUndocumented(parameter.getIdentifier());
    }

    String getResourceKey(String string) {
        try {
            return this.getResourceString(this.createKey(string, "KEY"));
        }
        catch (MissingResourceException missingResourceException) {
            throw new InternalStateException((Throwable)missingResourceException){};
        }
    }

    String getResourceValue(String string) {
        try {
            return this.getResourceString(this.createKey(string, "VALUE"));
        }
        catch (MissingResourceException missingResourceException) {
            return "";
        }
    }

    String getResourcePrompt(String string) {
        String string2 = this.getResourceKey(string);
        try {
            return this.getResourceString(this.createKey(string, "PROMPT")) + " (" + string2 + ")";
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    String getResourceDescription(String string) {
        try {
            return this.getResourceString(this.createKey(string, "DESC"));
        }
        catch (MissingResourceException missingResourceException) {
            return "No description available.";
        }
    }

    boolean isResourceUndocumented(String string) {
        try {
            return "true".equals(this.getResourceString(this.createKey(string, "UNDOCUMENTED")));
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }

    private String createKey(String string, String string2) {
        return string + "." + string2;
    }

    private String getResourceString(String string) {
        Iterator iterator = this.fResourceBundles.iterator();
        while (iterator.hasNext()) {
            ResourceBundle resourceBundle = (ResourceBundle)iterator.next();
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (iterator.hasNext()) continue;
                throw missingResourceException;
            }
        }
        throw new MissingResourceException("Missing resource", RESOURCE_BASENAME, string);
    }
}

